/*
 * Decompiled with CFR 0.152.
 */
package florent.gun.utils;

import florent.pattern.Frame;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import robocode.AdvancedRobot;

public class BigFrame
extends Frame
implements Comparator {
    private static final boolean DEBUG = false;
    public static final double NO_DATA = -100000.0;
    protected static final double MAX_VELOCITY = 8.0;
    protected static final double MAX_15 = 120.0;
    protected static final double MAX_30 = 240.0;
    protected static final double MAX_60 = 480.0;
    protected static final double MAX_120 = 960.0;
    protected static final double MAX_DELTA_HEADING = Math.toRadians(10.0);
    protected static double MAX_CORNER;
    protected static double MAX_WALL;
    protected static double MAX_DISTANCE;
    protected static Rectangle2D.Double BF;
    protected static final double WALL_MARGIN = 18.0;
    protected static Line2D.Double[] WALLS;
    protected static Point2D.Double[] CORNERS;
    protected static final double fact15 = 4500.0;
    protected static final double fact30 = 2500.0;
    protected static final double fact60 = 4500.0;
    protected static final double fact120 = 1000.0;
    protected static final double factDistance = 1000.0;
    protected static final double factWall = 1000.0;
    protected static final double factDeltaHeading = 0.0;
    protected static final double factVelocity = 1000.0;
    protected static final double factApproach = 500.0;
    protected static final double factLateral = 500.0;
    protected double distance15;
    protected double distance30;
    protected double distance60;
    protected double distance120;
    protected double wallDistance;
    protected double approachVelocity;
    protected double lateralVelocity;
    protected double distance;

    public static void init(AdvancedRobot me) {
        BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        MAX_WALL = Math.min(BigFrame.BF.width, BigFrame.BF.height) / 2.0;
        MAX_DISTANCE = Math.sqrt(Math.pow(BigFrame.BF.height, 2.0) + Math.pow(BigFrame.BF.width, 2.0));
        WALLS = new Line2D.Double[4];
        BigFrame.WALLS[0] = new Line2D.Double(BF.getMinX(), BF.getMinY(), BF.getMaxX(), BF.getMinY());
        BigFrame.WALLS[1] = new Line2D.Double(BF.getMinX(), BF.getMaxY(), BF.getMaxX(), BF.getMaxY());
        BigFrame.WALLS[2] = new Line2D.Double(BF.getMinX(), BF.getMinY(), BF.getMinX(), BF.getMaxY());
        BigFrame.WALLS[3] = new Line2D.Double(BF.getMaxX(), BF.getMinY(), BF.getMaxX(), BF.getMaxY());
        CORNERS = new Point2D.Double[4];
        BigFrame.CORNERS[0] = new Point2D.Double(BF.getMinX(), BF.getMinY());
        BigFrame.CORNERS[1] = new Point2D.Double(BF.getMinX(), BF.getMaxY());
        BigFrame.CORNERS[2] = new Point2D.Double(BF.getMaxX(), BF.getMaxY());
        BigFrame.CORNERS[3] = new Point2D.Double(BF.getMaxX(), BF.getMinY());
        MAX_CORNER = CORNERS[0].distance(CORNERS[2]);
    }

    public BigFrame(double deltaHeading, double velocity) {
        super(deltaHeading, velocity);
    }

    public BigFrame(Point2D targetLocation, double deltaHeading, double velocity, double approachVelocity, double lateralVelocity, double distance, double distance15, double distance30, double distance60, double distance120) {
        super(deltaHeading, velocity);
        this.approachVelocity = approachVelocity;
        this.lateralVelocity = lateralVelocity;
        this.distance = Math.sqrt(distance);
        this.distance120 = distance120;
        this.distance15 = distance15;
        this.distance30 = distance30;
        this.distance60 = distance60;
        this.wallDistance = Math.sqrt(this.getWallDistance(targetLocation));
    }

    public int compareTo(BigFrame frame) {
        int val = this.distance15 == -100000.0 || frame.getDistance15() == -100000.0 ? 0 : (int)(Math.pow(this.distance15 / 120.0 - frame.getDistance15() / 120.0, 2.0) * 4500.0);
        val += this.distance30 == -100000.0 || frame.getDistance30() == -100000.0 ? 0 : (int)(Math.pow(this.distance30 / 240.0 - frame.getDistance30() / 240.0, 2.0) * 2500.0);
        val += this.distance60 == -100000.0 || frame.getDistance60() == -100000.0 ? 0 : (int)(Math.pow(this.distance60 / 480.0 - frame.getDistance60() / 480.0, 2.0) * 4500.0);
        val += this.distance120 == -100000.0 || frame.getDistance120() == -100000.0 ? 0 : (int)(Math.pow(this.distance120 / 960.0 - frame.getDistance120() / 960.0, 2.0) * 1000.0);
        val += (int)(Math.pow(this.distance / MAX_DISTANCE - frame.getDistance() / MAX_DISTANCE, 2.0) * 1000.0);
        val += (int)(Math.pow(this.deltaHeading / MAX_DELTA_HEADING - frame.getDeltaHeading() / MAX_DELTA_HEADING, 2.0) * 0.0);
        val += (int)(Math.pow(this.wallDistance / 120.0 - frame.getWallDistance() / MAX_WALL, 2.0) * 1000.0);
        val += (int)(Math.pow(this.velocity / 8.0 - frame.getVelocity() / 8.0, 2.0) * 1000.0);
        val += (int)(Math.pow(this.lateralVelocity / 120.0 - frame.getLateralVelocity() / 8.0, 2.0) * 500.0);
        return val += (int)(Math.pow(this.approachVelocity / 120.0 - frame.getApproachVelocity() / 8.0, 2.0) * 500.0);
    }

    private double getWallDistance(Point2D location) {
        double best = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < 4) {
            if (WALLS[i].ptLineDist(location) < best) {
                best = WALLS[i].ptLineDist(location);
            }
            ++i;
        }
        return best;
    }

    public double getApproachVelocity() {
        return this.approachVelocity;
    }

    public void setApproachVelocity(double approachVelocity) {
        this.approachVelocity = approachVelocity;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance120() {
        return this.distance120;
    }

    public void setDistance120(double distance120) {
        this.distance120 = distance120;
    }

    public double getDistance15() {
        return this.distance15;
    }

    public void setDistance15(double distance15) {
        this.distance15 = distance15;
    }

    public double getDistance30() {
        return this.distance30;
    }

    public void setDistance30(double distance30) {
        this.distance30 = distance30;
    }

    public double getDistance60() {
        return this.distance60;
    }

    public void setDistance60(double distance60) {
        this.distance60 = distance60;
    }

    public double getLateralVelocity() {
        return this.lateralVelocity;
    }

    public void setLateralVelocity(double lateralVelocity) {
        this.lateralVelocity = lateralVelocity;
    }

    public double getWallDistance() {
        return this.wallDistance;
    }

    public void setWallDistance(double wallDistance) {
        this.wallDistance = wallDistance;
    }

    public int compare(Object arg0, Object arg1) {
        try {
            return this.compareTo((BigFrame)arg0) - this.compareTo((BigFrame)arg1);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String toString() {
        String res = "distance15:" + this.distance15 + "|distance30:" + this.distance30 + "|distance60:" + this.distance60 + "|distance120:" + this.distance120;
        res = String.valueOf(res) + "|wall:" + this.wallDistance + "|velocity:" + this.velocity + "|deltaHeading:" + this.deltaHeading;
        return res;
    }
}

