/*
 * Decompiled with CFR 0.152.
 */
package florent.move;

import florent.BattleField;
import florent.FloatingTadpole;
import florent.jUtil;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Mirror {
    private double awayFactor = 1.0;
    private BattleField BF;
    private AdvancedRobot me;
    private Point2D.Double lastEnemyLocation;
    private Point2D.Double enemyLocation;
    private Point2D.Double myLocation;
    private Point2D.Double center;
    private Point2D.Double mirrorMyLocation;

    public Mirror(AdvancedRobot me) {
        this.me = me;
        this.BF = new BattleField(me);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastEnemyLocation = this.enemyLocation;
        this.myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        this.enemyLocation = jUtil.projectMotion(this.myLocation, this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        if (this.lastEnemyLocation == null) {
            this.lastEnemyLocation = this.enemyLocation;
        }
        this.center = jUtil.projectMotion(this.lastEnemyLocation, jUtil.absoluteBearing(this.lastEnemyLocation, this.myLocation), e.getDistance() / 2.0);
        double tolerance = 0.0;
        do {
            this.mirrorMyLocation = jUtil.projectMotion(this.enemyLocation, jUtil.absoluteBearing(this.enemyLocation, this.center), (e.getDistance() + tolerance) * this.awayFactor);
        } while (!this.BF.contains(this.mirrorMyLocation) && !this.BF.contains(jUtil.projectMotion(this.enemyLocation, jUtil.absoluteBearing(this.enemyLocation, this.center), (e.getDistance() + (tolerance -= 5.0) - 5.0) * this.awayFactor)));
    }

    public void doMove() {
        double theta = FloatingTadpole.absoluteBearing(this.myLocation, this.mirrorMyLocation) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    public void setAwayFactor(double awayFactor) {
        this.awayFactor = awayFactor;
    }
}

