/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duration
implements Continuum<Duration>,
AbsoluteToRelative<Duration, Duration> {
    public static final Duration A_TURN = new Duration(1.0);
    private final double turns;

    public Duration(double turns) {
        assert (!Double.isNaN(turns));
        this.turns = (double)Math.round(turns * 1000000.0) / 1000000.0;
    }

    @Override
    public Duration negate() {
        return new Duration(-this.turns);
    }

    @Override
    public Duration abs() {
        return new Duration(Math.abs(this.turns));
    }

    @Override
    public Duration plus(Duration duration) {
        return new Duration(this.turns + duration.turns);
    }

    @Override
    public Duration minus(Duration duration) {
        return new Duration(this.turns - duration.turns);
    }

    @Override
    public Duration times(double d) {
        return new Duration(this.turns * d);
    }

    @Override
    public Duration divide(double d) {
        return new Duration(this.turns / d);
    }

    @Override
    public double divide(Duration t) {
        return this.turns / t.turns;
    }

    @Override
    public double toDouble() {
        return this.turns;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.turns)) + "t";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Duration)) {
            return false;
        }
        Duration d = (Duration)o;
        return d.turns == this.turns;
    }

    public int hashCode() {
        return new Double(this.turns).hashCode();
    }
}

