/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.morfeas.EnemyState;
import gre.svman4.morfeas.MelleeMovementStrategy;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import robocode.AdvancedRobot;

public class MinimumRiskMovement
extends MelleeMovementStrategy {
    public static double MIN_DISTANCE = 80.0;
    public static final int POINTS_COUNTER = 100;
    private double[] eval = new double[100];
    Point2D.Double lastPosition = new Point2D.Double();
    private FieldPoint[] points = new FieldPoint[100];

    public MinimumRiskMovement(RobotState me, Rectangle2D.Double movingPlace, HashMap<String, EnemyState> enemies) {
        super(me, movingPlace, enemies);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new FieldPoint(0.0, 0.0);
        }
    }

    public double evaluate(FieldPoint point, double addLast) {
        double ath = addLast * 0.8 / point.distanceSq(this.lastPosition);
        for (EnemyState en : this.enemies.values()) {
            if (!en.isAlive) continue;
            ath += Math.min(en.energy / this._mineRobot.energy, 2.0) * (1.0 + Math.abs(Math.cos(this._mineRobot.getAngleTo(point) - en.getAngleTo(point)))) / point.distanceSq(en);
        }
        return ath;
    }

    @Override
    public Color getColor() {
        return Color.BLUE;
    }

    @Override
    public String getName() {
        return "MinimumRiskMovement";
    }

    @Override
    public void onPaint(Graphics2D g) {
        int i;
        super.onPaint(g);
        g.fillOval((int)(this.lastPosition.x - 1.5), (int)(this.lastPosition.y - 1.5), 3, 3);
        double biggestEval = Double.MIN_VALUE;
        double lowerEval = Double.MAX_VALUE;
        for (i = 0; i < 100; ++i) {
            if (this.eval[i] > biggestEval) {
                biggestEval = this.eval[i];
                continue;
            }
            if (!(this.eval[i] < lowerEval)) continue;
            lowerEval = this.eval[i];
        }
        for (i = 0; i < 100; ++i) {
            if (!this._movingPlace.contains(this.points[i])) continue;
            g.setColor(this.getColor(lowerEval, this.eval[i], biggestEval));
            g.fillOval((int)(this.points[i].x - 2.0), (int)(this.points[i].y - 2.0), 4, 4);
        }
    }

    @Override
    public void run(AdvancedRobot robot) {
        int counter = 0;
        double distance = MIN_DISTANCE;
        double betterEval = Double.MAX_VALUE;
        double addLast = 1.0 - Math.rint(Math.pow(0.3, this.enemies.size()));
        do {
            double angle = (double)counter / 100.0 * 2.0 * Math.PI;
            this.points[counter].setLocation(this._mineRobot.project(distance, angle));
            this.eval[counter] = this.evaluate(this.points[counter], addLast);
            if (!this._movingPlace.contains(this.points[counter]) || !(this.eval[counter] < betterEval)) continue;
            this._nextPosition.setLocation(this.points[counter]);
            betterEval = this.eval[counter];
        } while (++counter < 100);
        this.goTo(this._nextPosition, robot);
        if (Math.abs(this.lastPosition.distance(this._mineRobot)) > 50.0) {
            this.lastPosition.setLocation(this._mineRobot);
        }
    }
}

