/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import techdude.forest.AvoidWallCondition;
import techdude.forest.CustomTechDudeEvent;
import techdude.forest.FightingManager;
import techdude.forest.FinishedMovingGunCondition;
import techdude.forest.FinishedScanningCondition;
import techdude.forest.MoveManager;
import techdude.forest.MultiFightStrategy;
import techdude.forest.MultiMovementStrategy;
import techdude.forest.PatternAnalyzer;
import techdude.forest.RadarManager;
import techdude.forest.SingleFightStrategy;
import techdude.forest.SingleMovementStrategy;
import techdude.forest.VictoryDance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FlamingForest
extends AdvancedRobot {
    public static final short FORWARD = 1;
    public static final short BACKWARDS = -1;
    public static double FIELD_WIDTH;
    public static double FIELD_HEIGHT;
    protected static RadarManager m_radarManager;
    protected static Hashtable m_scannedInformation;
    protected static boolean debugMode;
    protected static Random random;
    protected static List m_bulletsShots;
    protected static PatternAnalyzer m_analyzer;
    protected static PrintStream TechDudeStream;
    protected static long gameTime;
    protected FightingManager m_fightManager;
    protected MoveManager m_moveManager;
    protected short m_direction;

    public void run() {
        try {
            TechDudeStream = this.out;
            m_bulletsShots = new ArrayList();
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(false);
            FIELD_WIDTH = this.getBattleFieldWidth();
            FIELD_HEIGHT = this.getBattleFieldHeight();
            this.m_fightManager = new FightingManager(this);
            this.m_moveManager = new MoveManager(this);
            FlamingForest.print("Adding Strategies to Managers...");
            this.populateFightManager();
            this.populateMoveManager();
            this.setColors(Color.green, Color.orange, Color.green);
            this.setEventPriority("ScannedRobotEvent", 90);
            this.setEventPriority("HitByBulletEvent", 85);
            if (m_scannedInformation == null) {
                m_scannedInformation = new Hashtable(this.getOthers());
                FlamingForest.debug("Init Enemy Information Hash...");
            }
            if (m_analyzer == null) {
                m_analyzer = new PatternAnalyzer(this);
            }
            if (m_radarManager == null) {
                m_radarManager = new RadarManager(this);
            }
            FlamingForest.debug("Adding Custom Events");
            FlamingForest.print("Activating Custom Events...");
            this.addCustomEvent(new FinishedScanningCondition(this));
            this.addCustomEvent(new AvoidWallCondition(this));
            this.addCustomEvent((Condition)new FinishedMovingGunCondition(this));
            FlamingForest.print("Activating Strategy Managers and Analyzers...");
            m_analyzer.startAnalyzer();
            this.m_fightManager.selectBestStrategy();
            this.m_moveManager.selectBestStrategy();
            while (true) {
                gameTime = this.getTime();
                this.m_moveManager.operate();
                this.execute();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (m_analyzer != null) {
                m_analyzer.stopAnalyzer();
            }
            this.printStats();
            throw throwable;
        }
    }

    public void populateMoveManager() {
        this.m_moveManager.addStrategy(new SingleMovementStrategy(this));
        this.m_moveManager.addStrategy(new MultiMovementStrategy(this));
        this.m_moveManager.addStrategy(new VictoryDance(this));
    }

    public void populateFightManager() {
        this.m_fightManager.addStrategy(new SingleFightStrategy(this));
        this.m_fightManager.addStrategy(new MultiFightStrategy(this));
    }

    public void reverseDirection() {
        this.m_direction = (short)(this.m_direction * -1);
        this.setAhead(Math.abs(this.getDistanceRemaining()));
    }

    public static void debug(String in_message) {
        if (debugMode) {
            TechDudeStream.println(in_message);
        }
    }

    public static void print(String in_message) {
        TechDudeStream.println(in_message);
    }

    public void printStats() {
        double bulletsShot = m_bulletsShots.size();
        double bulletsHit = 0.0;
        double bulletsMissed = 0.0;
        double lifeLostFromShot = 0.0;
        double stillInMotion = 0.0;
        double netDamage = 0.0;
        Bullet tempBullet = null;
        int iCounter = 0;
        while ((double)iCounter < bulletsShot) {
            tempBullet = (Bullet)m_bulletsShots.get(iCounter);
            if (tempBullet != null) {
                lifeLostFromShot += tempBullet.getPower();
                if (!tempBullet.isActive()) {
                    if (tempBullet.getVictim() == null) {
                        bulletsMissed += 1.0;
                    } else {
                        netDamage += (double)4 * tempBullet.getPower() + (tempBullet.getPower() > 1.0 ? (double)2 * tempBullet.getPower() - 1.0 : 0.0);
                        bulletsHit += 1.0;
                    }
                } else {
                    stillInMotion += 1.0;
                }
            }
            ++iCounter;
        }
        FlamingForest.print("\n----------- FlamingForest Stats ------------");
        FlamingForest.print("Bullets Shot: " + bulletsShot);
        FlamingForest.print("% Bullets Hit: " + Math.round(bulletsHit / bulletsShot * 100.0) + '%');
        FlamingForest.print("% Bullets Missed: " + Math.round(bulletsMissed / bulletsShot * 100.0) + '%');
        FlamingForest.print("% Bullets Still In Action: " + Math.round(stillInMotion / bulletsShot * 100.0) + '%');
        FlamingForest.print("Energy Gained From Hitting: " + Math.round(netDamage));
        FlamingForest.print("Energy Lost From Shooting: " + Math.round(lifeLostFromShot));
        FlamingForest.print("Net Enery Lost/Gained From Shots Fired: " + Math.round(netDamage - lifeLostFromShot));
        FlamingForest.print("Net Damage Inflicted To All: " + Math.round(netDamage));
        FlamingForest.print("--------------------------------------\n");
    }

    public void onCustomEvent(CustomEvent in_event) {
        if (in_event.getCondition() instanceof CustomTechDudeEvent) {
            ((CustomTechDudeEvent)in_event.getCondition()).handleEvent();
        }
    }

    public void onScannedRobot(ScannedRobotEvent in_event) {
        m_radarManager.onScannedRobot(in_event);
    }

    public void onHitRobot(HitRobotEvent in_event) {
        this.m_fightManager.getStrategy().gotCollision(in_event);
        this.m_moveManager.getStrategy().gotCollision(in_event);
    }

    public void onHitByBullet(HitByBulletEvent in_event) {
        this.m_fightManager.getStrategy().gotShot(in_event);
        this.m_moveManager.getStrategy().gotShot(in_event);
    }

    public void setAhead(double distance) {
        super.setAhead(distance *= (double)this.m_direction);
    }

    public void setBack(double distance) {
        super.setBack(distance *= (double)this.m_direction);
    }

    public String getName() {
        return " ~*|FlamingForest|*~ ";
    }

    private final /* synthetic */ void this() {
        this.m_fightManager = null;
        this.m_moveManager = null;
        this.m_direction = 1;
    }

    public FlamingForest() {
        this.this();
    }

    static {
        m_radarManager = null;
        m_scannedInformation = null;
        debugMode = false;
        random = new Random();
        m_bulletsShots = null;
        m_analyzer = null;
        TechDudeStream = null;
        gameTime = 0L;
    }
}

