/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import robocode.ScannedRobotEvent;
import techdude.forest.FlamingForest;
import techdude.forest.TechDudeMath;
import techdude.forest.TechDudeRecord;
import techdude.forest.TechDudeRecordCollection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RadarManager {
    private static final short THREE_SIXTY_SCANNING = 0;
    private static final short TARGETTED = 1;
    private static final short RADAR_MOVING_LEFT = -1;
    private static final short RADAR_MOVING_RIGHT = 1;
    private static final double SWEEP_RADIUS = 0.39269908169872414;
    private static final int RESAMPLE_TIME = 15;
    private short m_scanMode;
    private short m_targetMovingDirection;
    private TechDudeRecord m_currentTarget;
    private FlamingForest m_owner;
    private int m_ResampleCounter;

    public void instructRadar() {
        switch (this.m_scanMode) {
            case 1: {
                if (this.m_ResampleCounter < 15 || this.m_targetMovingDirection != -1 || this.m_owner.getOthers() <= 1) {
                    TechDudeRecordCollection col = (TechDudeRecordCollection)FlamingForest.m_scannedInformation.get(this.m_currentTarget.getName());
                    if (col.isCurrent()) {
                        this.m_targetMovingDirection = (short)(this.m_targetMovingDirection * -1);
                        double bearing = TechDudeMath.getAngleToXYCoordExcludeFacing(this.m_currentTarget.getX(), this.m_currentTarget.getY(), this.m_owner);
                        double expectedRadarAngle = TechDudeMath.normalAbsoluteAngle(bearing + 0.39269908169872414 * (double)this.m_targetMovingDirection);
                        this.m_owner.setTurnRadarRightRadians(TechDudeMath.normalRelativeAngle(expectedRadarAngle - this.m_owner.getRadarHeadingRadians()));
                        if (this.m_owner.getOthers() > 1) {
                            ++this.m_ResampleCounter;
                        }
                        return;
                    }
                    this.m_scanMode = 0;
                    this.m_ResampleCounter = 0;
                } else {
                    this.m_owner.setTurnRadarRightRadians(Math.PI * 2);
                    this.m_ResampleCounter = 0;
                    return;
                }
            }
            case 0: {
                this.m_owner.setTurnRadarRightRadians(Math.PI * 2);
                return;
            }
        }
        throw new InternalError("Scan Mode Is Set To Some Odd Value");
    }

    public void setTarget(TechDudeRecord in_target) {
        if (in_target != null) {
            this.m_currentTarget = in_target;
        }
    }

    public void onScannedRobot(ScannedRobotEvent in_event) {
        TechDudeRecord scannedRobot = TechDudeMath.convertSCEToTechDudeRecord(in_event, this.m_owner);
        TechDudeRecordCollection collection = (TechDudeRecordCollection)FlamingForest.m_scannedInformation.get(scannedRobot.getName());
        if (this.m_owner.getOthers() > 2) {
            this.m_scanMode = 0;
        } else if (this.m_currentTarget != null) {
            this.m_scanMode = 1;
        }
        if (collection == null) {
            collection = new TechDudeRecordCollection(this.m_owner);
            FlamingForest.m_scannedInformation.put(scannedRobot.getName(), collection);
        }
        collection.addTechDudeRecord(scannedRobot);
        if (this.m_scanMode == 1 && scannedRobot.getName() == this.m_currentTarget.getName()) {
            this.m_currentTarget = scannedRobot;
        }
    }

    private final /* synthetic */ void this() {
        this.m_scanMode = 0;
        this.m_targetMovingDirection = 1;
        this.m_currentTarget = null;
        this.m_owner = null;
        this.m_ResampleCounter = 0;
    }

    public RadarManager(FlamingForest in_owner) {
        this.this();
        this.m_owner = in_owner;
    }
}

