/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import lazarecki.robot.ModularRobot;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.StrategicModule;
import lazarecki.util.RoboUtils;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class FirePowerManagementModule
extends StrategicModule {
    private double optimalFirePower;
    private double optimalDistance;
    private double noShootingEnergyLevel;
    private double firePower;

    public FirePowerManagementModule(double optimalFirePower, double optimalDistance, double noShootingEnergyLevel) {
        this.optimalFirePower = optimalFirePower;
        this.optimalDistance = optimalDistance;
        this.noShootingEnergyLevel = noShootingEnergyLevel;
        this.firePower = optimalFirePower;
    }

    public double getOptimalFirePower() {
        return this.optimalFirePower;
    }

    public double getOptimalDistance() {
        return this.optimalDistance;
    }

    public double getNoShootingEnergyLevel() {
        return this.noShootingEnergyLevel;
    }

    public double getFirePower() {
        return this.firePower;
    }

    public double firePowerForDistance(double distance) {
        return (20.0 - Rules.getBulletSpeed((double)this.optimalFirePower) * distance / this.optimalDistance) / 3.0;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        ModularRobot robot = this.getRobot();
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        RobotInfo targetInfo = new RobotInfo(event, this.getRobot());
        double distance = myInfo.distance(targetInfo);
        this.firePower = RoboUtils.limit(1.0, this.firePowerForDistance(distance), 3.0);
        if (targetInfo.getEnergy() == 0.0) {
            robot.setFirePower(0.1);
        } else if (distance < 120.0) {
            robot.setFirePower(Math.min(3.0, myInfo.getEnergy() - 0.1));
        } else if (robot.getEnergy() < this.noShootingEnergyLevel) {
            robot.setFirePower(0.0);
        } else {
            robot.setFirePower(RoboUtils.limit(0.1, this.firePower, Math.min(this.firePowerToKill(event.getEnergy()), robot.getEnergy() / 4.0)));
        }
    }

    protected double firePowerToKill(double energy) {
        double firePower = (energy + 2.0) / 6.0;
        if (firePower <= 1.0) {
            firePower = energy / 4.0;
        }
        return firePower;
    }
}

