/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.util.LinkedList;
import java.util.List;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.StrategicModule;
import lazarecki.util.RoboUtils;
import robocode.ScannedRobotEvent;

public class HistoryTrackingModule
extends StrategicModule {
    private List<RobotInfo> myHistory;
    private List<RobotInfo> targetHistory;
    private int maxEntries;

    public HistoryTrackingModule(int maxEntries) {
        this.maxEntries = maxEntries;
        this.myHistory = new LinkedList<RobotInfo>();
        this.targetHistory = new LinkedList<RobotInfo>();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getEntries() {
        return this.targetHistory.size();
    }

    public RobotInfo getTargetInfo(int turnsBack) {
        if (this.targetHistory.isEmpty() || turnsBack > this.getEntries() - 1) {
            return null;
        }
        turnsBack = (int)RoboUtils.limit(0.0, turnsBack, this.getEntries() - 1);
        return this.targetHistory.get(this.getEntries() - 1 - turnsBack);
    }

    public RobotInfo getMyInfo(int turnsBack) {
        if (this.myHistory.isEmpty() || turnsBack > this.getEntries() - 1) {
            return null;
        }
        turnsBack = (int)RoboUtils.limit(0.0, turnsBack, this.getEntries() - 1);
        return this.myHistory.get(this.getEntries() - 1 - turnsBack);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        RobotInfo me = new RobotInfo(this.getRobot());
        RobotInfo target = new RobotInfo(event, this.getRobot());
        this.addHistoryEntry(me, target);
    }

    protected void addHistoryEntry(RobotInfo me, RobotInfo target) {
        this.myHistory.add(me);
        this.targetHistory.add(target);
        if (this.myHistory.size() > this.getMaxEntries()) {
            this.myHistory.remove(0);
            this.targetHistory.remove(0);
        }
    }
}

