/*
 * Decompiled with CFR 0.152.
 */
package nic;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import nic.BulletStatManager;
import nic.Nicator;
import nic.ShotInfo;
import nic.sBullet;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.RobocodeFileWriter;

public class FireControlManager {
    Hashtable bullets;
    Nicator rob;
    static Vector v;
    BulletStatManager bsm;
    Point2D.Double p;
    public double firePower;
    public int lastmovetype = 0;
    public boolean firednow = false;
    boolean onevonegame = false;
    String onlyenemy;

    public FireControlManager(Nicator pRob) {
        this.rob = pRob;
        this.bullets = new Hashtable();
        v = new Vector();
        v.add(new BulletStatManager(this.rob, 1));
        v.add(new BulletStatManager(this.rob, -1));
        this.selectBulletStat();
        if (this.rob.getRoundNum() == 0) {
            this.onevonegame = this.rob.getOthers() == 1;
        }
        this.onlyenemy = "";
    }

    public void init(Nicator pRob) {
        this.rob = pRob;
        int i = 0;
        while (i < v.size()) {
            ((BulletStatManager)v.elementAt(i)).init(this.rob);
            ++i;
        }
        this.bullets = new Hashtable();
        this.selectBulletStat();
    }

    public void saveBulletStats() {
        if (this.onevonegame && this.rob.getRoundNum() >= 9) {
            BulletStatManager bsm1 = (BulletStatManager)v.elementAt(0);
            ShotInfo si = (ShotInfo)BulletStatManager.enemies.get(this.onlyenemy);
            try {
                BufferedWriter b = new BufferedWriter((Writer)new RobocodeFileWriter(this.rob.getDataFile(this.onlyenemy)));
                b.write(Double.toString(ShotInfo.circularhits));
                b.newLine();
                b.write(Double.toString(ShotInfo.circularshots));
                b.newLine();
                b.write(Double.toString(ShotInfo.directhits));
                b.newLine();
                b.write(Double.toString(ShotInfo.directshots));
                b.newLine();
                b.write(Double.toString(ShotInfo.patternhits));
                b.newLine();
                b.write(Double.toString(ShotInfo.circularshots));
                b.newLine();
                b.flush();
                b.close();
                System.out.println("Saved");
            }
            catch (IOException e) {
                System.out.println("Error saving stats");
            }
        }
    }

    public void loadBulletStats() {
        if (this.onevonegame) {
            String s;
            BufferedReader br;
            BulletStatManager bsm1 = (BulletStatManager)v.elementAt(0);
            ShotInfo si = (ShotInfo)BulletStatManager.enemies.get(this.onlyenemy);
            try {
                br = new BufferedReader(new FileReader(this.rob.getDataFile(this.onlyenemy)));
                s = br.readLine();
            }
            catch (Exception e) {
                System.out.println("Error loading stats");
                return;
            }
            if (s != null && s != "") {
                try {
                    ShotInfo.circularhits = Double.valueOf(s);
                    ShotInfo.circularshots = Double.valueOf(br.readLine());
                    ShotInfo.directhits = Double.valueOf(br.readLine());
                    ShotInfo.directshots = Double.valueOf(br.readLine());
                    ShotInfo.patternhits = Double.valueOf(br.readLine());
                    ShotInfo.patternshots = Double.valueOf(br.readLine());
                }
                catch (Exception e) {
                    System.out.println("Error loading stats");
                }
            }
            System.out.println("Loaded");
        }
    }

    public void add(Bullet b, String targ) {
        if (b != null) {
            ShotInfo si = (ShotInfo)BulletStatManager.enemies.get(targ);
            int i = Nicator.fm.lastmovetype;
            if (i == 0) {
                ShotInfo.circularshots += 1.0;
            }
            if (i == 1) {
                ShotInfo.directshots += 1.0;
            }
            if (i == 2) {
                ShotInfo.patternshots += 1.0;
            }
            this.bullets.put(b, new sBullet(targ, this.bsm, i));
        }
    }

    public void remove(Bullet b) {
        this.bullets.remove(b);
    }

    public void bullethit(BulletHitEvent e) {
        sBullet b = (sBullet)Nicator.fm.bullets.get(e.getBullet());
        ShotInfo si = (ShotInfo)BulletStatManager.enemies.get(e.getName());
        if (b.target == e.getName()) {
            if (b.targettype == 0) {
                ShotInfo.circularhits += 1.0;
            }
            if (b.targettype == 1) {
                ShotInfo.directhits += 1.0;
            }
            if (b.targettype == 2) {
                ShotInfo.patternhits += 1.0;
            }
        } else {
            if (b.targettype == 0) {
                ShotInfo.circularshots -= 1.0;
            }
            if (b.targettype == 1) {
                ShotInfo.directshots -= 1.0;
            }
            if (b.targettype == 2) {
                ShotInfo.patternshots -= 1.0;
            }
        }
    }

    public String get(Bullet b) {
        sBullet sb = (sBullet)this.bullets.get(b);
        if (sb == null) {
            return "";
        }
        return sb.target;
    }

    public void setEnemies(String enemy) {
        int i = 0;
        while (i < v.size()) {
            BulletStatManager cfr_ignored_0 = (BulletStatManager)v.elementAt(i);
            BulletStatManager.enemies.get(enemy);
            BulletStatManager cfr_ignored_1 = (BulletStatManager)v.elementAt(i);
            BulletStatManager.enemies.put(enemy, new ShotInfo());
            ++i;
        }
    }

    public void selectBulletStat() {
        BulletStatManager bs = (BulletStatManager)v.elementAt(0);
        int beststrategy = 0;
        double beststrategygoodness = bs.goodness();
        int i = 1;
        while (i < v.size()) {
            bs = (BulletStatManager)v.elementAt(i);
            double currentgoodness = bs.goodness();
            if (currentgoodness > beststrategygoodness) {
                beststrategygoodness = currentgoodness;
                beststrategy = i;
            }
            ++i;
        }
        this.bsm = (BulletStatManager)v.elementAt(beststrategy);
    }

    void selectFirePower() {
        this.firePower = 500.0 / this.rob.target.distance;
        if ((Nicator.br.bulletDodging() || this.rob.getOthers() > 3) && this.rob.target.speed == 0.0) {
            this.firePower = 3.0;
        }
        if (this.firePower > 3.0) {
            this.firePower = 3.0;
        }
        if (this.firePower < 1.0 && this.rob.getOthers() > 3) {
            this.firePower = 1.0;
        }
        if (this.firePower > this.rob.getEnergy()) {
            this.firePower = this.rob.getEnergy() - 0.1;
        }
        if (this.firePower == 0.0) {
            this.firePower = -1.0;
        }
        if (this.rob.target.energy == 0.0) {
            this.firePower = 0.1;
        }
    }

    public void moveGun() {
        this.selectFirePower();
        this.selectBulletStat();
        this.p = new Point2D.Double(this.rob.target.x, this.rob.target.y);
        long nextTime = (int)Math.round(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.p.x, this.p.y) / (20.0 - 3.0 * this.firePower));
        long time = this.rob.getTime() + nextTime;
        this.p = this.rob.target.guessPosition(time);
        double gunOffset = this.rob.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(this.p.y - this.rob.getY(), this.p.x - this.rob.getX()));
        this.rob.setTurnGunLeftRadians(this.rob.hf.normaliseBearing(gunOffset));
    }

    public void fire() {
        boolean firenow = true;
        if (this.rob.getGunHeat() > 0.0) {
            firenow = false;
        }
        if (!this.rob.target.live) {
            firenow = false;
        }
        if (this.p.x < 0.0 || this.p.x > this.rob.getBattleFieldWidth()) {
            firenow = false;
        }
        if (this.p.y < 0.0 || this.p.y > this.rob.getBattleFieldHeight()) {
            firenow = false;
        }
        if (this.rob.target.name == "") {
            firenow = false;
        }
        if (this.firePower < 0.0) {
            firenow = false;
        }
        this.firednow = firenow;
        if (firenow) {
            if (this.rob.getOthers() == 1) {
                Nicator.br.fire();
            }
            this.add(this.rob.fireBullet(this.firePower), this.rob.target.name);
        }
    }
}

