/*
 * Decompiled with CFR 0.152.
 */
package throxbot;

import java.awt.Color;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class ThroxBot
extends AdvancedRobot {
    final double CIRCLE_RADIUS = 200.0;
    final double FIRE_POWER_MIN = 1.0;
    final double FIRE_POWER_MAX = 3.0;
    public Map<String, Enemy> m_enemies;
    public Set<EnemyBullet> m_bullets;
    public Set<MyBullet> m_mybullets;
    public Stat m_xdiff;
    public Stat m_ydiff;
    public double m_power;
    static int s_id = 0;
    List<Event> m_eventbuffer;
    boolean m_needfullscan;
    Enemy m_target;
    boolean m_targetshotatus;
    double m_destx;
    double m_desty;
    double m_sizex;
    double m_sizey;
    Random m_rand;

    public static int GetNewId() {
        return ++s_id;
    }

    public void Init() {
        this.m_rand = new Random();
        this.setMaxVelocity(8.0);
        this.m_enemies = new HashMap<String, Enemy>();
        this.m_eventbuffer = new LinkedList<Event>();
        this.m_bullets = new HashSet<EnemyBullet>();
        this.m_needfullscan = true;
        this.m_mybullets = new HashSet<MyBullet>();
        this.m_xdiff = new Stat();
        this.m_ydiff = new Stat();
        this.m_target = null;
        this.m_targetshotatus = false;
        this.m_power = this.GetPower();
        this.m_destx = this.getX();
        this.m_desty = this.getY();
        this.m_sizex = this.getBattleFieldWidth();
        this.m_sizey = this.getBattleFieldHeight();
    }

    public void run() {
        this.setColors(Color.green, Color.red, Color.orange);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.Init();
        while (true) {
            try {
                this.HandleEvents();
                this.DoScan();
                this.UpdateBullets();
                this.DoMovement();
                this.DoFireControl();
            }
            catch (Throwable t) {
                this.out.println("Something went wrong!");
                this.Init();
            }
            this.execute();
        }
    }

    void DoScan() {
        if (this.getRadarTurnRemaining() == 0.0) {
            if (this.m_enemies.size() != 1) {
                this.setTurnRadarRight(360.0);
            } else {
                Enemy e = this.m_enemies.values().iterator().next();
                if (e.get_LastScan() - (double)this.getTime() > 5.0) {
                    this.setTurnRadarRight(360.0);
                    return;
                }
                double scandiff = this.normalizeBearing(e.get_Bearing() - this.getRadarHeadingRadians());
                if (scandiff > 0.0) {
                    this.setTurnRadarRightRadians(scandiff + 0.3141592653589793);
                } else {
                    this.setTurnRadarLeftRadians(0.3141592653589793 - scandiff);
                }
            }
        }
    }

    void UpdateBullets() {
        HashSet<EnemyBullet> dellist = new HashSet<EnemyBullet>();
        for (EnemyBullet b : this.m_bullets) {
            if (!b.CheckExpired()) continue;
            dellist.add(b);
        }
        for (EnemyBullet b : dellist) {
            this.m_bullets.remove(b);
        }
    }

    double GetThreatLevel(double x, double y) {
        double d;
        if (x < 50.0 || x > this.m_sizex - 50.0 || y < 50.0 || y > this.m_sizey - 50.0) {
            return 1000000.0;
        }
        double threat = 0.0;
        for (EnemyBullet b : this.m_bullets) {
            d = b.DistanceFrom(x, y);
            if (!(d < 40.0)) continue;
            threat += 100.0;
        }
        for (Enemy e : this.m_enemies.values()) {
            d = e.DistanceFrom(x, y);
            if (!(d < 200.0)) continue;
            threat += 50.0 - d / 4.0;
        }
        return threat;
    }

    void ComputeDestination() {
        double x0 = this.getX();
        double y0 = this.getY();
        double bestx = this.m_destx;
        double besty = this.m_desty;
        double leastthreat = this.GetThreatLevel(this.m_destx, this.m_desty);
        if (leastthreat > 0.0) {
            double startangle = this.m_rand.nextDouble() * Math.PI * 2.0;
            double increment = 0.09817477042468103;
            double finishangle = startangle + Math.PI * 2;
            if (this.m_rand.nextDouble() > 0.5) {
                increment = -0.09817477042468103;
                finishangle = startangle - Math.PI * 2;
            }
            double angle = startangle;
            while (angle < finishangle) {
                double y;
                double x = x0 + 50.0 * Math.sin(angle);
                double threat = this.GetThreatLevel(x, y = y0 + 50.0 * Math.cos(angle));
                if (leastthreat > threat) {
                    leastthreat = threat;
                    bestx = x;
                    besty = y;
                }
                angle += increment;
            }
            this.m_destx = bestx;
            this.m_desty = besty;
        }
    }

    void DoMovement() {
        double x0 = this.getX();
        double y0 = this.getY();
        this.ComputeDestination();
        double currheading = this.getHeadingRadians();
        double newheading = this.arctan(this.m_destx - x0, this.m_desty - y0);
        double newbearing = this.normalizeBearing(newheading - currheading);
        double d = Math.sqrt(Math.pow(this.m_destx - x0, 2.0) + Math.pow(this.m_desty - y0, 2.0));
        double cos = Math.cos(newbearing);
        if (cos < 0.0) {
            newbearing = this.normalizeBearing(newbearing + Math.PI);
            this.setBack(d);
        } else {
            this.setAhead(d);
        }
        this.setTurnRightRadians(newbearing);
    }

    void UpdateMyBullets() {
        Iterator<MyBullet> i = this.m_mybullets.iterator();
        while (i.hasNext()) {
            MyBullet b = i.next();
            if (b.CheckActive()) continue;
            i.remove();
        }
    }

    void DoFireControl() {
        this.UpdateMyBullets();
        if (this.m_target == null) {
            this.ChooseTarget();
        }
        if (this.m_target != null) {
            double d = this.m_target.get_Distance();
            double t = d / (20.0 - 3.0 * this.m_power);
            double x = this.m_target.m_x;
            double y = this.m_target.m_y;
            double dx = this.m_xdiff.MovingAverage() * t;
            double dy = this.m_ydiff.MovingAverage() * t;
            double angle = this.m_target.get_Bearing();
            double dx0 = Math.cos(angle) * dx + Math.sin(angle) * dy;
            double dy0 = Math.cos(angle) * dy - Math.sin(angle) * dx;
            x += dx0;
            y += dy0;
            double fireheading = this.arctan(x - this.getX(), y - this.getY());
            double firediff = this.normalizeBearing(fireheading - this.getGunHeadingRadians());
            if (firediff > 0.0) {
                this.setTurnGunRightRadians(firediff);
            } else {
                this.setTurnGunLeftRadians(-firediff);
            }
            if (this.getGunHeat() == 0.0 && firediff < 0.7853981633974483 && Math.tan(firediff) * d < 18.0) {
                Bullet b = this.fireBullet(this.m_power);
                new MyBullet(b, this.m_target);
                this.m_power = this.GetPower();
            }
        }
    }

    double GetPower() {
        return this.m_rand.nextDouble() * 2.0 + 1.0;
    }

    void ChooseTarget() {
        if (this.m_target != null) {
            return;
        }
        if (this.m_enemies.size() == 0) {
            return;
        }
        this.m_targetshotatus = false;
        if (this.m_enemies.size() == 1) {
            this.m_target = this.m_enemies.values().iterator().next();
            return;
        }
        double closest = 100000.0;
        for (Enemy e : this.m_enemies.values()) {
            double d = e.get_Distance();
            if (!(d < closest)) continue;
            closest = d;
            this.m_target = e;
        }
    }

    void HandleEvents() {
        try {
            ListIterator<Event> iterator = this.m_eventbuffer.listIterator();
            while (iterator.hasNext()) {
                Event event = iterator.next();
                if (event instanceof SkippedTurnEvent) {
                    this.handleSkippedTurnEvent((SkippedTurnEvent)event);
                } else if (event instanceof ScannedRobotEvent) {
                    this.handleScannedRobotEvent((ScannedRobotEvent)event);
                } else if (event instanceof BulletHitEvent) {
                    this.handleBulletHitEvent((BulletHitEvent)event);
                } else if (event instanceof BulletMissedEvent) {
                    this.handleBulletMissedEvent((BulletMissedEvent)event);
                } else if (event instanceof HitRobotEvent) {
                    this.handleHitRobotEvent((HitRobotEvent)event);
                } else if (event instanceof HitWallEvent) {
                    this.handleHitWallEvent((HitWallEvent)event);
                } else if (event instanceof HitByBulletEvent) {
                    this.handleHitByBulletEvent((HitByBulletEvent)event);
                } else if (event instanceof RobotDeathEvent) {
                    this.handleRobotDeathEvent((RobotDeathEvent)event);
                } else if (event instanceof DeathEvent) {
                    this.handleDeathEvent((DeathEvent)event);
                } else if (event instanceof WinEvent) {
                    this.handleWinEvent((WinEvent)event);
                }
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            this.out.println("caught a concurrent modification of the eventsbuffer...");
        }
    }

    void handleBulletHitEvent(BulletHitEvent event) {
    }

    void handleBulletMissedEvent(BulletMissedEvent event) {
    }

    void handleHitByBulletEvent(HitByBulletEvent event) {
        if (this.m_targetshotatus) {
            return;
        }
        this.m_targetshotatus = true;
        Enemy e = this.m_enemies.get(event.getName());
        if (e != null) {
            this.m_target = e;
        }
    }

    void handleDeathEvent(DeathEvent event) {
    }

    void handleHitRobotEvent(HitRobotEvent event) {
    }

    void handleHitWallEvent(HitWallEvent event) {
    }

    void handleRobotDeathEvent(RobotDeathEvent event) {
        this.out.println(String.format("Robot %s died", event.getName()));
        Enemy e = this.m_enemies.get(event.getName());
        if (e != null) {
            this.m_enemies.remove(e.m_name);
            if (e == this.m_target) {
                this.m_target = null;
            }
        }
    }

    void handleScannedRobotEvent(ScannedRobotEvent event) {
        String name = event.getName();
        Enemy e = this.m_enemies.get(name);
        if (e != null) {
            e.Update(event);
        } else {
            e = new Enemy(event);
        }
    }

    void handleSkippedTurnEvent(SkippedTurnEvent event) {
    }

    void handleWinEvent(WinEvent event) {
    }

    void bufferEvents(Event event) {
        this.m_eventbuffer.add(event);
        Vector v = this.getAllEvents();
        int i = 0;
        while (i < v.size()) {
            event = (Event)v.elementAt(i);
            this.m_eventbuffer.add(event);
            ++i;
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onDeath(DeathEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onHitWall(HitWallEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onWin(WinEvent event) {
        this.bufferEvents((Event)event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.bufferEvents((Event)event);
        this.out.println("robot died");
    }

    public double arctan(double dy, double dx) {
        if (dx == 0.0) {
            if (dy > 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        if (dx > 0.0 && dy > 0.0) {
            return this.normalizeHeading(Math.atan(dy / dx));
        }
        if (dx < 0.0 && dy > 0.0) {
            return this.normalizeHeading(Math.PI - Math.atan(dy / Math.abs(dx)));
        }
        if (dx < 0.0 && dy < 0.0) {
            return this.normalizeHeading(Math.PI + Math.atan(dy / dx));
        }
        return this.normalizeHeading(Math.PI * 2 - Math.atan(Math.abs(dy) / dx));
    }

    private double normalizeBearing(double r) {
        while (r > Math.PI) {
            r -= Math.PI * 2;
        }
        while (r < -Math.PI) {
            r += Math.PI * 2;
        }
        return r;
    }

    private double normalizeHeading(double r) {
        while (r > Math.PI * 2) {
            r -= Math.PI * 2;
        }
        while (r < 0.0) {
            r += Math.PI * 2;
        }
        return r;
    }

    class Enemy {
        double m_x;
        double m_y;
        String m_name;
        double m_energy;
        double m_bearing;
        double m_distance;
        double m_dx;
        double m_dy;
        double m_lastscan;

        public double get_Bearing() {
            return this.m_bearing;
        }

        public double get_Distance() {
            return this.m_distance;
        }

        public double get_LastScan() {
            return this.m_lastscan;
        }

        public Enemy(ScannedRobotEvent event) {
            this.m_name = event.getName();
            this.m_bearing = event.getBearingRadians() + ThroxBot.this.getHeadingRadians();
            this.m_distance = event.getDistance();
            this.m_x = ThroxBot.this.getX() + Math.sin(this.m_bearing) * this.m_distance;
            this.m_y = ThroxBot.this.getY() + Math.cos(this.m_bearing) * this.m_distance;
            ThroxBot.this.m_enemies.put(this.m_name, this);
            this.m_energy = event.getEnergy();
            double enemyheading = event.getHeadingRadians();
            double enemyvel = event.getVelocity();
            this.m_dx = Math.sin(enemyheading) * enemyvel;
            this.m_dy = Math.cos(enemyheading) * enemyvel;
            this.m_lastscan = ThroxBot.this.getTime();
            ThroxBot.this.out.println(String.format("New Robot [%s] found at (%f, %f)", this.m_name, this.m_x, this.m_y));
        }

        public void Update(ScannedRobotEvent event) {
            this.m_bearing = event.getBearingRadians() + ThroxBot.this.getHeadingRadians();
            this.m_distance = event.getDistance();
            double botx = ThroxBot.this.getX();
            double boty = ThroxBot.this.getY();
            this.m_x = botx + Math.sin(this.m_bearing) * this.m_distance;
            this.m_y = boty + Math.cos(this.m_bearing) * this.m_distance;
            double enemyheading = event.getHeadingRadians();
            double enemyvel = event.getVelocity();
            this.m_dx = Math.sin(enemyheading) * enemyvel;
            this.m_dy = Math.cos(enemyheading) * enemyvel;
            this.m_lastscan = ThroxBot.this.getTime();
            double newenergy = event.getEnergy();
            double energydiff = newenergy - this.m_energy;
            this.m_energy = newenergy;
            if (energydiff <= -0.1 && energydiff >= -3.0) {
                double now = ThroxBot.this.getTime();
                double bv = 20.0 + 3.0 * energydiff;
                new EnemyBullet(this.m_x, this.m_y, botx, boty, now, bv);
                double bot_moves = ThroxBot.this.getVelocity() * this.m_distance / bv;
                double bot_heading = ThroxBot.this.getHeadingRadians();
                double px = botx + bot_moves * Math.sin(bot_heading);
                double py = boty + bot_moves * Math.cos(bot_heading);
                new EnemyBullet(this.m_x, this.m_y, px, py, now, bv);
            }
        }

        public double DistanceFrom(double x, double y) {
            return Math.sqrt(Math.pow(x - this.m_x, 2.0) + Math.pow(y - this.m_y, 2.0));
        }

        public double BearingFrom(double x, double y) {
            return ThroxBot.this.arctan(this.m_x - x, this.m_y - y);
        }

        public double DistancePredict(double span) {
            return this.DistanceFromPredict(ThroxBot.this.getX(), ThroxBot.this.getY(), span);
        }

        public double DistanceFromPredict(double x, double y, double span) {
            double px = this.m_x + this.m_dx * span;
            double py = this.m_y + this.m_dy * span;
            return Math.sqrt(Math.pow(x - px, 2.0) + Math.pow(y - py, 2.0));
        }

        public double BearingPredict(double span) {
            return this.BearingFromPredict(ThroxBot.this.getX(), ThroxBot.this.getY(), span);
        }

        public double BearingFromPredict(double x, double y, double span) {
            double px = this.m_x + this.m_dx * span;
            double py = this.m_y + this.m_dy * span;
            return ThroxBot.this.arctan(px - x, py - y);
        }
    }

    class EnemyBullet {
        private double m_x0;
        private double m_y0;
        private double m_x1;
        private double m_y1;
        private double m_slope1;
        private double m_slope2;
        private double m_whenfired;
        private double m_v;
        private String m_name;
        private double m_dx;
        private double m_dy;

        public EnemyBullet(double x0, double y0, double x1, double y1, double whenfired, double v) {
            this.m_x0 = x0;
            this.m_y0 = y0;
            this.m_x1 = x1;
            this.m_y1 = y1;
            this.m_whenfired = whenfired;
            this.m_v = v;
            this.m_name = String.format(" Bullet %d", ThroxBot.GetNewId());
            if (this.m_x0 != this.m_x1 && this.m_y0 != this.m_y1) {
                this.m_slope1 = (this.m_y0 - this.m_y1) / (this.m_x0 - this.m_x1);
                this.m_slope2 = -1.0 / this.m_slope1;
            }
            double angle = ThroxBot.this.arctan(x1 - x0, y1 - y0);
            this.m_dx = Math.sin(angle) * this.m_v;
            this.m_dy = Math.cos(angle) * this.m_v;
            ThroxBot.this.m_bullets.add(this);
        }

        public boolean CheckExpired() {
            double t = (double)ThroxBot.this.getTime() - this.m_whenfired;
            double x = this.m_x0 + this.m_dx * t;
            double y = this.m_y0 + this.m_dy * t;
            return x < 0.0 || x > ThroxBot.this.m_sizex || y < 0.0 || y > ThroxBot.this.m_sizey;
        }

        public double DistanceFrom(double x, double y) {
            double yi;
            double xi;
            if (this.m_x0 == this.m_x1) {
                xi = this.m_x0;
                yi = y;
            } else if (this.m_y0 == this.m_y1) {
                xi = x;
                yi = this.m_y0;
            } else {
                xi = (-1.0 * this.m_slope2 * x + y - this.m_y0 + this.m_slope1 * this.m_x0) / (this.m_slope1 - this.m_slope2);
                yi = this.m_slope1 * (xi - this.m_x0) + this.m_y0;
            }
            return Math.sqrt(Math.pow(x - xi, 2.0) + Math.pow(y - yi, 2.0));
        }
    }

    class MyBullet {
        Bullet m_bullet;
        double m_x0;
        double m_y0;
        double m_targetx;
        double m_targety;
        double m_targetheading;
        Enemy m_victim;
        double m_distance;

        MyBullet(Bullet b, Enemy e) {
            this.m_bullet = b;
            this.m_x0 = ThroxBot.this.getX();
            this.m_y0 = ThroxBot.this.getY();
            this.m_targetx = e.m_x;
            this.m_targety = e.m_y;
            this.m_targetheading = e.get_Bearing();
            this.m_victim = e;
            this.m_distance = Math.sqrt(Math.pow(this.m_x0 - this.m_targetx, 2.0) + Math.pow(this.m_y0 - this.m_targety, 2.0));
            ThroxBot.this.m_mybullets.add(this);
        }

        public boolean CheckActive() {
            double x = this.m_bullet.getX();
            double y = this.m_bullet.getY();
            double d = Math.sqrt(Math.pow(this.m_x0 - x, 2.0) + Math.pow(this.m_y0 - y, 2.0));
            if (d > this.m_distance || this.m_bullet.getVictim() != null) {
                double dx = this.m_victim.m_x - this.m_targetx;
                double dy = this.m_victim.m_y - this.m_targety;
                double angle = -this.m_bullet.getHeadingRadians();
                double dx0 = Math.cos(angle) * dx + Math.sin(angle) * dy;
                double dy0 = Math.cos(angle) * dy - Math.sin(angle) * dx;
                double t = d / this.m_bullet.getVelocity();
                ThroxBot.this.m_xdiff.Add(dx0 /= t);
                ThroxBot.this.m_ydiff.Add(dy0 /= t);
                return false;
            }
            return this.m_bullet.isActive();
        }
    }

    class Stat {
        double m_sum = 0.0;
        int m_count = 0;
        Queue<Double> m_history = new LinkedList<Double>();
        double m_historysum = 0.0;

        Stat() {
        }

        void Add(double var) {
            this.m_sum += var;
            ++this.m_count;
            this.m_history.add(var);
            this.m_historysum += var;
            if (this.m_history.size() > 10) {
                this.m_historysum -= this.m_history.remove().doubleValue();
            }
        }

        double Average() {
            if (this.m_count == 0) {
                return 0.0;
            }
            return this.m_sum / (double)this.m_count;
        }

        double MovingAverage() {
            if (this.m_history.size() == 0) {
                return 0.0;
            }
            return this.m_historysum / (double)this.m_history.size();
        }
    }
}

