/*
 * Decompiled with CFR 0.152.
 */
package dittman;

import dittman.ScanData;
import java.util.LinkedList;

class Enemy {
    private final int MAX_HISTORY = 3;
    private String name;
    private int missCount;
    private boolean missedLast;
    private LinkedList history = new LinkedList();
    private boolean needTarget = true;

    Enemy() {
    }

    public ScanData getOldestScan() {
        if (this.history.size() > 0) {
            return (ScanData)this.history.getLast();
        }
        return null;
    }

    public ScanData getCurrentScan() {
        if (this.history.size() != 0) {
            return (ScanData)this.history.getFirst();
        }
        return null;
    }

    public ScanData getScan(int index) {
        if (this.history.size() >= index + 1) {
            return (ScanData)this.history.get(index);
        }
        return null;
    }

    public void addScan(ScanData sd) {
        this.history.addFirst(sd);
        if (this.history.size() > 3) {
            this.history.remove(3);
        }
    }

    public boolean getNeedTarget() {
        return this.needTarget;
    }

    public int getScanCount() {
        return this.history.size();
    }

    public double getBearing() {
        return this.getBearing(0);
    }

    public double getBearing(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.bearing;
        }
        return 0.0;
    }

    public void clear() {
        this.history.clear();
        this.initMissCount();
    }

    public double getX() {
        return this.getX(0);
    }

    public double getX(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.x;
        }
        return 0.0;
    }

    public double getY() {
        return this.getY(0);
    }

    public double getY(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.y;
        }
        return 0.0;
    }

    public long getTime() {
        return this.getTime(0);
    }

    public long getTime(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.time;
        }
        return 0L;
    }

    public double getHeading() {
        return this.getHeading(0);
    }

    public double getHeading(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.head;
        }
        return 0.0;
    }

    public String getName() {
        return this.name;
    }

    public double getSpeed() {
        return this.getSpeed(0);
    }

    public double getSpeed(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.speed;
        }
        return 0.0;
    }

    public double getDistance() {
        return this.getDistance(0);
    }

    public double getDistance(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.distance;
        }
        return 0.0;
    }

    public double getEnergy() {
        return this.getEnergy(0);
    }

    public double getEnergy(int index) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            return sd.energy;
        }
        return 0.0;
    }

    public int getMissCount() {
        return this.missCount;
    }

    public boolean getMissedLast() {
        return this.missedLast;
    }

    public double guessX(long when) {
        long diff = when - this.getTime();
        return this.getX() + Math.sin(this.getHeading()) * this.getSpeed() * (double)diff;
    }

    public double guessY(long when) {
        long diff = when - this.getTime();
        return this.getY() + Math.cos(this.getHeading()) * this.getSpeed() * (double)diff;
    }

    public void setBearing(double bearing) {
        this.setDistance(0, bearing);
    }

    public void setBearing(int index, double bearing) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            sd.bearing = bearing;
        }
    }

    public void setDistance(double distance) {
        this.setDistance(0, distance);
    }

    public void setDistance(int index, double distance) {
        ScanData sd = this.getScan(index);
        if (sd != null) {
            sd.distance = distance;
        }
    }

    public void setNeedTarget(boolean needTarget) {
        this.needTarget = needTarget;
    }

    public void incrementMissCount() {
        ++this.missCount;
        this.missedLast = true;
    }

    public void initMissCount() {
        this.missCount = 0;
        this.missedLast = false;
    }

    public void setName(String name) {
        this.name = name;
    }
}

