/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns.Guns.DC;

import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.KDTree.KDTree;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Utils.MathUtils;
import rdt.VirtualGuns.Guns.DC.DCHit;
import rdt.VirtualGuns.Guns.DC.KernelDensityBase;
import rdt.VirtualGuns.Guns.DC.KernelDensityUniformOptimal;
import rdt.VirtualGuns.Guns.DC.Segmentation;
import rdt.VirtualGuns.VirtualGun;
import rdt.VirtualGuns.VirtualGunFiringData;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;

public class VirtualGunDC
extends VirtualGun {
    private int _kNeighbours;
    private KDTree<DCHit> _tree = null;
    private double _virtualWeight = 0.0;
    private double _actualWeight = 0.0;
    private Segmentation _segmentation;
    private ArrayList<KDTree.SearchResult<DCHit>> _latestNearestNeighbours = null;
    private VirtualGunsFiringData _latestFiringData = null;
    private int _hitsLogged = 0;
    private KernelDensityBase _kernelDensity;
    private boolean _recordOnWaveReachedTarget;
    private boolean _recordOnHitOnTarget;

    public VirtualGunDC(int kNeighbours, ArrayList<Segmentation.eSegmentation> segmentationList, double actualWeight, double virtualWeight, boolean recordOnWaveReachedTarget, boolean recordOnHitOnTarget) {
        this._kNeighbours = kNeighbours;
        this._kernelDensity = new KernelDensityUniformOptimal();
        this._tree = new KDTree.Manhattan<DCHit>(segmentationList.size());
        this._virtualWeight = virtualWeight;
        this._actualWeight = actualWeight;
        this._segmentation = new Segmentation(segmentationList);
        this._recordOnWaveReachedTarget = recordOnWaveReachedTarget;
        this._recordOnHitOnTarget = recordOnHitOnTarget;
    }

    @Override
    public String GetName() {
        return "DC";
    }

    @Override
    public void Update() {
    }

    @Override
    public VirtualGunFiringData GetFiringData(VirtualGunsFiringData overallFiringData) {
        VirtualGunFiringData data = new VirtualGunFiringData();
        RobotData target = this._dataInterface.GetTargetData();
        RobotDataSnapshot latestTarget = target.Snapshots.get(this._dataInterface.GetTargetDataAge());
        double headOnAngle = MathUtils.GetAngle(overallFiringData.FiringLocationX, overallFiringData.FiringLocationY, latestTarget.LocationX, latestTarget.LocationY);
        if (this._hitsLogged == 0) {
            data.AddFiringAngle(headOnAngle);
            return data;
        }
        int nearestNeighbours = Math.min(this._hitsLogged, this._kNeighbours);
        this._latestNearestNeighbours = this._tree.nearestNeighbours(this._segmentation.GetData(overallFiringData.TargetSnapshotAtFireTime, WaveData.eWaveType.Real), nearestNeighbours);
        double guessFactorChosen = this._kernelDensity.GetBestGuessFactor(this._latestNearestNeighbours, overallFiringData.TargetSnapshotAtFireTime.DistanceToTarget, overallFiringData.MEA);
        double firingAngle = overallFiringData.MEA.GetAbsAngleFromGuessFactor(guessFactorChosen);
        data.AddFiringAngle(firingAngle);
        this._latestFiringData = overallFiringData;
        return data;
    }

    @Override
    public void OnWaveReachedTarget(WaveData wave) {
        if (!this._recordOnWaveReachedTarget) {
            return;
        }
        RobotData target = this._dataInterface.GetTargetData();
        RobotDataSnapshot latestTarget = target.Snapshots.get(0);
        double sourceX = wave.VirtualGunData.FiringLocationX;
        double sourceY = wave.VirtualGunData.FiringLocationY;
        double targetX = latestTarget.LocationX;
        double targetY = latestTarget.LocationY;
        double actualAngleToTarget = MathUtils.GetAngle(sourceX, sourceY, targetX, targetY);
        this.LogHit(actualAngleToTarget, wave.VirtualGunData, wave.WaveType);
    }

    @Override
    public void OnActualHitOnTarget(WaveData wave, double hitX, double hitY) {
        if (!this._recordOnHitOnTarget) {
            return;
        }
        double sourceX = wave.VirtualGunData.FiringLocationX;
        double sourceY = wave.VirtualGunData.FiringLocationY;
        double actualAngleToTarget = MathUtils.GetAngle(sourceX, sourceY, hitX, hitY);
        this.LogHit(actualAngleToTarget, wave.VirtualGunData, wave.WaveType);
    }

    private void LogHit(double actualAngleToTarget, VirtualGunsFiringData firingData, WaveData.eWaveType waveType) {
        DCHit dcHit = new DCHit();
        dcHit.GuessFactor = firingData.MEA.GetGuessFactorFromAbsoluteAngle(actualAngleToTarget, firingData.TargetSnapshotAtFireTime.RotationDirectionToTarget);
        dcHit.HitWeight = this._actualWeight;
        if (waveType == WaveData.eWaveType.Virtual) {
            dcHit.HitWeight = this._virtualWeight;
        }
        this._tree.addPoint(this._segmentation.GetData(firingData.TargetSnapshotAtFireTime, waveType), dcHit);
        ++this._hitsLogged;
    }

    @Override
    public void DebugDraw(Graphics2D gfx, double sourceX, double sourceY, RobotData targetData) {
        if (this._latestNearestNeighbours == null || this._latestNearestNeighbours.size() <= 0 || targetData.NumSnapshots <= 0) {
            return;
        }
    }
}

