/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.detection.strategies;

import ghent.common.Target;
import ghent.modules.detection.strategies.IMeleeRadarStrategy;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class SpinningRadarStrategy
implements IMeleeRadarStrategy {
    private AdvancedRobot _robot;

    public SpinningRadarStrategy(AdvancedRobot _robot) {
        this._robot = _robot;
    }

    public void scan() {
        if (this._robot.getRadarTurnRemaining() == 0.0) {
            Point2D.Double rlocation = new Point2D.Double(this._robot.getX(), this._robot.getY());
            Target center = new Target();
            center.setLocation(this._robot.getBattleFieldWidth() / 2.0, this._robot.getBattleFieldHeight() / 2.0);
            double radarTurn = Utils.normalRelativeAngleDegrees((double)(center.getBearing(rlocation) - this._robot.getRadarHeading()));
            if (radarTurn > 0.0) {
                this._robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
            } else {
                this._robot.setTurnRadarLeft(Double.POSITIVE_INFINITY);
            }
        }
    }
}

