/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.navigation.events;

import ghent.common.Direction;
import robocode.Condition;
import robocode.Robot;

public class NearWallCondition
extends Condition {
    private static final double LIMIT_DISTANCE_NEAR_WALL = 200.0;
    private Robot _robot;
    private Direction _direction;

    public NearWallCondition(Robot _robot) {
        super("Position");
        this._robot = _robot;
    }

    public NearWallCondition(Robot _robot, String name) {
        super(name);
        this._robot = _robot;
    }

    public NearWallCondition(Robot _robot, String name, int priority) {
        super(name, priority);
        this._robot = _robot;
    }

    public boolean test() {
        this._direction = null;
        if (this.nearNorth()) {
            this._direction = this.nearWest() ? Direction.NORTH_WEST : (this.nearEast() ? Direction.NORTH_EAST : Direction.NORTH);
        } else if (this.nearSouth()) {
            this._direction = this.nearWest() ? Direction.SOUTH_WEST : (this.nearEast() ? Direction.SOUTH_EAST : Direction.SOUTH);
        } else if (this.nearWest()) {
            this._direction = Direction.WEST;
        } else if (this.nearEast()) {
            this._direction = Direction.EAST;
        }
        return this._direction != null;
    }

    private boolean nearNorth() {
        return this._robot.getY() > this._robot.getBattleFieldHeight() - 200.0;
    }

    private boolean nearEast() {
        return this._robot.getX() > this._robot.getBattleFieldWidth() - 200.0;
    }

    private boolean nearSouth() {
        return this._robot.getY() < 200.0;
    }

    private boolean nearWest() {
        return this._robot.getX() < 200.0;
    }

    public Direction getDirection() {
        return this._direction;
    }
}

