/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import com.spp.robocode.Enemy;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class BattlefieldModel {
    private final Map<String, Enemy> enemies = new HashMap<String, Enemy>();
    private final AdvancedRobot robot;

    BattlefieldModel(AdvancedRobot r) {
        this.robot = r;
    }

    public Enemy getEnemy(String name, boolean create) {
        Enemy retVal = this.enemies.get(name);
        if (retVal == null && create) {
            retVal = new Enemy(this.robot, name);
            this.enemies.put(name, retVal);
        }
        return retVal;
    }

    Enemy getClosestEnemy() {
        if (this.enemies.isEmpty()) {
            return null;
        }
        return this.enemies.values().stream().min((e1, e2) -> e1.getDistance() - e2.getDistance()).get();
    }

    Enemy getWeakestEnemy() {
        if (this.enemies.isEmpty()) {
            return null;
        }
        return this.enemies.values().stream().min((e1, e2) -> (int)(e1.getEnergy() - e2.getEnergy())).get();
    }

    Enemy getStrongestEnemy() {
        if (this.enemies.isEmpty()) {
            return null;
        }
        return this.enemies.values().stream().min((e1, e2) -> (int)(e2.getEnergy() - e1.getEnergy())).get();
    }

    void onScannedRobot(ScannedRobotEvent event) {
        Enemy e = this.getEnemy(event.getName(), true);
        double angleToEnemy = event.getBearing();
        double angle = Math.toRadians(this.robot.getHeading() + angleToEnemy % 360.0);
        double enemyX = this.robot.getX() + Math.sin(angle) * (double)e.getDistance();
        double enemyY = this.robot.getY() + Math.cos(angle) * (double)e.getDistance();
        double eDiff = e.getEnergy() - event.getEnergy();
        e.SetLocation(event.getDistance(), event.getBearingRadians(), event.getHeadingRadians(), event.getVelocity(), event.getEnergy(), enemyX, enemyY, this.robot.getTime());
    }

    void onRobotDeath(String name) {
        if (this.enemies.containsKey(name)) {
            // empty if block
        }
        this.enemies.remove(name);
    }

    int numEnemies() {
        return this.enemies.size();
    }

    public Map<String, Enemy> getEnemies() {
        return this.enemies;
    }
}

