/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.util.Vector;
import shrub.Bearing;
import shrub.Box;
import shrub.GunPhysics;
import shrub.Heading;
import shrub.Location;
import shrub.MoveHistory;
import shrub.Movement;
import shrub.RadarModeAPI;
import shrub.Sighting;
import shrub.TrackerAPI;

public class MHTracker
implements TrackerAPI {
    private RadarModeAPI mRadarResyncRef = null;
    private Box mMovementArea = null;
    private Heading mGunHdng = Heading.ZERO;
    private Location mTrackerLocn = Location.ZERO_ZERO;
    private Vector mTargetList = new Vector();
    private int mCurrentTargetIndex = -1;
    private int mNumTargets = 0;
    private long mTimeNow = 0L;
    private long mNumTargetChanges = 0L;
    private int mMaxHistory = 100;
    private boolean mChangeTargetAllowed = true;
    private long mStalenessLimit = 20L;
    private double mEvalStaleCoeff = 5.0;
    private double mEvalSpeedCoeff = 5.0;
    private double mEvalAngleCoeff = 1.0;
    private double mEvalDistanceCoeff = 1.0;
    private double mEvalDisabledThreshold = 0.5;
    private double mEvalDisabledBonus = 100.0;
    private double mEvalLowEnergyThreshold = 5.0;
    private double mEvalLowEnergyBonus = 0.0;
    private int mExtrapolationInterval = 1;

    public void SetRadarResyncRef(RadarModeAPI radarResyncRef) {
        this.mRadarResyncRef = radarResyncRef;
    }

    public void SetMovementArea(Box movementArea) {
        this.mMovementArea = null;
        if (movementArea != null) {
            this.mMovementArea = movementArea;
        }
    }

    public void SetTrackerLocn(Location trackerLocn) {
        this.mTrackerLocn = trackerLocn;
    }

    public void SetGunHdng(Heading gunHdng) {
        this.mGunHdng = gunHdng;
    }

    public void SetStalenessLimit(long newValue) {
        this.mStalenessLimit = newValue;
    }

    public void SetEvalStaleCoeff(double newValue) {
        this.mEvalStaleCoeff = newValue;
    }

    public void SetEvalAngleCoeff(double newValue) {
        this.mEvalAngleCoeff = newValue;
    }

    public void SetEvalSpeedCoeff(double newValue) {
        this.mEvalSpeedCoeff = newValue;
    }

    public void SetEvalDistanceCoeff(double newValue) {
        this.mEvalDistanceCoeff = newValue;
    }

    public void SetEvalDisabledThreshold(double newValue) {
        this.mEvalDisabledThreshold = newValue;
    }

    public void SetEvalDisabledBonus(double newValue) {
        this.mEvalDisabledBonus = newValue;
    }

    public void SetEvalLowEnergyThreshold(double newValue) {
        this.mEvalLowEnergyThreshold = newValue;
    }

    public void SetEvalLowEnergyBonus(double newValue) {
        this.mEvalLowEnergyBonus = newValue;
    }

    public void SetMaxHistory(int newValue) {
        this.mMaxHistory = newValue;
    }

    public void SetExtrapolationInterval(int newValue) {
        this.mExtrapolationInterval = newValue;
    }

    public int GetCurrentTargetIndex() {
        return this.mCurrentTargetIndex;
    }

    public long GetNumTargetChanges() {
        return this.mNumTargetChanges;
    }

    public final boolean ExtrapolateCurrentTarget(long toTime) {
        boolean extrapolated = false;
        extrapolated = this.ExtrapolateTarget(this.mCurrentTargetIndex, toTime);
        return extrapolated;
    }

    public final boolean ExtrapolateTarget(int index, long toTime) {
        boolean extrapolated = false;
        if (index >= 0 && index < this.mNumTargets) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(index);
            if (target != null) {
                extrapolated = target.Extrapolate(toTime);
            } else {
                System.out.println("ERROR! Tracker::ExtrapolateTarget, null pointer at " + index);
            }
        } else {
            System.out.println("ERROR! Tracker::ExtrapolateTarget, bad index " + index);
        }
        return extrapolated;
    }

    public final boolean ExtrapolateAll(long toTime) {
        boolean okSoFar = true;
        if (this.mExtrapolationInterval > 0) {
            for (int index = 0; index < this.mNumTargets; ++index) {
                if (this.mTimeNow % (long)this.mExtrapolationInterval != (long)(index % this.mExtrapolationInterval)) continue;
                okSoFar &= this.ExtrapolateTarget(index, toTime);
            }
        }
        return okSoFar;
    }

    public void ReportSighting(Sighting newSighting) {
        int posn = -1;
        String targetName = newSighting.GetName();
        posn = this.FindNamedTarget(targetName);
        if (posn >= 0 && posn < this.mNumTargets) {
            this.UpdateTargetAt(posn, newSighting);
        } else {
            this.AddNewTarget(newSighting);
        }
    }

    public final int FindNamedTarget(String searchName) {
        int answer = -1;
        boolean found = false;
        for (int index = 0; !found && index < this.mNumTargets; ++index) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(index);
            String targetName = target.GetName();
            if (!targetName.equals(searchName)) continue;
            found = true;
            answer = index;
        }
        return answer;
    }

    public final int GetOldestTargetIndex() {
        double oldestTimeSoFar = 999999.9;
        int oldestIndexSoFar = -1;
        for (int thisIndex = 0; thisIndex < this.mNumTargets; ++thisIndex) {
            long thisSightTime;
            MoveHistory thisTarget = (MoveHistory)this.mTargetList.get(thisIndex);
            Movement lastSight = thisTarget.GetLastNonEstimate();
            if (lastSight == null || !((double)(thisSightTime = lastSight.GetTimeNow()) < oldestTimeSoFar)) continue;
            oldestTimeSoFar = thisSightTime;
            oldestIndexSoFar = thisIndex;
        }
        return oldestIndexSoFar;
    }

    public final int GetNumFreshTargets() {
        int numFresh = 0;
        for (int thisIndex = 0; thisIndex < this.mNumTargets; ++thisIndex) {
            long thisEstimationTime;
            long thisTime;
            long staleness;
            MoveHistory thisTarget = (MoveHistory)this.mTargetList.get(thisIndex);
            Movement lastMove = thisTarget.GetLastMove();
            if (lastMove == null || (staleness = this.mTimeNow - (thisTime = lastMove.GetTimeNow()) + (thisEstimationTime = lastMove.GetEstimationTicks())) > this.mStalenessLimit) continue;
            ++numFresh;
        }
        return numFresh;
    }

    private final int FindClosestFreshTarget() {
        double closestDistanceSoFar = 999999.9;
        int closestIndexSoFar = -1;
        for (int thisIndex = 0; thisIndex < this.mNumTargets; ++thisIndex) {
            MoveHistory thisTarget = (MoveHistory)this.mTargetList.get(thisIndex);
            Movement lastMove = thisTarget.GetLastMove();
            long staleness = lastMove.GetEstimationTicks();
            if (staleness < this.mStalenessLimit && staleness >= 0L) {
                Location thisLocn = lastMove.GetLocnNow();
                double thisDistance = thisLocn.DistanceTo(this.mTrackerLocn);
                if (!(thisDistance < closestDistanceSoFar)) continue;
                closestDistanceSoFar = thisDistance;
                closestIndexSoFar = thisIndex;
                continue;
            }
            if (staleness >= 0L) continue;
            System.out.println("Tracker error!!! - target in future");
        }
        return closestIndexSoFar;
    }

    public double FindDistanceToClosestFreshTarget() {
        int index = 0;
        double answer = 999999.0;
        if (this.mNumTargets > 0 && (index = this.FindClosestFreshTarget()) >= 0 && index < this.mNumTargets) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(index);
            Movement lastMove = target.GetLastMove();
            Location locn = lastMove.GetLocnNow();
            answer = locn.DistanceTo(this.mTrackerLocn);
        }
        return answer;
    }

    private void AddNewTarget(Sighting newSighting) {
        MoveHistory newTarget = new MoveHistory(newSighting.GetName(), this.mMaxHistory, this.mMovementArea);
        newTarget.ReportSighting(newSighting);
        this.mTargetList.add(newTarget);
        this.mNumTargets = this.mTargetList.size();
    }

    private void UpdateTargetAt(int index, Sighting newSighting) {
        if (index >= 0 && index < this.mNumTargets) {
            MoveHistory thisTarget = (MoveHistory)this.mTargetList.get(index);
            thisTarget.ReportSighting(newSighting);
        }
    }

    public void RemoveAll() {
        for (int index = 0; index < this.mNumTargets; ++index) {
            this.RemoveTargetAt(index);
        }
    }

    private void RemoveTargetAt(int index) {
        if (index == this.mCurrentTargetIndex) {
            this.mCurrentTargetIndex = -1;
        }
        this.mTargetList.remove(index);
        this.mNumTargets = this.mTargetList.size();
    }

    public void SetCurrentTargetIndex(int index) {
        if (index >= 0 && index < this.mNumTargets) {
            this.mCurrentTargetIndex = index;
            ++this.mNumTargetChanges;
        } else {
            System.out.println("ERROR! Tracker::SetCurrentTargetIndex, bad index " + index);
        }
    }

    public void ClearCurrentTarget() {
        this.mCurrentTargetIndex = -1;
    }

    public void SetCurrentTime(long newTime) {
        this.mTimeNow = newTime;
    }

    public final int GetNumTargets() {
        return this.mNumTargets;
    }

    public final Sighting GetCurrentTarget() {
        Sighting answer = null;
        if (this.HasLockOn()) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(this.mCurrentTargetIndex);
            Movement lastMove = target.GetLastMove();
            answer = lastMove.ToSighting(target.GetName());
        }
        return answer;
    }

    public final Sighting GetTargetByIndex(int index) {
        Sighting answer = null;
        if (index >= 0 && index < this.mNumTargets) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(index);
            Movement lastMove = target.GetLastMove();
            answer = lastMove.ToSighting(target.GetName());
        }
        return answer;
    }

    public final MoveHistory GetCurrentTargetHistory() {
        MoveHistory targetHist = null;
        if (this.HasLockOn()) {
            targetHist = (MoveHistory)this.mTargetList.get(this.mCurrentTargetIndex);
        }
        return targetHist;
    }

    public final MoveHistory GetHistoryByIndex(int index) {
        MoveHistory targetHist = null;
        if (index >= 0 && index < this.mNumTargets) {
            targetHist = (MoveHistory)this.mTargetList.get(index);
        } else {
            System.out.println("ERROR: MHTracker.GetHistoryByIndex(),  index " + index + " out of range");
        }
        return targetHist;
    }

    public final long LockOnStaleness() {
        long answer = 0L;
        if (this.HasLockOn()) {
            Sighting targetRef = this.GetCurrentTarget();
            long lockOnTimestamp = targetRef.GetTimestamp();
            answer = this.mTimeNow - lockOnTimestamp;
        } else {
            answer = 999999L;
        }
        return answer;
    }

    public final boolean HasLockOn() {
        boolean answer = false;
        if (this.mCurrentTargetIndex >= 0 && this.mCurrentTargetIndex < this.mNumTargets) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(this.mCurrentTargetIndex);
            if (target != null) {
                if (!target.IsEmpty()) {
                    answer = true;
                } else {
                    System.out.println("ERROR! Tracker::HasLockOn, empty list at " + this.mCurrentTargetIndex);
                }
            } else {
                System.out.println("ERROR! Tracker::HasLockOn, null pointer at " + this.mCurrentTargetIndex);
            }
        }
        return answer;
    }

    public void ReportRobotDeath(String deathName) {
        int posn = this.FindNamedTarget(deathName);
        if (posn >= 0) {
            this.RemoveTargetAt(posn);
        }
    }

    public void ChooseBestTarget() {
        if (this.mChangeTargetAllowed) {
            int index = this.EvaluateBestTarget();
            if (index != this.mCurrentTargetIndex && index >= 0 && index < this.mNumTargets) {
                this.SetCurrentTargetIndex(index);
                if (this.mRadarResyncRef != null) {
                    this.mRadarResyncRef.Resynchronise();
                }
            } else if (this.HasLockOn() && this.LockOnStaleness() > this.mStalenessLimit) {
                Sighting target = this.GetCurrentTarget();
                System.out.println("Stale lock on " + target.GetName() + ", at time " + this.mTimeNow);
                this.mCurrentTargetIndex = -1;
            }
        }
    }

    private final int EvaluateBestTarget() {
        double bestEvalSoFar = 999999.0;
        int bestIndexSoFar = -1;
        for (int thisIndex = 0; thisIndex < this.mNumTargets; ++thisIndex) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(thisIndex);
            Movement lastMove = target.GetLastMove();
            long staleness = lastMove.GetEstimationTicks();
            if (staleness < this.mStalenessLimit && staleness >= 0L) {
                Location targetLocn = lastMove.GetLocnNow();
                double targetDist = targetLocn.DistanceTo(this.mTrackerLocn);
                double targetEnergy = lastMove.GetEnergyNow();
                double targetSpeed = Math.abs(lastMove.GetVelocityNow());
                Heading targetHdng = Heading.valueOfFromTo(this.mTrackerLocn, targetLocn);
                Bearing angleOffGun = Bearing.valueOfFromTo(this.mGunHdng, targetHdng);
                double energyFactor = 0.0;
                if (targetEnergy < this.mEvalDisabledThreshold) {
                    energyFactor = this.mEvalDisabledBonus;
                } else if (targetEnergy < this.mEvalLowEnergyThreshold) {
                    energyFactor = this.mEvalLowEnergyBonus;
                }
                double thisEval = this.mEvalDistanceCoeff * targetDist + this.mEvalAngleCoeff * angleOffGun.GetAbs() + this.mEvalSpeedCoeff * targetSpeed + this.mEvalStaleCoeff * (double)staleness - energyFactor;
                if (!(thisEval < bestEvalSoFar)) continue;
                bestEvalSoFar = thisEval;
                bestIndexSoFar = thisIndex;
                continue;
            }
            if (staleness >= 0L) continue;
            System.out.println("Tracker error!!! - target in future");
        }
        return bestIndexSoFar;
    }

    public double BulletFireDetection() {
        double answer = -1.0;
        if (this.HasLockOn()) {
            MoveHistory target = (MoveHistory)this.mTargetList.get(this.mCurrentTargetIndex);
            double energyDrop = -1.0 * target.GetEnergyDelta(this.mTimeNow);
            double minBulletDrop = GunPhysics.minLegalPwr();
            double maxBulletDrop = GunPhysics.maxLegalPwr();
            if (energyDrop > minBulletDrop - 0.05 && energyDrop < maxBulletDrop + 0.05) {
                answer = energyDrop;
            }
        }
        return answer;
    }

    public void Print() {
        String lockedOnName = "{none}";
        System.out.println("===== MHTracker =====");
        System.out.println("timeNow: " + this.mTimeNow);
        System.out.println("numTargets: " + this.mNumTargets);
        if (this.HasLockOn()) {
            lockedOnName = this.GetCurrentTarget().GetName();
        }
        System.out.println("lockedOn: [" + lockedOnName + "]");
    }
}

