/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations.DC;

import java.awt.Color;
import java.awt.Graphics2D;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.KernelDensity;
import rdt.Wraith.IDebugDrawer;

public class DCDebugGraph
implements IDebugDrawer {
    private KernelDensity _kernelDensity;
    private final int _x;
    private final int _y;
    private final int _width;
    private final int _height;

    public DCDebugGraph(int x, int y, int width, int height) {
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
    }

    public void SetKernelDensity(KernelDensity density) {
        this._kernelDensity = density;
    }

    @Override
    public void DebugDraw(Graphics2D gfx) {
        if (this._kernelDensity == null) {
            return;
        }
        gfx.setColor(new Color(0.05f, 0.05f, 0.05f));
        gfx.fillRect(this._x, this._y, this._width, this._height);
        int minX = this._x + 1;
        int maxX = this._x + this._width - 1;
        int minY = this._y + 1;
        double normalisedFirstStdDev = this._kernelDensity.FirstStdDeviation / this._kernelDensity.MaxKernelDensity;
        for (int x = minX; x <= maxX; ++x) {
            double lookup01 = (double)(x - minX) / (double)(maxX - minX);
            double normalisedKernelDensity = this._kernelDensity.GetNormalisedKernelDensity01(lookup01);
            int maxY = this._y + (int)Math.round(normalisedKernelDensity * ((double)this._height - 2.0));
            gfx.setColor(normalisedKernelDensity >= normalisedFirstStdDev ? Color.cyan : Color.blue);
            gfx.drawLine(x, minY, x, maxY);
        }
        int meanY = this._y + (int)Math.round(this._kernelDensity.Mean / this._kernelDensity.MaxKernelDensity * ((double)this._height - 2.0));
        gfx.setColor(Color.white);
        gfx.drawLine(minX, meanY, maxX, meanY);
        int stdDevY = this._y + (int)Math.round(this._kernelDensity.FirstStdDeviation / this._kernelDensity.MaxKernelDensity * ((double)this._height - 2.0));
        gfx.setColor(Color.gray);
        gfx.drawLine(minX, stdDevY, maxX, stdDevY);
    }
}

