/*
 * Decompiled with CFR 0.152.
 */
package spinnercat.micro;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Tyger
extends AdvancedRobot {
    public static Hashtable<String, TygerEnemy> enemies = new Hashtable();
    static Point2D.Double myPos;
    static Point2D.Double nextPos;
    static TygerEnemy curEnemy;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        curEnemy = new TygerEnemy();
        myPos = nextPos = new Point2D.Double(this.getX(), this.getY());
        while (true) {
            this.setTurnRadarRightRadians(3.0);
            myPos = new Point2D.Double(this.getX(), this.getY());
            if (this.getTime() > 9L) {
                double distance = myPos.distance(curEnemy);
                if (Tyger.curEnemy.isAlive) {
                    this.setFire(Math.min(this.getEnergy() / 8.0, Tyger.curEnemy.energy / 4.0));
                }
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Tyger.absoluteBearing(curEnemy, myPos) - this.getGunHeadingRadians())));
                Point2D.Double safestPoint = new Point2D.Double(-4.0, -4.0);
                double i = 0.0;
                while (i < Math.PI * 2) {
                    Point2D.Double testPoint = Tyger.project(myPos, 30.0 + 150.0 * Math.random(), i);
                    if (this.danger(testPoint) < this.danger(safestPoint)) {
                        safestPoint = testPoint;
                    }
                    i += 0.02;
                }
                if (this.danger(safestPoint) < 0.9 * this.danger(nextPos) || myPos.distance(nextPos) < 25.0 || distance < 25.0) {
                    nextPos = safestPoint;
                } else {
                    double angle = Tyger.absoluteBearing(nextPos, myPos) - this.getHeadingRadians();
                    double direction = 1.0;
                    if (Math.cos(angle) < 0.0) {
                        angle += Math.PI;
                        direction = -1.0;
                    }
                    this.setAhead(Math.min(25.0 * direction, nextPos.distance(myPos)));
                    angle = Utils.normalRelativeAngle((double)angle);
                    this.setTurnRightRadians(angle);
                    this.setMaxVelocity(Math.abs(angle) > 1.0 ? 0.0 : 8.0);
                }
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        TygerEnemy enemy = enemies.get(e.getName());
        if (enemy == null) {
            enemy = new TygerEnemy();
            enemies.put(e.getName(), enemy);
        }
        enemy.energy = e.getEnergy();
        Point2D.Double enemyPos = Tyger.project(myPos, e.getDistance(), this.getHeadingRadians() + e.getBearingRadians());
        enemy.x = enemyPos.x;
        enemy.y = enemyPos.y;
        enemy.isAlive = true;
        if (!Tyger.curEnemy.isAlive || curEnemy == null || e.getDistance() < curEnemy.distance(myPos) - 15.0) {
            curEnemy = enemy;
        }
    }

    public double danger(Point2D.Double p) {
        if (!new Rectangle2D.Double(25.0, 25.0, this.getBattleFieldWidth() - 50.0, this.getBattleFieldHeight() - 50.0).contains(p)) {
            return Double.POSITIVE_INFINITY;
        }
        double danger = 0.4 / p.distanceSq(myPos);
        Enumeration<TygerEnemy> e = enemies.elements();
        while (e.hasMoreElements()) {
            TygerEnemy en = e.nextElement();
            if (!en.isAlive) continue;
            danger += Math.min(en.energy / this.getEnergy(), 2.0) * (1.0 + 2.0 * Math.abs(Math.cos(Tyger.absoluteBearing(myPos, en) - Tyger.absoluteBearing(p, en)) / p.distanceSq(en)));
        }
        return danger;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Tyger.enemies.get((Object)e.getName()).isAlive = false;
    }

    private static Point2D.Double project(Point2D.Double p, double dist, double ang) {
        return new Point2D.Double(p.x + dist * Math.sin(ang), p.y + dist * Math.cos(ang));
    }

    private static double absoluteBearing(Point2D.Double target, Point2D.Double start) {
        return Math.atan2(target.x - start.x, target.y - start.y);
    }

    public class TygerEnemy
    extends Point2D.Double {
        public double energy;
        public boolean isAlive;
    }
}

