/*
 * Decompiled with CFR 0.152.
 */
package ags.util;

public class Range
implements Cloneable {
    private double upper;
    private double lower;

    public Range(double v1, double v2) {
        this.lower = Math.min(v1, v2);
        this.upper = Math.max(v1, v2);
    }

    public Range(double v) {
        this(v, v);
    }

    public Range clone() {
        return new Range(this.lower, this.upper);
    }

    public boolean intersects(double n) {
        return n >= this.lower && n <= this.upper;
    }

    public boolean intersects(Range r) {
        return !(this.lower > r.upper) && !(r.lower > this.upper);
    }

    public double distanceOutside(double n) {
        if (n > this.upper) {
            return n - this.upper;
        }
        if (n < this.lower) {
            return this.lower - n;
        }
        return 0.0;
    }

    public boolean looseIntersect(double n, double a) {
        return n >= this.lower - a && n <= this.upper + a;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public Range grow(Range r) {
        return this.grow(r.lower, r.upper);
    }

    public Range grow(double v1, double v2) {
        return new Range(Math.min(this.lower, Math.min(v1, v2)), Math.max(this.upper, Math.max(v1, v2)));
    }

    public Range grow(double v) {
        return new Range(Math.min(this.lower, v), Math.max(this.upper, v));
    }

    public void growInPlace(double v) {
        this.lower = Math.min(this.lower, v);
        this.upper = Math.max(this.upper, v);
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    public double getCenter() {
        return 0.5 * (this.upper + this.lower);
    }

    public static Range getIntersection(Range r1, Range r2) {
        if (r2.lower > r1.upper || r1.lower > r2.upper) {
            return null;
        }
        return Range.getMiddle(r1, r2);
    }

    public static Range getMiddle(Range r1, Range r2) {
        return new Range(Math.max(r1.lower, r2.lower), Math.min(r1.upper, r2.upper));
    }

    public String toString() {
        return "Range: " + Math.rint(this.lower * 1000.0) / 1000.0 + " to " + Math.rint(this.upper * 1000.0) / 1000.0;
    }
}

