/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.iterator;

import org.la4j.iterator.CursorIterator;
import org.la4j.iterator.CursorToVectorIterator;
import org.la4j.iterator.JoinFunction;

public abstract class VectorIterator
extends CursorIterator {
    protected final int length;

    public VectorIterator(int length) {
        this.length = length;
    }

    public abstract int index();

    public VectorIterator orElseAdd(VectorIterator those) {
        return new CursorToVectorIterator(super.orElse(those, JoinFunction.ADD), this.length);
    }

    public VectorIterator orElseSubtract(VectorIterator those) {
        return new CursorToVectorIterator(super.orElse(those, JoinFunction.SUB), this.length);
    }

    public VectorIterator andAlsoMultiply(VectorIterator those) {
        return new CursorToVectorIterator(super.andAlso(those, JoinFunction.MUL), this.length);
    }

    public VectorIterator andAlsoDivide(VectorIterator those) {
        return new CursorToVectorIterator(super.andAlso(those, JoinFunction.DIV), this.length);
    }

    public double innerProduct(VectorIterator those) {
        VectorIterator both = this.andAlsoMultiply(those);
        double acc = 0.0;
        while (both.hasNext()) {
            acc += ((Double)both.next()).doubleValue();
        }
        return acc;
    }

    @Override
    protected int cursor() {
        return this.index();
    }
}

