/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector.dense;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.vector.DenseVector;
import org.la4j.vector.VectorFactory;

public class BasicVector
extends DenseVector {
    private static final byte VECTOR_TAG = 0;
    private double[] self;

    public static BasicVector zero(int length) {
        return new BasicVector(length);
    }

    public static BasicVector constant(int length, double value) {
        double[] array = new double[length];
        Arrays.fill(array, value);
        return new BasicVector(array);
    }

    public static BasicVector unit(int length) {
        return BasicVector.constant(length, 1.0);
    }

    public static BasicVector random(int length, Random random) {
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = random.nextDouble();
        }
        return new BasicVector(array);
    }

    public static BasicVector fromArray(double[] array) {
        return new BasicVector(array);
    }

    public static BasicVector fromBinary(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (buffer.get() != 0) {
            throw new IllegalArgumentException("Can not decode BasicVector from the given byte array.");
        }
        double[] values2 = new double[buffer.getInt()];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = buffer.getDouble();
        }
        return new BasicVector(values2);
    }

    public static BasicVector fromCSV(String csv) {
        return Vector.fromCSV(csv).to(Vectors.BASIC);
    }

    public static BasicVector fromMatrixMarket(String mm) {
        return Vector.fromMatrixMarket(mm).to(Vectors.BASIC);
    }

    public static BasicVector fromCollection(Collection<? extends Number> list) {
        double[] self = new double[list.size()];
        int i = 0;
        for (Number number : list) {
            self[i] = number.doubleValue();
            ++i;
        }
        return BasicVector.fromArray(self);
    }

    public static BasicVector fromMap(Map<Integer, ? extends Number> map, int length) {
        return Vector.fromMap(map, length).to(Vectors.BASIC);
    }

    public BasicVector() {
        this(0);
    }

    public BasicVector(int length) {
        this(new double[length]);
    }

    public BasicVector(double[] array) {
        super(array.length);
        this.self = array;
    }

    @Override
    public double get(int i) {
        return this.self[i];
    }

    @Override
    public void set(int i, double value) {
        this.self[i] = value;
    }

    @Override
    public void swapElements(int i, int j) {
        if (i != j) {
            double d = this.self[i];
            this.self[i] = this.self[j];
            this.self[j] = d;
        }
    }

    @Override
    public Vector copyOfLength(int length) {
        this.ensureLengthIsCorrect(length);
        double[] $self = new double[length];
        System.arraycopy(this.self, 0, $self, 0, Math.min($self.length, this.self.length));
        return new BasicVector($self);
    }

    @Override
    public double[] toArray() {
        double[] result = new double[this.length];
        System.arraycopy(this.self, 0, result, 0, this.length);
        return result;
    }

    @Override
    public <T extends Vector> T to(VectorFactory<T> factory) {
        if (factory.outputClass == BasicVector.class) {
            return (T)((Vector)factory.outputClass.cast(this));
        }
        return super.to(factory);
    }

    @Override
    public Vector blankOfLength(int length) {
        return BasicVector.zero(length);
    }

    @Override
    public byte[] toBinary() {
        int size = 5 + 8 * this.length;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)0);
        buffer.putInt(this.length);
        for (double value : this.self) {
            buffer.putDouble(value);
        }
        return buffer.array();
    }
}

