/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import synapse.BaseBot;
import synapse.Enemy;
import synapse.Module;

public class Intel
extends Module {
    BaseBot bot;

    public Intel(BaseBot bot) {
        this.bot = bot;
    }

    @Override
    public void useEvent(Event evt) {
        if (evt instanceof SkippedTurnEvent) {
            System.out.println("Skipped turn" + evt.getTime());
        } else if (evt instanceof RobotDeathEvent) {
            String deadBotName = ((RobotDeathEvent)evt).getName();
            Enemy deadBot = this.bot.targets.get(deadBotName);
            if (deadBot != null) {
                deadBot.live = false;
                this.bot.targets.remove(deadBotName);
            }
        } else if (evt instanceof ScannedRobotEvent) {
            Enemy en;
            ScannedRobotEvent e = (ScannedRobotEvent)evt;
            if (this.bot.targets.containsKey(e.getName())) {
                en = this.bot.targets.get(e.getName());
                en.oldOldLocation.setLocation(en.oldLocation);
                en.oldLocation.setLocation(en.location);
                en.energyDrop = en.energy - e.getEnergy();
                en.oldVelocity = en.velocity;
            } else {
                en = new Enemy();
                this.bot.targets.put(e.getName(), en);
                en.name = e.getName();
                en.ctime = e.getTime();
                en.location.x = this.bot.getX() + Math.sin(this.bot.getHeadingRadians() + e.getBearingRadians()) * e.getDistance();
                en.location.y = this.bot.getY() + Math.cos(this.bot.getHeadingRadians() + e.getBearingRadians()) * e.getDistance();
                en.oldLocation.setLocation(en.location);
                en.oldOldLocation.setLocation(en.oldLocation);
                en.oldVelocity = e.getVelocity();
                System.out.println("Enemy sighted: " + en.name);
            }
            en.bearing = e.getBearingRadians();
            en.location.x = this.bot.getX() + Math.sin(this.bot.getHeadingRadians() + en.bearing) * e.getDistance();
            en.location.y = this.bot.getY() + Math.cos(this.bot.getHeadingRadians() + en.bearing) * e.getDistance();
            en.energy = e.getEnergy();
            en.distance = e.getDistance();
            en.live = true;
            en.velocity = e.getVelocity();
            en.rollingAverageVelocity = en.rollingAverageVelocity * 0.75 + en.velocity * 0.25;
            en.heading = e.getHeadingRadians();
            if (e.getName() == this.bot.target.name) {
                ++this.bot.numTargetScans;
                this.bot.target = en;
            }
            if (en.distance < this.bot.target.distance * 0.7 || !this.bot.target.live || en.energy == 0.0) {
                this.bot.target = en;
            }
            if (en.velocity == 0.0 && Math.abs(en.oldVelocity) > 2.0 && e.getTime() - en.ctime == 1L) {
                en.energyDrop -= Math.max(0.0, Math.abs(en.oldVelocity) / 2.0 - 1.0);
            }
            en.oldCtime = en.ctime;
            en.ctime = e.getTime();
            if (en.energyDrop > 0.0) {
                ++this.bot.shotsFiredEnemy;
                ++BaseBot.shotsFiredBattleEnemy;
                this.bot.totalPowerFiredEnemy += en.energyDrop;
            }
        } else if (evt instanceof BulletHitEvent) {
            BulletHitEvent e = (BulletHitEvent)evt;
            Bullet b = e.getBullet();
            Enemy x = this.bot.targets.get(e.getName());
            if (x != null) {
                x.energy -= Rules.getBulletDamage((double)b.getPower());
            }
            this.bot.totalPowerHit += b.getPower();
            ++this.bot.shotsHit;
            ++BaseBot.shotsHitBattle;
            this.bot.totalDamageInflicted += Rules.getBulletDamage((double)b.getPower());
        } else if (evt instanceof HitByBulletEvent) {
            HitByBulletEvent e = (HitByBulletEvent)evt;
            Bullet b = e.getBullet();
            Enemy x = this.bot.targets.get(e.getName());
            if (x != null && x.live) {
                x.energy += 3.0 * b.getPower();
            }
            ++this.bot.shotsHitEnemy;
            ++BaseBot.shotsHitBattleEnemy;
            this.bot.totalPowerHitEnemy += b.getPower();
            this.bot.totalDamageInflictedEnemy += Rules.getBulletDamage((double)b.getPower());
        } else if (evt instanceof HitRobotEvent) {
            HitRobotEvent e = (HitRobotEvent)evt;
            Enemy x = this.bot.targets.get(e.getName());
            if (x != null) {
                x.energy -= 0.6;
            }
        } else if (evt instanceof HitWallEvent) {
            System.out.println(String.valueOf(this.bot.time) + " Hit wall" + (this.bot.oldVelocity > 2.0 ? " and took damage." : "."));
        }
    }

    @Override
    public String toString() {
        return "Intel";
    }
}

