/*
 * Decompiled with CFR 0.152.
 */
package matt.advanced;

import java.awt.Color;
import java.awt.geom.Point2D;
import matt.AntiGravEngine;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Katana
extends AdvancedRobot {
    static int maxMode = 10;
    static int maxTargeting = 3;
    static double[] modeNN = new double[maxMode];
    static double[] targetingNN = new double[maxTargeting];
    static int maxOp;
    int NoSee;
    AntiGravEngine ag_ll;
    AntiGravEngine ag_lr;
    AntiGravEngine ag_ul;
    AntiGravEngine ag_ur;
    AntiGravEngine ag_enemy;
    AntiGravEngine ag_center;
    AntiGravEngine ag_rnd;
    boolean interupt;
    int direction;
    int scanNum;
    int mode;
    int targeting;
    double battleFieldWidth;
    double battleFieldHeight;
    double lastHeading;
    double lastV;
    double lastRawV;
    double lastEnemyY;
    double lastEnemyX;
    double bearing;
    boolean gotBearing;
    long scanTime;
    double cornerRange;
    double lastX;
    double lastY;
    double sameSpotTol;
    String myName;
    String enemyName;
    double sM;
    double sT;

    public void run() {
        maxOp = this.getOthers();
        if (this.getRoundNum() == 0) {
            Katana.modeNN[0] = -1.0;
            Katana.modeNN[1] = 2;
            Katana.modeNN[1] = Double.NEGATIVE_INFINITY;
            Katana.modeNN[2] = Double.NEGATIVE_INFINITY;
            Katana.modeNN[3] = Double.NEGATIVE_INFINITY;
            Katana.modeNN[4] = Double.NEGATIVE_INFINITY;
            Katana.modeNN[5] = Double.NEGATIVE_INFINITY;
            Katana.modeNN[6] = Double.NEGATIVE_INFINITY;
            Katana.modeNN[7] = 1.5 * (double)maxOp;
            Katana.modeNN[7] = Double.POSITIVE_INFINITY;
            Katana.modeNN[8] = -2.0;
            Katana.modeNN[9] = maxOp / 4;
            Katana.targetingNN[0] = Double.NEGATIVE_INFINITY;
            Katana.targetingNN[1] = 1.0;
            Katana.targetingNN[2] = -1.0;
        }
        int lastMode = 0;
        double hiMode = Double.NEGATIVE_INFINITY;
        int loopMode = 0;
        while (loopMode < maxMode) {
            if (modeNN[loopMode] >= hiMode) {
                hiMode = modeNN[loopMode];
                lastMode = loopMode;
            }
            ++loopMode;
        }
        this.sM = lastMode;
        int lastT = 0;
        double hiT = Double.NEGATIVE_INFINITY;
        int loopT = 0;
        while (loopT < maxTargeting) {
            if (targetingNN[loopT] > hiT) {
                hiT = targetingNN[loopT];
                lastT = loopT;
            }
            ++loopT;
        }
        this.sT = lastT;
        this.myName = this.getName();
        this.setColors(Color.yellow, Color.yellow, Color.gray);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.battleFieldWidth = this.getBattleFieldWidth();
        this.battleFieldHeight = this.getBattleFieldHeight();
        this.cornerRange = this.battleFieldWidth / 10.0;
        this.cornerRange = 75.0;
        this.ag_ll.setLocation(0.0, 0.0);
        this.ag_ll.setForce(200.0);
        this.ag_ul.setLocation(this.battleFieldHeight, 0.0);
        this.ag_ul.setForce(200.0);
        this.ag_lr.setLocation(0.0, this.battleFieldWidth);
        this.ag_lr.setForce(200.0);
        this.ag_ur.setLocation(this.battleFieldHeight, this.battleFieldWidth);
        this.ag_ur.setForce(200.0);
        this.ag_center.setLocation(this.battleFieldWidth / (double)2, this.battleFieldWidth / (double)2);
        this.ag_center.setForce(150.0, 2);
        this.ag_enemy.setLocation(-100.0, -100.0);
        this.ag_enemy.setForce(350.0);
        this.ag_rnd.setLocation(Math.random() * this.battleFieldWidth + 1.0, Math.random() * this.battleFieldHeight + 1.0);
        this.ag_rnd.setForce(400.0);
        while (true) {
            this.turnRadarRight(360.0);
            ++this.NoSee;
            if (this.NoSee >= 5) {
                this.moveAhead(250.0);
            }
            if (this.getOthers() != 1) continue;
            Katana.modeNN[9] = Double.NEGATIVE_INFINITY;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (!this.interupt) {
            return;
        }
        this.NoSee = 0;
        long velocityTime = this.getTime() - this.scanTime;
        this.scanTime = this.getTime();
        double dist = e.getDistance();
        double playerX = this.getX();
        double playerY = this.getY();
        double bearing = (Math.toRadians(this.getHeading()) + e.getBearingRadians()) % (Math.PI * 2);
        double enemyX = playerX + dist * Math.sin(bearing);
        double enemyY = playerY + dist * Math.cos(bearing);
        double enemyV = Point2D.distance(enemyX, enemyY, this.lastEnemyX, this.lastEnemyY) / (double)velocityTime * this.lastRawV;
        this.ag_enemy.setLocation(enemyX, enemyY);
        this.ag_rnd.setLocation(Math.random() * this.battleFieldWidth + 1.0, Math.random() * this.battleFieldHeight + 1.0);
        this.lastEnemyY = enemyY;
        this.lastEnemyX = enemyX;
        if (this.getOthers() == 1) {
            this.gotBearing = true;
            bearing = e.getBearing();
        }
        double enemyHeading = e.getHeadingRadians();
        double turnRate = enemyHeading - this.lastHeading;
        this.targeting = 1;
        this.mode = 0;
        int lastMode = 0;
        double hiMode = Double.NEGATIVE_INFINITY;
        int loopMode = 0;
        while (loopMode < maxMode) {
            if (modeNN[loopMode] >= hiMode) {
                hiMode = modeNN[loopMode];
                lastMode = loopMode;
            }
            ++loopMode;
        }
        this.mode = lastMode;
        int lastT = 0;
        double hiT = Double.NEGATIVE_INFINITY;
        int loopT = 0;
        while (loopT < maxTargeting) {
            if (targetingNN[loopT] > hiT) {
                hiT = targetingNN[loopT];
                lastT = loopT;
            }
            ++loopT;
        }
        this.targeting = lastT;
        if (e.getEnergy() == 0.0 && e.getVelocity() == 0.0) {
            this.targeting = 2;
        }
        if (e.getName().length() >= 14 && this.getOthers() > 1 && this.getName().subSequence(0, 14).equals(e.getName().subSequence(0, 14))) {
            this.targeting = 0;
        }
        boolean target = false;
        while (!target) {
            switch (this.targeting) {
                case 0: {
                    target = true;
                    break;
                }
                case 1: {
                    double power = 500.0 / e.getDistance();
                    if (power > (double)3) {
                        power = 3;
                    }
                    if (power < 0.1) {
                        power = 0.1;
                    }
                    double bulletV = 20.0 - (double)3 * power;
                    double enemyH = e.getHeadingRadians();
                    double gunH = this.getGunHeading();
                    double predictD = e.getDistance();
                    double predictX = enemyX;
                    double predictY = enemyY;
                    double theta = 0.0;
                    double time2 = 0.0;
                    double t = 0.0;
                    double timeTheta = 0.0;
                    double tolerance = 0.4;
                    double time0 = dist / bulletV;
                    int deltaT = 0;
                    double lastDiff = Double.POSITIVE_INFINITY;
                    deltaT = -700;
                    while (deltaT <= 700) {
                        t = time0 + (double)deltaT;
                        predictX = enemyX + enemyV * t * Math.sin(enemyH + turnRate);
                        predictY = enemyY + enemyV * t * Math.cos(enemyH + turnRate);
                        if (predictX < 18.0) {
                            predictX = 18.0;
                        } else if (predictX > this.battleFieldWidth - 18.0) {
                            predictX = this.battleFieldWidth - 18.0;
                        }
                        if (predictY < 18.0) {
                            predictY = 18.0;
                        } else if (predictY > this.battleFieldHeight - 18.0) {
                            predictY = this.battleFieldHeight - 18.0;
                        }
                        predictD = Point2D.Double.distance(playerX, playerY, predictX, predictY);
                        timeTheta = this.absoluteBearing(playerX, playerY, predictX, predictY);
                        timeTheta = this.normalizeBearing(timeTheta - gunH);
                        time2 = predictD / bulletV + timeTheta / 20.0;
                        if (Math.abs(t - time2) <= lastDiff) {
                            theta = this.absoluteBearing(playerX, playerY, predictX, predictY);
                            theta = this.normalizeBearing(theta - gunH);
                            lastDiff = Math.abs(t - time2);
                        }
                        ++deltaT;
                    }
                    this.turnGunRight(this.normalizeBearing(theta));
                    this.shoot(power);
                    target = true;
                    break;
                }
                case 2: {
                    double powerHead = 600.0 / e.getDistance();
                    this.turnGunRight(this.normalizeBearing(this.getHeading() - this.getGunHeading() + e.getBearing()));
                    this.shoot(powerHead);
                    target = true;
                    break;
                }
                default: {
                    this.targeting = 2;
                }
            }
        }
        boolean modego = false;
        while (!modego) {
            switch (this.mode) {
                case 0: {
                    if (this.getX() < this.cornerRange && this.getY() < this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() < this.cornerRange && this.getY() > this.battleFieldHeight - this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() > this.battleFieldWidth - this.cornerRange && this.getY() < this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() > this.battleFieldWidth - this.cornerRange && this.getY() > this.battleFieldHeight - this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    int getClose = 20 * this.direction;
                    getClose = e.getDistance() < 250.0 ? (getClose *= -1) : 13 * this.direction;
                    double turn = this.normalizeBearing(e.getBearing() + 90.0 - (double)getClose);
                    double move = 70 + (int)(Math.random() * 80.0 + 1.0);
                    double curX = this.getX();
                    double curY = this.getY();
                    double curH = Math.toRadians(this.getHeading() + turn);
                    double turnS = 45.0;
                    double preX = curX + move * (double)this.direction * Math.sin(curH);
                    double preY = curX + move * (double)this.direction * Math.cos(curH);
                    this.turnRight(turn);
                    this.moveAhead(move);
                    modego = true;
                    break;
                }
                case 1: {
                    if (this.getX() < this.cornerRange && this.getY() < this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() < this.cornerRange && this.getY() > this.battleFieldHeight - this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() > this.battleFieldWidth - this.cornerRange && this.getY() < this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() > this.battleFieldWidth - this.cornerRange && this.getY() > this.battleFieldHeight - this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    this.direction *= -1;
                    double getCloseD = 20 * this.direction;
                    getCloseD = e.getDistance() < 250.0 ? (getCloseD *= -1.0) : (double)(10 * this.direction);
                    double dodgeT = e.getBearing() + 90.0 - getCloseD;
                    double dodgeM = 150.0;
                    double myX = this.getX();
                    double myY = this.getY();
                    double myH = Math.toRadians(this.getHeading() + dodgeT);
                    double turnD = 45.0;
                    double preXd = myX + dodgeM * (double)this.direction * Math.sin(myH);
                    double preYd = myY + dodgeM * (double)this.direction * Math.cos(myH);
                    this.turnRight(dodgeT);
                    this.moveAhead(dodgeM);
                    modego = true;
                    break;
                }
                case 2: {
                    int oldD = this.direction;
                    this.direction = 1;
                    double RpredictX = enemyX + e.getVelocity() * (e.getDistance() / 8.0) * Math.sin(e.getHeadingRadians() + turnRate);
                    double RpredictY = enemyY + e.getVelocity() * (e.getDistance() / 8.0) * Math.cos(e.getHeadingRadians() + turnRate);
                    if (RpredictX < 18.0) {
                        RpredictX = 18.0;
                    }
                    if (RpredictX > this.battleFieldWidth - 18.0) {
                        RpredictX = this.battleFieldWidth - 18.0;
                    }
                    if (RpredictY < 18.0) {
                        RpredictY = 18.0;
                    }
                    if (RpredictY > this.battleFieldHeight - 18.0) {
                        RpredictY = this.battleFieldHeight - 18.0;
                    }
                    double turnR = this.absoluteBearing(this.getX(), this.getY(), RpredictX, RpredictY) - this.getHeading();
                    this.turnRight(this.normalizeBearing(turnR));
                    this.moveAhead(e.getDistance());
                    this.direction = oldD;
                    modego = true;
                    break;
                }
                case 3: {
                    int t = (int)(Math.random() * 35.0 + 1.0);
                    int g = (int)(Math.random() * 50.0 + 1.0);
                    this.turnRight(t);
                    this.moveAhead(100 + g);
                    modego = true;
                }
                case 4: {
                    double turnToCenter = this.absoluteBearing(this.getX(), this.getY(), this.battleFieldWidth / (double)2, this.battleFieldHeight / (double)2);
                    turnToCenter = this.normalizeBearing(turnToCenter - this.getHeading());
                    double more = -20.0 + (Math.random() * 40.0 + 1.0);
                    more = 40.0;
                    if (Math.random() + 1.0 > 1.0) {
                        more *= -1.0;
                    }
                    this.turnRight(this.normalizeBearing(turnToCenter + more));
                    this.ahead(Point2D.distance(this.getX(), this.getY(), this.battleFieldWidth / (double)2, this.battleFieldHeight / (double)2) / 6.0);
                    this.direction = 1;
                    modego = true;
                    break;
                }
                case 5: {
                    modego = true;
                    break;
                }
                case 6: {
                    Point2D.Double start = new Point2D.Double(this.getX(), this.getY());
                    Point2D.Double LL = new Point2D.Double(18.0, 18.0);
                    Point2D.Double LR = new Point2D.Double(this.battleFieldWidth - 18.0, 18.0);
                    Point2D.Double UL = new Point2D.Double(18.0, this.battleFieldHeight - 18.0);
                    Point2D.Double UR = new Point2D.Double(this.battleFieldWidth - 18.0, this.battleFieldHeight - 18.0);
                    double distLL = start.distance(LL);
                    double distLR = start.distance(LR);
                    double distUL = start.distance(UL);
                    double distUR = start.distance(UR);
                    if (this.getY() > this.battleFieldHeight / (double)2) {
                        if (distUR < distUL) {
                            this.turnRight(this.normalizeBearing(this.absoluteBearing(this.getX(), this.getY(), ((Point2D)UR).getX(), ((Point2D)UR).getY()) - this.getHeading()));
                            this.ahead(distUR);
                        } else {
                            this.turnRight(this.normalizeBearing(this.absoluteBearing(this.getX(), this.getY(), ((Point2D)UL).getX(), ((Point2D)UL).getY()) - this.getHeading()));
                            this.ahead(distUL);
                        }
                    } else if (distLR < distLR) {
                        this.turnRight(this.normalizeBearing(this.absoluteBearing(this.getX(), this.getY(), ((Point2D)LR).getX(), ((Point2D)LR).getY()) - this.getHeading()));
                        this.ahead(distLR);
                    } else {
                        this.turnRight(this.normalizeBearing(this.absoluteBearing(this.getX(), this.getY(), ((Point2D)LL).getX(), ((Point2D)LL).getY()) - this.getHeading()));
                        this.ahead(distLL);
                    }
                    modego = true;
                    break;
                }
                case 7: {
                    double myHeading = this.getHeading();
                    double aheadDist = 50 + (int)(Math.random() * 150.0 + 1.0);
                    double preT = this.normalizeBearing(e.getBearing() + 90.0);
                    preT = 0.0;
                    double turnAmt = 0.0;
                    double newX = 0.0;
                    double newY = 0.0;
                    double lowForce = Double.POSITIVE_INFINITY;
                    double turnTo = 0.0;
                    double tempForce = 0.0;
                    double amyX = this.getX();
                    double amyY = this.getY();
                    turnAmt = -60.0;
                    while (turnAmt <= 60.0) {
                        tempForce = 0.0;
                        newX = playerX + aheadDist * (double)this.direction * Math.sin(Math.toRadians(myHeading + turnAmt + preT));
                        newY = playerY + aheadDist * (double)this.direction * Math.cos(Math.toRadians(myHeading + turnAmt + preT));
                        tempForce += this.ag_enemy.getActingForcePoint(newX, newY);
                        tempForce += this.ag_center.getActingForcePoint(newX, newY);
                        tempForce += this.ag_ll.getActingForcePoint(newX, newY);
                        tempForce += this.ag_lr.getActingForcePoint(newX, newY);
                        tempForce += this.ag_ul.getActingForcePoint(newX, newY);
                        tempForce += this.ag_ur.getActingForcePoint(newX, newY);
                        tempForce += this.ag_rnd.getActingForcePoint(newX, newY);
                        tempForce += 100.0 / Math.pow(newX, 2);
                        tempForce += 100.0 / Math.pow(newY, 2);
                        tempForce += 100.0 / Math.pow(this.battleFieldWidth - newX, 2);
                        if ((tempForce += 100.0 / Math.pow(this.battleFieldHeight - newY, 2)) < lowForce) {
                            lowForce = tempForce;
                            turnTo = turnAmt + preT;
                        } else if (tempForce == lowForce && Math.abs(turnAmt + preT) > Math.abs(turnTo)) {
                            lowForce = tempForce;
                            turnTo = turnAmt + preT;
                        }
                        turnAmt += 0.01;
                    }
                    this.turnRight(this.normalizeBearing(turnTo));
                    this.moveAhead(aheadDist);
                    modego = true;
                    break;
                }
                case 8: {
                    if (this.getX() < this.cornerRange && this.getY() < this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() < this.cornerRange && this.getY() > this.battleFieldHeight - this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() > this.battleFieldWidth - this.cornerRange && this.getY() < this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    if (this.getX() > this.battleFieldWidth - this.cornerRange && this.getY() > this.battleFieldHeight - this.cornerRange) {
                        this.mode = 4;
                        break;
                    }
                    double rndAhead = 50.0 + (Math.random() * 70.0 + 1.0);
                    double rndTurn = -80.0 + (Math.random() * 160.0 + 1.0);
                    rndTurn = e.getBearing() + 90.0;
                    rndTurn -= 50.0;
                    this.turnRight(this.normalizeBearing(rndTurn += Math.random() * 100.0 + 1.0));
                    this.moveAhead(rndAhead);
                    modego = true;
                    break;
                }
                case 9: {
                    if (this.getX() > 20.0 && this.getY() > 20.0 && this.getX() < this.battleFieldWidth - 20.0 && this.getY() < this.battleFieldHeight - 20.0) {
                        if (this.getX() < this.battleFieldWidth / (double)2) {
                            this.turnLeft(this.getHeading() + 90.0);
                        } else {
                            this.turnRight((this.getHeading() + 90.0) * -1.0);
                        }
                        this.moveAhead(this.getX() - 18.0);
                    }
                    this.moveAhead(70.0);
                    modego = true;
                    break;
                }
                default: {
                    this.mode = 8;
                }
            }
        }
        ++this.scanNum;
        this.lastHeading = enemyHeading;
        this.lastV = enemyV;
        if (e.getVelocity() > 0.0) {
            this.lastRawV = 1.0;
        }
        if (e.getVelocity() < 0.0) {
            this.lastRawV = -1.0;
        }
        this.turnRadarRight(this.normalizeBearing(this.getHeading() - this.getRadarHeading() + e.getBearing()) + 40.0);
        this.turnRadarLeft(80.0);
        int n = this.mode;
        modeNN[n] = modeNN[n] + 0.01;
        this.lastX = this.getX();
        this.lastY = this.getY();
    }

    public void onHitWall(HitWallEvent e) {
        if (this.mode == 9) {
            this.turnRight(90.0);
            return;
        }
        if (this.mode != 1) {
            this.direction *= -1;
        } else if (this.NoSee >= 5) {
            this.direction *= -1;
        }
    }

    public void onWin(WinEvent e) {
        int n = this.mode;
        modeNN[n] = modeNN[n] + 1.0;
        int n2 = this.targeting;
        targetingNN[n2] = targetingNN[n2] + 1.0;
        while (true) {
            this.turnGunRight(30.0);
            this.turnLeft(30.0);
            this.turnRadarLeft(30.0);
        }
    }

    public void onDeath(DeathEvent e) {
        int n = this.mode;
        modeNN[n] = modeNN[n] - (double)2;
        int n2 = (int)this.sM;
        modeNN[n2] = modeNN[n2] - (double)4;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.direction *= -1;
        int n = this.mode;
        modeNN[n] = modeNN[n] - 0.5;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        int n = this.mode;
        modeNN[n] = modeNN[n] - 0.25;
    }

    public void onBulletHit(BulletHitEvent e) {
        int n = this.targeting;
        targetingNN[n] = targetingNN[n] + 0.25;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        int n = this.targeting;
        targetingNN[n] = targetingNN[n] - 0.05;
    }

    public void turnRight(double angle) {
        this.setTurnRight(angle);
    }

    public void turnLeft(double angle) {
        this.setTurnLeft(angle);
    }

    void moveAhead(double distance) {
        this.setAhead(distance * (double)this.direction);
    }

    void shoot(double power) {
        if (power < this.getEnergy()) {
            this.fire(power);
        }
    }

    double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    private final /* synthetic */ void this() {
        this.NoSee = 0;
        this.ag_ll = new AntiGravEngine();
        this.ag_lr = new AntiGravEngine();
        this.ag_ul = new AntiGravEngine();
        this.ag_ur = new AntiGravEngine();
        this.ag_enemy = new AntiGravEngine();
        this.ag_center = new AntiGravEngine();
        this.ag_rnd = new AntiGravEngine();
        this.interupt = true;
        this.direction = 1;
        this.scanNum = 0;
        this.mode = 0;
        this.targeting = 1;
        this.lastHeading = 0.0;
        this.lastV = 0.0;
        this.lastRawV = 0.0;
        this.lastEnemyY = 0.0;
        this.lastEnemyX = 0.0;
        this.bearing = 0.0;
        this.gotBearing = false;
        this.scanTime = 0L;
        this.cornerRange = 0.0;
        this.lastX = -100.0;
        this.lastY = -100.0;
        this.sameSpotTol = 0.0;
    }

    public Katana() {
        this.this();
    }
}

