/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.wave;

import eem.frame.bot.InfoBot;
import eem.frame.core.CoreBot;
import eem.frame.event.waveListener;
import eem.frame.misc.HashCounter;
import eem.frame.misc.physics;
import eem.frame.wave.wave;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.Bullet;
import robocode.HitByBulletEvent;

public class wavesManager {
    public CoreBot myBot;
    public LinkedList<wave> Waves = new LinkedList();
    public HashCounter<String> waveCount = new HashCounter();
    public LinkedList<waveListener> waveListeners = new LinkedList();

    public wavesManager(CoreBot coreBot) {
        this.myBot = coreBot;
    }

    public void initTic(long l) {
        LinkedList<InfoBot> linkedList = CoreBot._gameinfo._botsmanager.listOfAliveBots();
        this.remove(this.getListOfPassedWaves(linkedList, l));
        this.checkForPassingOverBotsWaves(linkedList, l);
    }

    public void checkForPassingOverBotsWaves(LinkedList<InfoBot> linkedList, long l) {
        for (wave wave2 : this.Waves) {
            for (InfoBot infoBot : linkedList) {
                if (!wave2.isPassingOverBot(infoBot, l)) continue;
                CoreBot._gameinfo.onWavePassingOverBot(wave2, infoBot);
            }
        }
    }

    public void add(InfoBot infoBot, long l, double d) {
        wave wave2 = new wave(infoBot, l, d);
        this.Waves.add(wave2);
    }

    public void add(wave wave2) {
        this.Waves.add(wave2);
        this.waveCount.incrHashCounter(wave2.firedBot.getName());
        wave2.setCount(this.waveCount.getHashCounter(wave2.firedBot.getName()));
        for (waveListener waveListener2 : this.waveListeners) {
            waveListener2.waveAdded(wave2);
        }
    }

    public void remove(wave wave2) {
        this.Waves.remove(wave2);
        for (waveListener waveListener2 : this.waveListeners) {
            waveListener2.waveRemoved(wave2);
        }
    }

    public void remove(LinkedList<wave> linkedList) {
        for (wave wave2 : linkedList) {
            this.remove(wave2);
        }
    }

    public LinkedList<wave> getListOfPassedWaves(LinkedList<InfoBot> linkedList, long l) {
        LinkedList<wave> linkedList2 = new LinkedList<wave>();
        ListIterator listIterator = this.Waves.listIterator();
        while (listIterator.hasNext()) {
            wave wave2 = (wave)listIterator.next();
            boolean bl = false;
            for (InfoBot infoBot : linkedList) {
                if (wave2.isBehindBot(infoBot, l)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            linkedList2.add(wave2);
        }
        return linkedList2;
    }

    public void addWaveListener(waveListener waveListener2) {
        this.waveListeners.add(waveListener2);
    }

    public wave getWaveMatching(HitByBulletEvent hitByBulletEvent) {
        wave wave2 = null;
        Bullet bullet = hitByBulletEvent.getBullet();
        Point2D.Double double_ = new Point2D.Double(bullet.getX(), bullet.getY());
        String string = hitByBulletEvent.getName();
        String string2 = this.myBot.getName();
        InfoBot infoBot = this.myBot.getGameInfo().getFighterBot(string2).getInfoBot();
        long l = this.myBot.getTime();
        double d = 1000000.0;
        for (wave wave3 : this.Waves) {
            double d2;
            double d3;
            if (!string.equals(wave3.firedBot.getName()) || !((d3 = Math.abs((d2 = wave3.getDistanceTraveledAtTime(l)) - double_.distance(wave3.getFiredPosition()))) <= physics.robotHalfDiagonal) || !(d3 < d)) continue;
            wave2 = wave3;
            d = d3;
        }
        return wave2;
    }

    public void onPaint(Graphics2D graphics2D) {
        long l = this.myBot.getTime();
        for (wave wave2 : this.Waves) {
            wave2.onPaint(graphics2D, l);
        }
    }
}

