/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.AimingInfo;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;

class TronAimingSquareInfo
extends AimingInfo {
    protected double[] bins;
    protected int negBinsCount;
    protected int max;
    protected int min;

    public TronAimingSquareInfo(double[] dArray, double[] dArray2) {
        int n;
        double d = (double)dArray2.length / (double)dArray.length;
        dArray[0] = dArray[0] + dArray2[dArray2.length - 1] * d;
        this.bins = new double[dArray.length + dArray2.length - 1];
        for (n = 0; n < dArray2.length; ++n) {
            this.bins[n] = dArray2[n] * d;
        }
        for (n = 1; n < dArray.length; ++n) {
            this.bins[n + dArray2.length - 1] = dArray[n];
        }
        int n2 = dArray2.length - 1;
        this.bins[n2] = this.bins[n2] + dArray[0];
        this.negBinsCount = dArray2.length;
        this.findMinMax();
    }

    protected void findMinMax() {
        this.max = this.negBinsCount - 1;
        this.min = 0;
        for (int i = 0; i < this.bins.length; ++i) {
            if (this.bins[i] > this.bins[this.max]) {
                this.max = i;
            }
            if (!(this.bins[i] < this.bins[this.min])) continue;
            this.min = i;
        }
    }

    public int getMaxIndex() {
        return this.max;
    }

    public int getMinIndex() {
        return this.min;
    }

    public int getNegBinsCount() {
        return this.negBinsCount;
    }

    public double[] getBins() {
        return this.bins;
    }

    public void paintBins(int n, BulletTracking bulletTracking, Color color, int n2) {
        for (int i = 0; i < this.bins.length; ++i) {
            Log.paintArc(n, bulletTracking.getSource(), bulletTracking.getMiddleAngle() - ((double)(this.negBinsCount - i) - 0.5) * bulletTracking.getAngleAdvance(), bulletTracking.getAngleAdvance(), 1000.0, new Color(color.getRed(), color.getGreen(), color.getBlue(), 20 + (int)(100.0 * (this.bins[i] - this.bins[this.min]) / (this.bins[this.max] - this.bins[this.min]))), n2);
        }
    }

    public void logBins(int n) {
        for (int i = 0; i < this.bins.length; ++i) {
            Log.log(n, "bins[" + i + " = " + this.bins[i]);
        }
    }

    public double possibleHit(BulletTracking bulletTracking) {
        this.paintBins(3, bulletTracking, Color.GREEN, 3);
        Log.paintLine(3, bulletTracking.getSource(), bulletTracking.getFiringAngle(), new Color(0, 255, 0, 125), 3);
        int n = (int)(AngleUtils.difference(bulletTracking.getFiringAngle(), bulletTracking.getMiddleAngle()) / bulletTracking.getAngleAdvance() - 0.5) + this.negBinsCount - 1;
        if (this.bins[this.max] == this.bins[this.min]) {
            return 1.0;
        }
        return (this.bins[n] - this.bins[this.min]) / (this.bins[this.max] - this.bins[this.min]);
    }
}

