/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;
import muf.utils.GameData;
import muf.utils.RollingAverage;
import muf.utils.Rutils;
import muf.utils.Targeting;

public class AveragedCircularTargeting
extends Targeting {
    protected double xSize;
    protected double ySize;
    protected GameData prevGameData;
    protected boolean velocityWasPositive;
    protected boolean velocityWasNegative;
    protected long lastDirectionChanged;
    protected RollingAverage avgTurnRate;
    protected RollingAverage avgVelocity;
    protected RollingAverage avgDirChange;

    public AveragedCircularTargeting(GameData gameData, double d, double d2, int n) {
        this.gameData = gameData;
        this.xSize = d;
        this.ySize = d2;
        this.name = new String("AveragedCircularTargeting");
        this.prevGameData = null;
        this.velocityWasPositive = false;
        this.velocityWasNegative = false;
        this.lastDirectionChanged = 0L;
        this.avgTurnRate = new RollingAverage(n * 30);
        this.avgVelocity = new RollingAverage(n * 30);
        this.avgDirChange = new RollingAverage(n);
    }

    public void notifyEnemyScanned() {
        boolean bl;
        boolean bl2 = this.gameData.enemyVelocity > 0.0;
        boolean bl3 = this.gameData.enemyVelocity < 0.0;
        boolean bl4 = bl = bl2 && this.velocityWasNegative || bl3 && this.velocityWasPositive;
        if (this.prevGameData != null) {
            double d = (this.gameData.enemyHeading - this.prevGameData.enemyHeading) / (double)(this.gameData.time - this.prevGameData.time);
            if (bl3) {
                d *= -1.0;
            }
            this.avgTurnRate.add(d);
        }
        this.avgVelocity.add(Math.abs(this.gameData.enemyVelocity));
        if (bl) {
            this.avgDirChange.add(this.gameData.time - this.lastDirectionChanged);
            this.lastDirectionChanged = this.gameData.time;
        }
        if (bl2) {
            this.velocityWasPositive = true;
            this.velocityWasNegative = false;
        }
        if (bl3) {
            this.velocityWasNegative = true;
            this.velocityWasPositive = false;
        }
        this.velocityWasPositive = bl2;
        this.velocityWasNegative = bl3;
    }

    public double getAbsAngle(double d) {
        double d2 = this.avgTurnRate.getValue();
        double d3 = this.avgVelocity.getValue();
        int n = (int)this.avgDirChange.getValue();
        int n2 = (int)Math.max(0L, (long)n - (this.gameData.time - this.lastDirectionChanged));
        if (this.velocityWasNegative || this.gameData.enemyVelocity < 0.0) {
            d3 *= -1.0;
        }
        double d4 = Rutils.bulletVelocity(d);
        int n3 = 0;
        double d5 = this.gameData.enemyX;
        double d6 = this.gameData.enemyY;
        while ((double)n3++ * d4 < Point2D.Double.distance(this.gameData.myX, this.gameData.myY, d5, d6)) {
            if (n2 == 0) {
                d3 *= -1.0;
                n2 = n;
            }
            d5 += Rutils.sin(this.gameData.enemyHeading + (double)n3 * d2) * d3;
            d6 += Rutils.cos(this.gameData.enemyHeading + (double)n3 * d2) * d3;
            d5 = Math.min(Math.max(18.0, d5), this.xSize - 18.0);
            d6 = Math.min(Math.max(18.0, d6), this.ySize - 18.0);
            --n2;
        }
        return Rutils.atan2(d5 - this.gameData.myX, d6 - this.gameData.myY);
    }
}

