/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;
import muf.utils.GameData;
import muf.utils.RollingAverage;
import muf.utils.Targeting;
import muf.utils.VirtualBullet;

public class TargetingEvaluator {
    protected GameData gameData;
    protected Targeting targeting;
    protected RollingAverage successRate;
    protected Vector virtualBullets;
    protected double angle;

    public TargetingEvaluator(Targeting targeting, GameData gameData) {
        this(targeting, gameData, 0);
    }

    public TargetingEvaluator(Targeting targeting, GameData gameData, int n) {
        this.targeting = targeting;
        this.gameData = gameData;
        this.successRate = new RollingAverage(n);
        this.virtualBullets = new Vector();
    }

    public void virtualAim(double d) {
        this.angle = this.targeting.getAbsAngle(d);
    }

    public void virtualFire(double d) {
        this.targeting.notifyFire(d);
        VirtualBullet virtualBullet = new VirtualBullet(0, this.gameData.time, this.gameData.myX, this.gameData.myY, d, this.angle);
        this.virtualBullets.add(virtualBullet);
    }

    public void evaluateBullets() {
        Iterator iterator = this.virtualBullets.iterator();
        while (iterator.hasNext()) {
            VirtualBullet virtualBullet = (VirtualBullet)iterator.next();
            Point2D point2D = virtualBullet.position(this.gameData.time);
            if (virtualBullet.hit(this.gameData.time, this.gameData.enemyX, this.gameData.enemyY)) {
                this.successRate.add(100.0);
                iterator.remove();
                continue;
            }
            if (!virtualBullet.missed(this.gameData.time, this.gameData.enemyX, this.gameData.enemyY)) continue;
            this.successRate.add(0.0);
            iterator.remove();
        }
    }

    public void notifyEnemyScanned() {
        this.targeting.notifyEnemyScanned();
    }

    public double getSuccessRate() {
        return this.successRate.getValue();
    }

    public Targeting getTargeting() {
        return this.targeting;
    }
}

