/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mue.DirectGun;
import mue.Gun;
import mue.GunArrayBase;
import mue.RobotData;
import mue.ScanWave;
import mue.StatisticWave;
import mue.Util;
import mue.VirtualHitStatistic;
import robocode.AdvancedRobot;
import robocode.Bullet;

class GunArray
extends GunArrayBase {
    protected static final int[] DISTANCE_BUCKETS = new int[]{120};
    protected static final double[] BULLETPOWER_PROFILE = new double[]{2.999, 1.92};
    protected static final float CHANGE_DIFF = 0.06f;
    protected static final int EVALUATION_SHOTS = 300;
    protected static final int EVALUATION_SHOT_STEP = 50;
    private static Map targetData = null;
    protected static int oldTargetData = 0;
    protected static int noFireTicks = 0;
    protected DirectGun directGun;
    protected Gun currentGun;
    protected StatisticWave statisticWave;
    protected ScanWave scanWave;
    protected Double firePower;
    protected int switchRatingMargin;
    protected boolean monitorVirtualHitRatio;
    protected boolean targetingChallenge;

    public GunArray(AdvancedRobot advancedRobot, boolean bl, boolean bl2) {
        super(advancedRobot, DISTANCE_BUCKETS);
        this.switchRatingMargin = Math.max(1, (int)Math.round(Math.floor(Math.log(advancedRobot.getNumRounds()))));
        this.monitorVirtualHitRatio = bl;
        this.targetingChallenge = bl2;
        if (targetData == null) {
            targetData = new HashMap(20);
        }
        this.directGun = new DirectGun(advancedRobot);
        this.currentGun = null;
        this.statisticWave = null;
        this.scanWave = null;
        this.firePower = null;
        this.addGun(this.directGun);
    }

    private final TargetData getTargetData(String string) {
        TargetData targetData = (TargetData)GunArray.targetData.get(string);
        if (targetData == null) {
            targetData = new TargetData(this.switchRatingMargin);
            GunArray.targetData.put(string, targetData);
        }
        return targetData;
    }

    public void doGun(RobotData robotData) {
        double d;
        if (robotData == null || !robotData.isAlive()) {
            return;
        }
        oldTargetData = (int)((long)oldTargetData + (this.getTime() - robotData.getTime()));
        if (this.firePower != null && (this.targetingChallenge || this.firePower < this.getEnergy() - 0.01)) {
            Bullet bullet = this.setFire(this.targetingChallenge ? 3.0 : this.firePower, robotData, this.currentGun, this.statisticWave);
            if (bullet != null && this.scanWave != null) {
                this.scanWave.fire(true);
                this.scanWave = null;
            }
            this.firePower = null;
        }
        this.statisticWave = null;
        if (this.scanWave != null) {
            this.scanWave.fire(false);
            this.scanWave = null;
        }
        if (this.firePower != null) {
            if (this.targetingChallenge || this.firePower < this.getEnergy() - 0.01) {
                ++noFireTicks;
            }
            this.firePower = null;
        }
        if (this.targetingChallenge) {
            d = Math.min(this.getEnergy(), 3.0);
        } else {
            double d2;
            int n = Util.findSegmentationIndex(DISTANCE_BUCKETS, (int)Math.round(robotData.getDistance()));
            d = BULLETPOWER_PROFILE[n];
            if (d > (d2 = this.getPowerForDamage(robotData.getEnergy())) + 0.01) {
                d = Math.max(d2 + 0.01, 0.1);
            }
            if (this.getEnergy() - d < 0.43 && n > 0) {
                d = Math.max(this.getEnergy() - 0.43, 0.2);
            }
            if (d > this.getEnergy() - 0.02) {
                d = Math.max(this.getEnergy() - 0.02, 0.1);
            }
        }
        this.currentGun = this.selectBestGun(robotData, this.currentGun);
        double d3 = this.currentGun == null ? this.directGun.getFireAngle(robotData, d) : this.currentGun.getFireAngle(robotData, d);
        d3 = this.setTurnGun(d3);
        if (robotData.getEnergy() > 1.0E-4) {
            this.scanWave = this.prepareScanWave(robotData, d);
        }
        if (this.getCoolingTime() <= 1 && d3 < 0.9 * Math.toDegrees(Math.atan(18.0 / robotData.getDistance())) && (this.targetingChallenge || d < this.getEnergy() - 0.01)) {
            this.firePower = new Double(d);
            if (!this.getTargetData(robotData.getName()).isDecided() || this.monitorVirtualHitRatio) {
                this.statisticWave = this.prepareStatisticWave(robotData, d);
            }
        } else if (this.getCoolingTime() <= 1 && (this.targetingChallenge || d < this.getEnergy() - 0.01)) {
            ++noFireTicks;
        }
    }

    protected Gun selectBestGun(RobotData robotData, Gun gun) {
        if (this.getCoolingTime() > 4) {
            return null;
        }
        if (robotData.getEnergy() < 1.0E-4) {
            return this.directGun;
        }
        TargetData targetData = this.getTargetData(robotData.getName());
        if (targetData.isDecided()) {
            gun = this.getGun(targetData.getPreferredGun());
            if (gun != null) {
                return gun;
            }
            Util.addWarning("GunArray.selectBestGun: preferred gun " + targetData.getPreferredGun() + " is unknown.");
        }
        if (gun != null && this.getVirtualStatistic(robotData.getName(), gun.getName()) != null) {
            return gun;
        }
        int n = (int)Math.round(robotData.getDistance());
        double d = -1.0;
        String string = targetData.getActiveGun(n);
        if (string != null) {
            if (this.getGun(string) == null) {
                Util.addWarning("GunArray.selectBestGun: active gun " + string + " is unknown.");
                string = null;
            } else {
                d = this.getVirtualStatistic(robotData.getName(), string).rollingHitRatio(n) + 0.06f;
            }
        }
        Iterator iterator = this.getGunNames().iterator();
        while (iterator.hasNext()) {
            double d2;
            String string2 = (String)iterator.next();
            VirtualHitStatistic virtualHitStatistic = this.getVirtualStatistic(robotData.getName(), string2);
            if (virtualHitStatistic == null || !((d2 = (double)virtualHitStatistic.rollingHitRatio(n)) > d)) continue;
            string = string2;
            d = d2;
        }
        if (string == null) {
            Util.addWarning("GunArray.selectBestGun: failed to select a gun.");
        }
        targetData.setActiveGun(n, string);
        return this.getGun(string);
    }

    public void addHit(String string, Gun gun, int n, double d) {
        super.addHit(string, gun, n, d);
        TargetData targetData = this.getTargetData(string);
        if (!targetData.isDecided()) {
            Iterator iterator = this.getGunNames().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                VirtualHitStatistic virtualHitStatistic = this.getVirtualStatistic(string, string2);
                if (virtualHitStatistic == null || virtualHitStatistic.shots() >= targetData.getMinimumShots()) continue;
                bl = false;
                break;
            }
            if (bl) {
                targetData.incMinimumShots();
                this.checkGuns(string);
            }
        }
    }

    protected void checkGuns(String string) {
        String string2 = null;
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.getGunNames().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            VirtualHitStatistic virtualHitStatistic = this.getVirtualStatistic(string, string3);
            if (virtualHitStatistic == null) continue;
            double d3 = virtualHitStatistic.hitRatio();
            if (d3 > d) {
                d2 = d;
                d = d3;
                string2 = string3;
                continue;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        if (d > d2 + 0.01) {
            this.getTargetData(string).incRating(string2, this.getRound());
        }
    }

    public String evaluate() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("old target data: ").append(oldTargetData).append("\n");
        float f = 0.0f;
        int n = this.getTotalNumberOfShots();
        if (n > 0) {
            f = (float)noFireTicks / (float)n;
        }
        stringBuffer.append("no fire ticks ").append(noFireTicks).append(" (").append(f).append(" per shot)");
        stringBuffer.append("\n\n").append(super.evaluate());
        return stringBuffer.toString();
    }

    public String evaluate(String string) {
        return this.getTargetData(string).evaluate() + super.evaluate(string);
    }

    private static final class TargetData {
        private String[] activeGuns = new String[DISTANCE_BUCKETS.length + 1];
        private Map gunRatings = new HashMap(10);
        private String preferredGun = null;
        private int minimumBullets = 300;
        private int ratingMargin = 0;
        private int switchRound = 0;
        private int switchRatingMargin;

        public TargetData(int n) {
            this.switchRatingMargin = n;
        }

        public boolean isDecided() {
            return this.switchRound > 0;
        }

        public String getPreferredGun() {
            return this.switchRound == 0 ? null : this.preferredGun;
        }

        public String getActiveGun(int n) {
            return this.activeGuns[Util.findSegmentationIndex(DISTANCE_BUCKETS, n)];
        }

        public void setActiveGun(int n, String string) {
            this.activeGuns[Util.findSegmentationIndex((int[])GunArray.DISTANCE_BUCKETS, (int)n)] = string;
        }

        public int getMinimumShots() {
            return this.minimumBullets;
        }

        public void incMinimumShots() {
            this.minimumBullets += 50;
        }

        public void incRating(String string, int n) {
            GunRating gunRating = (GunRating)this.gunRatings.get(string);
            if (gunRating == null) {
                gunRating = new GunRating();
                this.gunRatings.put(string, gunRating);
            }
            gunRating.incRating();
            if (this.preferredGun == null) {
                this.preferredGun = string;
                this.ratingMargin = gunRating.getRating();
            } else if (string.equals(this.preferredGun)) {
                ++this.ratingMargin;
            } else {
                GunRating gunRating2 = (GunRating)this.gunRatings.get(this.preferredGun);
                if (gunRating.getRating() > gunRating2.getRating()) {
                    this.preferredGun = string;
                    this.ratingMargin = gunRating.getRating() - gunRating2.getRating();
                } else {
                    this.ratingMargin = Math.min(this.ratingMargin, gunRating2.getRating() - gunRating.getRating());
                }
            }
            if (this.ratingMargin >= this.switchRatingMargin) {
                this.switchRound = n + 1;
            }
        }

        public String evaluate() {
            if (this.switchRound == 0) {
                return "no final gun decision\n";
            }
            return "switched to " + this.preferredGun + " in round " + this.switchRound + "\n";
        }
    }

    protected static final class GunRating {
        private int rating = 0;

        public void incRating() {
            ++this.rating;
        }

        public int getRating() {
            return this.rating;
        }
    }
}

