/*
 * Decompiled with CFR 0.152.
 */
package inonit.script.rhino;

import inonit.script.engine.Code;
import inonit.script.engine.Loader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.xml.XMLLib;

public class Engine {
    private Debugger debugger;
    private Configuration contexts;

    public static Engine create(Debugger debugger, Configuration contexts) {
        Engine rv = new Engine();
        if (debugger == null) {
            debugger = new NoDebugger();
        }
        rv.debugger = debugger;
        rv.contexts = contexts;
        debugger.initialize(contexts);
        return rv;
    }

    private Engine() {
    }

    private Scriptable getGlobalScope(Context context) {
        return context.initStandardObjects();
    }

    void script(String name, InputStream code, Scriptable scope, Scriptable target) throws IOException {
        Source source = Source.create(name, new InputStreamReader(code));
        source.evaluate(this.debugger, this.contexts, scope, target);
    }

    void script(String name, Reader code, Scriptable scope, Scriptable target) throws IOException {
        Source source = Source.create(name, code);
        source.evaluate(this.debugger, this.contexts, scope, target);
    }

    public Scriptable script(String name, String code, Scriptable scope, Scriptable target) throws IOException {
        Source source = Source.create(name, code);
        Object rv = source.evaluate(this.debugger, this.contexts, scope, target);
        if (rv instanceof Scriptable) {
            return (Scriptable)rv;
        }
        return null;
    }

    public boolean canAccessEnvironment() {
        return this.contexts.canAccessEnvironment();
    }

    public Scriptable createHostObject(Object javaHostObject) {
        ContextFactory.GlobalSetter global = ContextFactory.getGlobalSetter();
        ContextFactory before = global.getContextFactoryGlobal();
        global.setContextFactoryGlobal(this.contexts.factory);
        Context owned = this.contexts.factory.enterContext();
        Scriptable scope = this.getGlobalScope(owned);
        Scriptable rv = (Scriptable)Context.javaToJS(javaHostObject, scope);
        global.setContextFactoryGlobal(before);
        return rv;
    }

    public Object execute(Program program) {
        Program.Outcome outcome = (Program.Outcome)this.contexts.call(new ProgramAction(this, program, this.debugger));
        return outcome.getResult();
    }

    public Object evaluate(Program program, String name, Class<?> type) {
        Program.Outcome outcome = (Program.Outcome)this.contexts.call(new ProgramAction(this, program, this.debugger));
        return outcome.castScopeTo(name, type);
    }

    public Object evaluate(Program program, Class<?> type) {
        Program.Outcome outcome = (Program.Outcome)this.contexts.call(new ProgramAction(this, program, this.debugger));
        return outcome.castScopeTo(null, type);
    }

    public Scriptable load(Program program) {
        Program.Outcome outcome = (Program.Outcome)this.contexts.call(new ProgramAction(this, program, this.debugger));
        return outcome.getGlobal();
    }

    public void include(Scriptable jsThis, Source source) throws IOException {
        source.evaluate(this.debugger, this.contexts, null, jsThis);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public Loader.Classes.Interface getClasspath() {
        return this.contexts.getClasspath();
    }

    private static class ProgramAction
    implements ContextAction {
        private Engine engine;
        private Program program;
        private Debugger debugger;

        ProgramAction(Engine engine, Program program, Debugger debugger) {
            this.engine = engine;
            this.program = program;
            this.debugger = debugger;
        }

        @Override
        public Object run(Context context) {
            try {
                Scriptable global = this.engine.getGlobalScope(context);
                this.program.setVariablesInGlobalScope(context, global);
                this.debugger.initialize(global, this.engine, this.program);
                Program.Outcome outcome = this.program.interpret(this.debugger, context, global);
                return outcome;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Program {
        private ArrayList<Variable> variables = new ArrayList();
        private ArrayList<Unit> units = new ArrayList();

        public void set(Variable variable) {
            this.variables.add(variable);
        }

        public void add(Source source) {
            this.units.add(new SourceUnit(ObjectName.NULL, source));
        }

        public void add(Function function, Object[] arguments) {
            this.units.add(new FunctionUnit(function, arguments));
        }

        public void add(Unit unit) {
            this.units.add(unit);
        }

        void setVariablesInGlobalScope(Context context, Scriptable global) {
            for (int i = 0; i < this.variables.size(); ++i) {
                Variable v = this.variables.get(i);
                Object value = v.value.get(context, global);
                if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    Object[] objects = new Object[array.length];
                    for (int j = 0; j < objects.length; ++j) {
                        objects[j] = array[j];
                    }
                    value = context.newArray(global, objects);
                }
                v.set(context, global);
            }
        }

        private Outcome execute(Debugger dim, Context context, Scriptable global) throws IOException {
            if (context == null) {
                throw new RuntimeException("'context' is null");
            }
            Object ignore = null;
            for (int i = 0; i < this.units.size(); ++i) {
                Errors errors = Errors.get(context);
                if (errors != null) {
                    errors.reset();
                }
                try {
                    ignore = this.units.get(i).execute(dim, context, global);
                    continue;
                }
                catch (WrappedException e) {
                    if (errors != null) {
                        errors.add(e);
                        throw errors;
                    }
                    throw e;
                }
                catch (EvaluatorException e) {
                    if (errors != null && (e.getMessage().indexOf("Compilation produced") == -1 || e.getMessage().indexOf("syntax errors.") == -1)) {
                        errors.add(e);
                    }
                    if (errors != null) {
                        throw errors;
                    }
                    throw e;
                }
                catch (EcmaError e) {
                    if (errors != null) {
                        errors.add(e);
                        throw errors;
                    }
                    throw e;
                }
                catch (JavaScriptException e) {
                    if (errors != null) {
                        errors.add(e);
                        throw errors;
                    }
                    throw e;
                }
            }
            return new Outcome(global, ignore);
        }

        Outcome interpret(Debugger dim, Context context, Scriptable global) throws IOException {
            if (context == null) {
                throw new RuntimeException("'context' is null");
            }
            return this.execute(dim, context, global);
        }

        private static class FunctionUnit
        extends Unit {
            private Function function;
            private Object[] arguments;

            FunctionUnit(Function function, Object[] arguments) {
                this.function = function;
                this.arguments = arguments;
            }

            @Override
            protected Object execute(Debugger dim, Context context, Scriptable global) {
                return this.function.call(context, global, global, this.arguments);
            }
        }

        private static class SourceUnit
        extends Unit {
            private ObjectName scope;
            private Source source;

            SourceUnit(ObjectName scope, Source source) {
                this.scope = scope;
                this.source = source;
            }

            @Override
            protected Object execute(Debugger dim, Context context, Scriptable global) throws IOException {
                Scriptable executionScope = this.scope.get(context, global, true);
                return this.source.evaluate(dim, context, executionScope, executionScope, true);
            }
        }

        public static abstract class Unit {
            protected abstract Object execute(Debugger var1, Context var2, Scriptable var3) throws IOException;
        }

        public static class Variable {
            private ObjectName scope;
            private String name;
            private Value value;
            private Attributes attributes;

            public static Variable create(String name, Value value) {
                return new Variable(ObjectName.NULL, name, value, new Attributes());
            }

            Variable(ObjectName scope, String name, Value value, Attributes attributes) {
                this.scope = scope;
                this.name = name;
                this.value = value;
                this.attributes = attributes;
            }

            String getName() {
                return this.name;
            }

            Object getValue(Context context, Scriptable scope) {
                return this.value.get(context, scope);
            }

            int getRhinoAttributes() {
                return this.attributes.toRhinoAttributes();
            }

            void set(Context context, Scriptable global) {
                this.scope.set(context, global, this);
            }

            public void setPermanent(boolean permanent) {
                this.attributes.permanent = permanent;
            }

            public void setReadonly(boolean readonly) {
                this.attributes.readonly = readonly;
            }

            public void setDontenum(boolean dontenum) {
                this.attributes.dontenum = dontenum;
            }

            public static class Attributes {
                private boolean permanent;
                private boolean readonly;
                private boolean dontenum;

                public static Attributes create() {
                    return new Attributes();
                }

                private Attributes() {
                }

                int toRhinoAttributes() {
                    int rv = 0;
                    if (this.permanent) {
                        rv |= 4;
                    }
                    if (this.readonly) {
                        rv |= 1;
                    }
                    if (this.dontenum) {
                        rv |= 2;
                    }
                    return rv;
                }
            }

            public static abstract class Value {
                public static Value create(final Object o) {
                    return new Value(){

                        @Override
                        public Object get(Context context, Scriptable scope) {
                            return Context.javaToJS(o, scope);
                        }
                    };
                }

                public abstract Object get(Context var1, Scriptable var2);
            }
        }

        static class Outcome {
            private Scriptable global;
            private Object result;

            Outcome(Scriptable global, Object result) {
                this.global = global;
                this.result = result;
            }

            Scriptable getGlobal() {
                return this.global;
            }

            Object getResult() {
                return this.result;
            }

            Object castScopeTo(String name, Class<?> type) {
                if (name == null) {
                    return Context.jsToJava(this.global, type);
                }
                return Context.jsToJava(ScriptableObject.getProperty(this.global, name), type);
            }
        }

        private static class ObjectName {
            static final ObjectName NULL = new ObjectName();

            private ObjectName() {
            }

            void set(Context context, Scriptable global, Variable variable) {
                ScriptableObject.defineProperty(global, variable.getName(), variable.getValue(context, global), variable.getRhinoAttributes());
            }

            Scriptable get(Context context, Scriptable global, boolean create) {
                return global;
            }
        }
    }

    public static abstract class Source {
        private boolean debug = true;
        private ArrayList<Integer> breakpoints = new ArrayList();

        public static Source create(String sourceName, Reader reader) {
            if (reader == null) {
                throw new RuntimeException("'reader' must not be null.");
            }
            return new ReaderSource(sourceName, reader);
        }

        public static Source create(String name, InputStream in) {
            return Source.create(name, new InputStreamReader(in));
        }

        public static Source create(String sourceName, String s) {
            return new ReaderSource(sourceName, new StringReader(s));
        }

        public static Source create(File file) {
            try {
                return new ReaderSource(file.getCanonicalPath(), new FileReader(file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find file: [" + file.getPath() + "]", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot get canonical path of " + file);
            }
        }

        public static Source create(Code.Loader.Resource file) {
            return new ReaderSource(file.getSourceName(), file.getReader());
        }

        final boolean debug() {
            return this.debug;
        }

        abstract String getSourceName();

        abstract Object evaluate(Debugger var1, Context var2, Scriptable var3, Scriptable var4, boolean var5) throws IOException;

        public abstract Reader getReader();

        public final void setDebug(boolean debug) {
            this.debug = debug;
        }

        final void addBreakpoint(int line) {
            this.breakpoints.add(new Integer(line));
        }

        final void setBreakpoints(Debugger dim) {
            if (dim != null) {
                for (int j = 0; j < this.breakpoints.size(); ++j) {
                    int line = this.breakpoints.get(j);
                    try {
                        dim.setBreakpoint(this, line);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        dim.log("Cannot set breakpoint at line " + line + " of " + this.getSourceName());
                    }
                }
            }
        }

        final Object evaluate(Debugger dim, Configuration configuration, Scriptable scope, Scriptable target) throws IOException {
            Context context = configuration.getContext();
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            boolean COMPILE_SCRIPTS = false;
            Errors errors = Errors.get(context);
            try {
                if (errors != null) {
                    errors.reset();
                }
                boolean USE_COMPILE = true;
                return this.evaluate(dim, context, scope, target, true);
            }
            catch (EvaluatorException e) {
                if (errors != null && errors.errors.size() > 0) {
                    throw errors;
                }
                throw e;
            }
        }

        private static class ReaderSource
        extends Source {
            private String id;
            private Reader reader;

            ReaderSource(String id, Reader reader) {
                this.id = id;
                this.reader = reader;
            }

            @Override
            public Reader getReader() {
                return this.reader;
            }

            @Override
            final String getSourceName() {
                return this.id;
            }

            private String parse(BufferedReader lines) throws IOException {
                String line;
                StringBuffer b = new StringBuffer();
                int number = 0;
                while ((line = lines.readLine()) != null) {
                    String toParser;
                    ++number;
                    if (line.length() > 0 && line.charAt(0) == '^') {
                        if (this.debug()) {
                            this.addBreakpoint(number);
                        }
                        toParser = line.substring(1);
                    } else if (line.length() > 0 && line.charAt(0) == '#') {
                        toParser = "//" + line;
                    } else if (line.length() > 0 && line.trim().equals("debugger;") && this.debug()) {
                        this.addBreakpoint(number);
                        toParser = line.replace("debugger;", "/* BREAKPOINT */ new Object();");
                    } else {
                        toParser = line;
                    }
                    b.append(toParser + "\n");
                }
                String code = b.toString();
                return code;
            }

            @Override
            final Object evaluate(Debugger dim, Context context, Scriptable scope, Scriptable target, boolean compile) throws IOException {
                BufferedReader lines = new BufferedReader(this.reader);
                String code = this.parse(lines);
                try {
                    if (target != scope && target != null) {
                        scope = new TargetingScope(scope, target);
                        code = "(function(){ " + code + "\n}).call(" + "__target__" + ");";
                    }
                    Script script = null;
                    if (compile) {
                        script = context.compileString(code, this.id, 1, null);
                    }
                    this.setBreakpoints(dim);
                    if (compile) {
                        Object object = script.exec(context, scope);
                        return object;
                    }
                    Object object = context.evaluateString(scope, code, this.id, 1, null);
                    return object;
                }
                catch (EvaluatorException e) {
                    throw e;
                }
                finally {
                    try {
                        lines.close();
                    }
                    catch (IOException e) {
                        System.err.println("Error closing: " + this.reader);
                        e.printStackTrace();
                    }
                }
            }

            private static class TargetingScope
            implements Scriptable {
                private static final String THIS_IDENTIFIER = "__target__";
                private Scriptable scope;
                private Scriptable target;

                TargetingScope(Scriptable scope, Scriptable target) {
                    this.scope = scope;
                    this.target = target;
                }

                @Override
                public String getClassName() {
                    return this.scope.getClassName();
                }

                @Override
                public Object get(String string, Scriptable s) {
                    if (string.equals(THIS_IDENTIFIER)) {
                        return this.target;
                    }
                    return this.scope.get(string, s);
                }

                @Override
                public Object get(int i, Scriptable s) {
                    return this.scope.get(i, s);
                }

                @Override
                public boolean has(String string, Scriptable s) {
                    if (string.equals(THIS_IDENTIFIER)) {
                        return true;
                    }
                    return this.scope.has(string, s);
                }

                @Override
                public boolean has(int i, Scriptable s) {
                    return this.scope.has(i, s);
                }

                @Override
                public void put(String string, Scriptable s, Object o) {
                    this.scope.put(string, s, o);
                }

                @Override
                public void put(int i, Scriptable s, Object o) {
                    this.scope.put(i, s, o);
                }

                @Override
                public void delete(String string) {
                    this.scope.delete(string);
                }

                @Override
                public void delete(int i) {
                    this.scope.delete(i);
                }

                @Override
                public Scriptable getPrototype() {
                    return this.scope.getPrototype();
                }

                @Override
                public void setPrototype(Scriptable s) {
                    this.scope.setPrototype(s);
                }

                @Override
                public Scriptable getParentScope() {
                    return this.scope.getParentScope();
                }

                @Override
                public void setParentScope(Scriptable s) {
                    this.scope.setParentScope(s);
                }

                @Override
                public Object[] getIds() {
                    return this.scope.getIds();
                }

                @Override
                public Object getDefaultValue(Class<?> type) {
                    return this.scope.getDefaultValue(type);
                }

                @Override
                public boolean hasInstance(Scriptable s) {
                    return this.scope.hasInstance(s);
                }
            }
        }
    }

    public static class Errors
    extends RuntimeException {
        private ArrayList<ScriptError> errors = new ArrayList();
        private ErrorReporterImpl reporter = new ErrorReporterImpl();

        public static Errors get(Context context) {
            if (context == null) {
                throw new RuntimeException("'context' must not be null.");
            }
            if (context.getErrorReporter() instanceof ErrorReporterImpl) {
                return ((ErrorReporterImpl)context.getErrorReporter()).getErrors();
            }
            return null;
        }

        ErrorReporterImpl getErrorReporter() {
            return this.reporter;
        }

        private void emitErrorMessage(Log err, String prefix, ScriptError e) {
            err.println(prefix + e.getSourceName() + ":" + e.getLineNumber() + ": " + e.getMessage());
            String errCaret = "";
            if (e.getLineSource() != null) {
                for (int i = 0; i < e.getLineSource().length(); ++i) {
                    char c = e.getLineSource().charAt(i);
                    if (i < e.getColumn() - 1) {
                        if (c == '\t') {
                            errCaret = errCaret + "\t";
                            continue;
                        }
                        errCaret = errCaret + " ";
                        continue;
                    }
                    if (i != e.getColumn() - 1) continue;
                    errCaret = errCaret + "^";
                }
                err.println(prefix + e.getLineSource());
                err.println(prefix + errCaret);
            }
            if (e.getStackTrace() != null) {
                err.println(e.getStackTrace());
            }
            err.println();
        }

        public void dump(Log err, String prefix) {
            err.println();
            err.println(prefix + "Script halted because of " + this.errors.size() + " errors.");
            err.println();
            for (int i = 0; i < this.errors.size(); ++i) {
                this.emitErrorMessage(err, prefix, this.errors.get(i));
            }
        }

        public void reset() {
            this.errors = new ArrayList();
        }

        public ScriptError[] getErrors() {
            return this.errors.toArray(new ScriptError[0]);
        }

        private void addRhino(RhinoException e) {
            this.errors.add(new ScriptError(ScriptError.Type.RUNTIME, e.getMessage(), e.sourceName(), e.lineNumber(), e.lineSource(), e.columnNumber(), e));
        }

        public void add(EcmaError e) {
            this.addRhino(e);
        }

        public void add(EvaluatorException e) {
            this.addRhino(e);
        }

        public void add(JavaScriptException e) {
            this.addRhino(e);
        }

        public static class ScriptError {
            private Type type;
            private String message;
            private String sourceName;
            private int line;
            private String lineSource;
            private int offset;
            private Throwable t;

            ScriptError(Type type, String message, String sourceName, int line, String lineSource, int offset, Throwable t) {
                this.type = type;
                this.message = message;
                this.sourceName = sourceName;
                this.line = line;
                this.lineSource = lineSource;
                this.offset = offset;
                this.t = t;
            }

            public String toString() {
                return this.getClass().getName() + " message=" + this.message + " sourceName=" + this.sourceName + " line=" + this.line;
            }

            public boolean is(Type type) {
                return this.type == type;
            }

            public String getSourceName() {
                return this.sourceName;
            }

            public int getLineNumber() {
                return this.line;
            }

            public String getLineSource() {
                return this.lineSource;
            }

            public int getColumn() {
                return this.offset;
            }

            public String getMessage() {
                return this.message;
            }

            public String getStackTrace() {
                if (this.t == null) {
                    return null;
                }
                StringWriter s = new StringWriter();
                PrintWriter p = new PrintWriter((Writer)s, true);
                this.t.printStackTrace(p);
                String topStack = s.toString();
                if (topStack.indexOf("Caused by:") != -1) {
                    topStack = topStack.substring(0, topStack.indexOf("Caused by:"));
                }
                s = new StringWriter();
                p = new PrintWriter((Writer)s, true);
                p.print(topStack);
                Throwable target = this.t.getCause();
                while (target != null) {
                    p.println("Caused by: " + target.getClass().getName() + ": " + target.getMessage());
                    for (int i = 0; i < target.getStackTrace().length; ++i) {
                        StackTraceElement e = target.getStackTrace()[i];
                        p.println("\tat " + e);
                    }
                    if ((target = target.getCause()) == null) continue;
                    p.print("Caused by: ");
                }
                return s.toString();
            }

            public Throwable getThrowable() {
                return this.t;
            }

            public static class Type {
                public static final Type RUNTIME = new Type();
                public static final Type ERROR = new Type();
                public static final Type WARNING = new Type();

                private Type() {
                }
            }
        }

        class ErrorReporterImpl
        implements ErrorReporter {
            ErrorReporterImpl() {
            }

            @Override
            public void warning(String string, String string0, int i, String string1, int i0) {
                Errors.this.errors.add(new ScriptError(ScriptError.Type.WARNING, string, string0, i, string1, i0, null));
            }

            @Override
            public EvaluatorException runtimeError(String string, String string0, int i, String string1, int i0) {
                if (Errors.this.errors == null) {
                    throw new RuntimeException("errors is null.");
                }
                Errors.this.errors.add(new ScriptError(ScriptError.Type.RUNTIME, string, string0, i, string1, i0, null));
                return new EvaluatorException(string, string0, i, string1, i0);
            }

            @Override
            public void error(String string, String string0, int i, String string1, int i0) {
                Errors.this.errors.add(new ScriptError(ScriptError.Type.ERROR, string, string0, i, string1, i0, null));
            }

            Errors getErrors() {
                return Errors.this;
            }
        }
    }

    public static abstract class Configuration {
        public static final Configuration DEFAULT = new Configuration(){

            @Override
            public ClassLoader getApplicationClassLoader() {
                return null;
            }

            @Override
            public File getLocalClassCache() {
                return null;
            }

            @Override
            public boolean createClassLoader() {
                return true;
            }

            @Override
            public boolean canAccessEnvironment() {
                return true;
            }

            @Override
            public int getOptimizationLevel() {
                return -1;
            }
        };
        private ContextFactoryInner factory = new ContextFactoryInner();

        public String toString() {
            return this.getClass().getName() + " factory=" + this.factory;
        }

        public abstract boolean createClassLoader();

        public abstract boolean canAccessEnvironment();

        public abstract ClassLoader getApplicationClassLoader();

        public abstract File getLocalClassCache();

        public abstract int getOptimizationLevel();

        final synchronized Context getContext() {
            return Context.getCurrentContext();
        }

        final Loader.Classes.Interface getClasspath() {
            return this.factory.getClasspath();
        }

        void attach(Dim dim) {
            dim.attachTo(this.factory);
        }

        Object call(ContextAction action) {
            return this.factory.call(action);
        }

        public String getImplementationVersion() {
            Context context = this.getContext();
            if (context == null) {
                Context.enter();
                String rv = this.getContext().getImplementationVersion();
                Context.exit();
                return rv;
            }
            return context.getImplementationVersion();
        }

        public XMLLib.Factory getRhinoE4xImplementationFactory() {
            Context context = this.getContext();
            if (context == null) {
                Context.enter();
                XMLLib.Factory rv = this.getContext().getE4xImplementationFactory();
                Context.exit();
                return rv;
            }
            return context.getE4xImplementationFactory();
        }

        private class ContextFactoryInner
        extends ContextFactory {
            private Loader.Classes classes;
            private boolean initialized = false;

            ContextFactoryInner() {
            }

            private synchronized void initializeClassLoaders() {
                if (!this.initialized) {
                    this.classes = Loader.Classes.create(new Loader.Classes.Configuration(){

                        @Override
                        public boolean canCreateClassLoaders() {
                            return Configuration.this.createClassLoader();
                        }

                        @Override
                        public ClassLoader getApplicationClassLoader() {
                            return Configuration.this.getApplicationClassLoader() == null ? ContextFactory.class.getClassLoader() : Configuration.this.getApplicationClassLoader();
                        }

                        @Override
                        public File getLocalClassCache() {
                            return Configuration.this.getLocalClassCache();
                        }
                    });
                    this.initialized = true;
                }
            }

            private synchronized ClassLoader getContextApplicationClassLoader() {
                this.initializeClassLoaders();
                return this.classes.getApplicationClassLoader();
            }

            final Loader.Classes.Interface getClasspath() {
                this.initializeClassLoaders();
                return this.classes.getInterface();
            }

            @Override
            protected synchronized Context makeContext() {
                Context rv = super.makeContext();
                rv.setApplicationClassLoader(this.getContextApplicationClassLoader());
                rv.setErrorReporter(new Errors().getErrorReporter());
                rv.setOptimizationLevel(Configuration.this.getOptimizationLevel());
                return rv;
            }

            @Override
            protected boolean hasFeature(Context context, int feature) {
                if (feature == 8) {
                    return true;
                }
                if (feature == 9) {
                    return true;
                }
                return super.hasFeature(context, feature);
            }
        }
    }

    public static class RhinoDebugger
    extends Debugger {
        private Configuration configuration;
        private boolean breakOnExceptions = false;
        private Dim dim;
        private Ui gui;

        public static RhinoDebugger create(Configuration configuration) {
            RhinoDebugger rv = new RhinoDebugger();
            rv.configuration = configuration;
            return rv;
        }

        private RhinoDebugger() {
        }

        private Dim.SourceInfo getSourceInfo(String id) {
            return this.dim.sourceInfo(id);
        }

        @Override
        void initialize(inonit.script.rhino.Engine$Configuration contexts) {
            this.dim = new Dim();
            contexts.attach(this.dim);
            String title = "Script Debugger";
            if (this.configuration.startWithBreak) {
                this.dim.setBreak();
            }
            this.breakOnExceptions = this.configuration.breakOnExceptions;
            if (this.configuration.breakOnExceptions) {
                this.dim.setBreakOnExceptions(true);
                this.breakOnExceptions = true;
            }
            this.gui = this.configuration.getUiFactory().create(this.dim, title);
            this.gui.setExitAction(new ExitAction(this.dim, this.configuration.exit));
            contexts.attach(this.dim);
        }

        @Override
        void setBreakpoint(Source source, int line) {
            Dim.SourceInfo info = this.getSourceInfo(source.getSourceName());
            if (info != null) {
                info.breakpoint(line, true);
            } else {
                this.configuration.log.println("Not setting breakpoint at " + line + " in " + source + ": no source info");
            }
        }

        @Override
        void initialize(Scriptable scope, Engine engine, Program program) {
            this.dim.setScopeProvider(new ScopeWrapper(scope));
            this.gui.pack();
            this.gui.setVisible(true);
        }

        @Override
        Log getLog() {
            return this.configuration.log;
        }

        @Override
        public boolean isBreakOnExceptions() {
            return this.breakOnExceptions;
        }

        @Override
        public void setBreakOnExceptions(boolean breakOnExceptions) {
            this.breakOnExceptions = breakOnExceptions;
            this.dim.setBreakOnExceptions(breakOnExceptions);
        }

        @Override
        public void destroy() {
            if (this.dim == null) {
                throw new NullPointerException("dim is null");
            }
            this.dim.dispose();
            this.gui.destroy();
        }

        private static class ScopeWrapper
        implements ScopeProvider {
            private Scriptable scope;

            ScopeWrapper(Scriptable scope) {
                this.scope = scope;
            }

            @Override
            public Scriptable getScope() {
                return this.scope;
            }
        }

        private static class ExitAction
        implements Runnable {
            private Dim dim;
            private Runnable configurationExit;

            ExitAction(Dim dim, Runnable configurationExit) {
                this.dim = dim;
                this.configurationExit = configurationExit;
            }

            @Override
            public void run() {
                this.configurationExit.run();
                this.dim.detach();
                this.dim.dispose();
            }
        }

        public static abstract class Configuration {
            private boolean startWithBreak = true;
            private boolean breakOnExceptions = true;
            private Runnable exit = new Runnable(){

                @Override
                public void run() {
                    System.exit(1);
                }
            };
            private Log log = Log.NULL;

            public static Configuration create(final Ui.Factory uiFactory) {
                return new Configuration(){

                    @Override
                    public Ui.Factory getUiFactory() {
                        return uiFactory;
                    }
                };
            }

            public abstract Ui.Factory getUiFactory();

            public void setExit(Runnable exit) {
                if (exit == null) {
                    exit = new Runnable(){

                        @Override
                        public void run() {
                        }
                    };
                }
                this.exit = exit;
            }

            public void setLog(Log log) {
                if (log == null) {
                    log = Log.NULL;
                }
                this.log = log;
            }
        }

        public static abstract class Ui {
            public abstract void setExitAction(Runnable var1);

            public abstract void setVisible(boolean var1);

            public abstract void pack();

            abstract void destroy();

            public static abstract class Factory {
                public abstract Ui create(Dim var1, String var2);
            }
        }
    }

    public static class Profiler
    extends Debugger {
        private org.mozilla.javascript.debug.Debugger debugger = new MyDebugger();
        private Listener listener = AgentListener.get();
        private boolean useStringNodes;

        public final void useStringNodes() {
            this.useStringNodes = true;
        }

        @Override
        void initialize(Configuration contexts) {
            contexts.factory.addListener(new ContextFactory.Listener(){

                @Override
                public void contextCreated(Context cntxt) {
                    cntxt.setDebugger(Profiler.this.debugger, null);
                }

                @Override
                public void contextReleased(Context cntxt) {
                }
            });
        }

        @Override
        void setBreakpoint(Source source, int line) {
        }

        @Override
        void initialize(Scriptable scope, Engine engine, Program program) {
        }

        @Override
        Log getLog() {
            return Log.NULL;
        }

        @Override
        public boolean isBreakOnExceptions() {
            return false;
        }

        @Override
        public void setBreakOnExceptions(boolean breakOnExceptions) {
        }

        @Override
        public void destroy() {
        }

        private class MyDebugger
        implements org.mozilla.javascript.debug.Debugger {
            private MyDebugger() {
            }

            @Override
            public void handleCompilationDone(Context cntxt, DebuggableScript ds, String string) {
            }

            @Override
            public DebugFrame getFrame(Context cntxt, DebuggableScript ds) {
                return new DebugFrameImpl(ds, Profiler.this.listener);
            }

            private class DebugFrameImpl
            implements DebugFrame {
                private Listener listener;
                private CodeImpl code;

                DebugFrameImpl(DebuggableScript script, Listener listener) {
                    if (script == null) {
                        throw new NullPointerException();
                    }
                    this.listener = listener;
                    this.code = new CodeImpl(script);
                }

                public String toString() {
                    return this.code.toString();
                }

                @Override
                public void onEnter(Context cntxt, Scriptable s, Scriptable s1, Object[] os) {
                    if (this.listener != null) {
                        if (Profiler.this.useStringNodes) {
                            this.listener.start(this.code.toString());
                        } else {
                            this.listener.start(this.code);
                        }
                    }
                }

                @Override
                public void onExit(Context cntxt, boolean byThrow, Object resultOrException) {
                    if (this.listener != null) {
                        if (Profiler.this.useStringNodes) {
                            this.listener.end(this.code.toString());
                        } else {
                            this.listener.end(this.code);
                        }
                    }
                }

                @Override
                public void onExceptionThrown(Context cntxt, Throwable thrwbl) {
                }

                @Override
                public void onLineChange(Context cntxt, int i) {
                }

                @Override
                public void onDebuggerStatement(Context cntxt) {
                }
            }
        }

        public static class CodeImpl {
            private DebuggableScript script;
            private int[] lines;
            private String string;

            CodeImpl(DebuggableScript script) {
                this.script = script;
                this.lines = script.getLineNumbers();
                Arrays.sort(this.lines);
                String rv = script.getSourceName() + " [" + this.lines[0] + "-" + this.lines[this.lines.length - 1] + "]";
                if (script.getFunctionName() != null) {
                    rv = rv + " " + script.getFunctionName() + "()";
                }
                this.string = rv;
            }

            public String toString() {
                return this.string;
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof CodeImpl)) {
                    return false;
                }
                return this.toString().equals(o.toString());
            }

            public String getSourceName() {
                return this.script.getSourceName();
            }

            public int[] getLineNumbers() {
                return this.lines;
            }

            public String getFunctionName() {
                return this.script.getFunctionName();
            }
        }

        private static class AgentListener
        extends Listener {
            private Object agent;
            private Method start;
            private Method stop;

            static AgentListener get() {
                try {
                    Field field = Class.forName("inonit.tools.Profiler").getDeclaredField("javaagent");
                    field.setAccessible(true);
                    Object agent = field.get(null);
                    return new AgentListener(agent);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            AgentListener(Object agent) {
                this.agent = agent;
                try {
                    this.start = agent.getClass().getDeclaredMethod("start", Object.class);
                    this.stop = agent.getClass().getDeclaredMethod("stop", Object.class);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            void start(Object o) {
                try {
                    this.start.invoke(this.agent, o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            void end(Object o) {
                try {
                    this.stop.invoke(this.agent, o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static abstract class Listener {
            private Listener() {
            }

            abstract void start(Object var1);

            abstract void end(Object var1);
        }
    }

    private static class NoDebugger
    extends Debugger {
        private NoDebugger() {
        }

        @Override
        void initialize(Configuration contexts) {
        }

        @Override
        void setBreakpoint(Source source, int line) {
        }

        @Override
        void initialize(Scriptable scope, Engine engine, Program program) {
        }

        @Override
        Log getLog() {
            return Log.NULL;
        }

        @Override
        public boolean isBreakOnExceptions() {
            return false;
        }

        @Override
        public void setBreakOnExceptions(boolean breakOnExceptions) {
        }

        @Override
        public void destroy() {
        }
    }

    public static abstract class Debugger {
        abstract void initialize(Configuration var1);

        abstract void initialize(Scriptable var1, Engine var2, Program var3);

        abstract void setBreakpoint(Source var1, int var2);

        abstract Log getLog();

        final void log(String message) {
            this.getLog().println(message);
        }

        public abstract boolean isBreakOnExceptions();

        public abstract void setBreakOnExceptions(boolean var1);

        public abstract void destroy();
    }

    public static abstract class Log {
        public static final Log NULL = new Log(){

            @Override
            public void println(String message) {
            }
        };

        public abstract void println(String var1);

        public final void println() {
            this.println("");
        }
    }
}

