/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileWriter;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import tcf.Arena;
import tcf.Bot;
import tcf.CanStopMovement;
import tcf.CircularGfTest;
import tcf.CrowdTargetting;
import tcf.CrowdTargettingWave;
import tcf.DataSegmenter;
import tcf.Debug;
import tcf.GfBase;
import tcf.GuessFactor;
import tcf.GuessFactorWave;
import tcf.HistoryBot;
import tcf.MovementBase;
import tcf.OppBot;
import tcf.PredState;
import tcf.Prediction;
import tcf.PredictorInfo;
import tcf.Seg;
import tcf.SegmentedGfPredictor;
import tcf.Shot;
import tcf.SimplePredictor;
import tcf.SimpleSeg;
import tcf.Wave;
import tcf.WeightBase;

public class Drifter
extends AdvancedRobot {
    private static final boolean DEBUG_OUTPUT = false;
    private static final boolean WRITE_DATA = false;
    private static boolean TARGETTING_CHALLENGE = false;
    private static boolean MOVEMENT_CHALLENGE = false;
    Arena m_arena;
    long m_myTime = -1L;
    double m_x;
    double m_y;
    double m_heading;
    double m_speed;
    HistoryBot m_self = new HistoryBot();
    HistoryBot m_oldSelf = new HistoryBot();
    double m_fireAtX;
    double m_fireAtY;
    int m_waitFireTicks = 0;
    OppBot m_targetOpp = null;
    int m_oppCount = 0;
    BufferedWriter m_dataFile;
    Map<String, OppBot> m_bots = new HashMap<String, OppBot>();
    List<Shot> m_oppFire = new ArrayList<Shot>();
    List<GuessFactorWave> m_waves = new ArrayList<GuessFactorWave>();
    CrowdTargetting m_crowd = new CrowdTargetting();
    List<CrowdTargettingWave> m_ctWaves = new ArrayList<CrowdTargettingWave>();
    MovementBase m_movement = null;

    public void run() {
        Debug.m_out = System.out;
        this.m_arena = new Arena((Robot)this);
        this.setBodyColor(new Color(0, 200, 0));
        this.setGunColor(new Color(0, 150, 50));
        this.setRadarColor(new Color(0, 100, 100));
        this.setBulletColor(new Color(255, 255, 100));
        this.setScanColor(new Color(255, 200, 200));
        this.setAdjustGunForRobotTurn(true);
        this.m_oppCount = 0;
        if (!TARGETTING_CHALLENGE) {
            this.m_movement = new CanStopMovement(this.m_arena, this, this.m_self, this.m_ctWaves);
        }
        if (this.m_crowd.getPredictorInfoList().size() == 0) {
            this.m_crowd.addPredictor(new PredictorInfo(new SimplePredictor("sp.a"), 72.0));
            this.AddSecondarySegmentsToCrowd(2.0);
            this.AddTerciarySegmentsToCrowd(2.0);
        }
        this.processProperties();
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        long l = 0L;
        while (true) {
            long l2;
            if (l + 1L < (l2 = this.getTime())) {
                System.out.printf("Skipped %d turns!!!!\n", l2 - l - 1L);
            }
            l = l2;
            this.updateMyPosition();
            this.updateShots();
            this.updateWaves();
            if (this.m_movement != null) {
                this.m_movement.tick(this.m_bots, this.m_oppCount, this.m_targetOpp);
                this.m_movement.drive();
            }
            this.targetOpponent();
            this.radarControl();
            this.execute();
        }
    }

    private void AddPrimarySegmentsToCrowd(double d) {
        Seg[] segArray = new Seg[]{new SimpleSeg(-0.5, 8.5, 9), new SimpleSeg(0.0, 900.0, 9), new SimpleSeg(-2.5, 2.5, 5), new SimpleSeg(0.0, 450.0, 9), new SimpleSeg(0.0, 45.0, 9), new SimpleSeg(-8.0, 8.0, 9), new SimpleSeg(-350.0, 350.0, 15)};
        int n = segArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DataSegmenter dataSegmenter = new DataSegmenter(i, segArray[i]);
            String string = String.format("sgp-primary.%d", n2++);
            this.m_crowd.addPredictor(new PredictorInfo(new SegmentedGfPredictor(string, dataSegmenter, d), 1.0));
        }
    }

    private void AddSecondarySegmentsToCrowd(double d) {
        Seg[] segArray = new Seg[]{new SimpleSeg(0.0, 8.0, 5), new SimpleSeg(50.0, 650.0, 5), new SimpleSeg(-1.5, 1.5, 3), new SimpleSeg(50.0, 350.0, 5), new SimpleSeg(0.0, 45.0, 5), new SimpleSeg(-4.0, 4.0, 5), new SimpleSeg(-400.0, 400.0, 6)};
        int n = 0;
        int n2 = segArray.length - 1;
        int n3 = 1;
        int n4 = segArray.length;
        int n5 = 0;
        while (n < n2) {
            DataSegmenter dataSegmenter = new DataSegmenter(n, segArray[n], n3, segArray[n3]);
            String string = String.format("sgp-secondary.%d", n5++);
            this.m_crowd.addPredictor(new PredictorInfo(new SegmentedGfPredictor(string, dataSegmenter, d), 1.0));
            if (++n3 < n4) continue;
            n3 = ++n + 1;
        }
    }

    private void AddTerciarySegmentsToCrowd(double d) {
        Seg[] segArray = new Seg[]{new SimpleSeg(0.0, 8.0, 3), new SimpleSeg(50.0, 650.0, 3), new SimpleSeg(-1.5, 1.5, 3), new SimpleSeg(50.0, 350.0, 3), new SimpleSeg(0.0, 45.0, 3), new SimpleSeg(-4.0, 4.0, 3), new SimpleSeg(-400.0, 400.0, 4)};
        int n = 0;
        int n2 = segArray.length - 2;
        int n3 = 1;
        int n4 = segArray.length - 1;
        int n5 = 2;
        int n6 = segArray.length;
        int n7 = 0;
        while (n < n2) {
            DataSegmenter dataSegmenter = new DataSegmenter(n, segArray[n], n3, segArray[n3], n5, segArray[n5]);
            String string = String.format("sgp-terciary.%d", n7++);
            this.m_crowd.addPredictor(new PredictorInfo(new SegmentedGfPredictor(string, dataSegmenter, d), 1.0));
            if (++n5 < n6) continue;
            if (++n3 >= n4) {
                n3 = ++n + 1;
            }
            n5 = n3 + 1;
        }
    }

    private void processProperties() {
        if (!this.readProperties()) {
            this.writeDefaultProperties();
        }
    }

    private boolean readProperties() {
        Properties properties = new Properties();
        try {
            Debug.println(this.getDataFile("properties.txt"));
            properties.load(new FileInputStream(this.getDataFile("properties.txt")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        String string = properties.getProperty("mode");
        TARGETTING_CHALLENGE = string.equalsIgnoreCase("tc");
        MOVEMENT_CHALLENGE = string.equalsIgnoreCase("mc");
        return true;
    }

    private void writeDefaultProperties() {
        try {
            Debug.println(this.getDataFile("properties.txt"));
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)new RobocodeFileWriter(this.getDataFile("properties.txt")));
            bufferedWriter.write("# properties\r\n");
            bufferedWriter.write("# format: mode={normal, tc, mc}\r\n");
            bufferedWriter.write("mode=normal\r\n");
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeData(double[] dArray, double d) {
    }

    public void onDeath(DeathEvent deathEvent) {
    }

    public void onWin(WinEvent winEvent) {
    }

    private void updateWaves() {
        Wave wave;
        int n;
        for (n = this.m_waves.size() - 1; n >= 0; --n) {
            wave = this.m_waves.get(n);
            wave.tick();
            if (((GuessFactorWave)wave).target().isDead()) {
                this.m_waves.remove(n);
                continue;
            }
            if (((GuessFactorWave)wave).hasHit() && wave.gun() == this.m_self) {
                double d = ((GuessFactorWave)wave).calcGuessFactor();
                this.m_waves.remove(n);
                GfBase[] gfBaseArray = ((GuessFactorWave)wave).getGf();
                System.out.printf("target %g, %g\n", ((GuessFactorWave)wave).target().x(), ((GuessFactorWave)wave).target().y());
                for (int i = 0; i < gfBaseArray.length; ++i) {
                    gfBaseArray[i].learn(((GuessFactorWave)wave).getGfData(), d);
                    double d2 = ((GuessFactorWave)wave).bearing() + GuessFactor.gfToAngle(((GuessFactorWave)wave).m_gfValues[i], ((GuessFactorWave)wave).getAngleAhead(), ((GuessFactorWave)wave).getAngleBehind());
                    double d3 = wave.gunInitX() + wave.shotDist() * Math.sin(d2);
                    double d4 = wave.gunInitY() + wave.shotDist() * Math.cos(d2);
                    double d5 = d3 - ((GuessFactorWave)wave).target().x();
                    double d6 = d4 - ((GuessFactorWave)wave).target().y();
                    System.out.printf("gun %d  %g, %g\n", i, d3, d4);
                    if (!(d5 * d5 + d6 * d6 < 625.0)) continue;
                    int n2 = i;
                    ((GuessFactorWave)wave).m_gfStats[n2] = ((GuessFactorWave)wave).m_gfStats[n2] + 1;
                }
                System.out.printf("main %d, surf %d\n", ((GuessFactorWave)wave).m_gfStats[0], ((GuessFactorWave)wave).m_gfStats[1]);
                continue;
            }
            if (!((GuessFactorWave)wave).hasMissed()) continue;
            this.m_waves.remove(n);
        }
        for (n = this.m_ctWaves.size() - 1; n >= 0; --n) {
            wave = this.m_ctWaves.get(n);
            boolean bl = wave.hasHit(this.m_self);
            wave.tick();
            if (wave.hasMissed(this.m_self)) {
                Debug.printf("wave missed -- ct learn\n", new Object[0]);
                PredState predState = new PredState(this.m_arena, ((CrowdTargettingWave)wave).liveGun(), wave.shotSpeed(), this.m_self, null);
                ((CrowdTargettingWave)wave).learn(this.m_crowd, predState, false);
                this.m_ctWaves.remove(n);
                if (this.m_movement != null) {
                    this.m_movement.event(MovementBase.Event.EV_NEW_INFO);
                }
            }
            if (!wave.hasHit(this.m_self) || bl || this.m_movement == null) continue;
            this.m_movement.event(MovementBase.Event.EV_NEW_INFO);
        }
    }

    private void updateShots() {
        for (int i = this.m_oppFire.size() - 1; i >= 0; --i) {
            Shot shot = this.m_oppFire.get(i);
            shot.tick();
            if (!(shot.m_x < 0.0 || shot.m_x >= this.m_arena.WIDTH || shot.m_y < 0.0) && !(shot.m_y >= this.m_arena.HEIGHT)) continue;
            this.m_oppFire.remove(i);
        }
    }

    private void updateMyPosition() {
        long l = this.getTime();
        if (this.m_myTime != l) {
            this.m_myTime = l;
            this.m_x = this.getX();
            this.m_y = this.getY();
            this.m_heading = this.getHeadingRadians();
            this.m_speed = this.getVelocity();
            this.m_oldSelf.update(this.m_self.past());
            this.m_self.update(this.getName(), l, this.m_x, this.m_y, this.m_heading, this.m_speed);
        }
    }

    private void drive() {
        if (this.m_movement != null) {
            this.m_movement.drive();
        }
    }

    double linearPrediction(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d - d5;
        double d9 = d2 - d6;
        double d10 = d8 * d3 + d9 * d4;
        double d11 = d7 * Math.hypot(d8, d9);
        double d12 = d7 * d7 - (d3 * d3 + d4 * d4);
        double d13 = (d10 - d11) / d12;
        double d14 = (d10 + d11) / d12;
        double d15 = d13;
        if (d14 > 0.0 && (d13 < 0.0 || d14 < d13)) {
            d15 = d14;
        }
        return d15;
    }

    double linearPrediction2(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        int n = 0;
        while (true) {
            double d8 = d + (double)n * d3;
            double d9 = d2 + (double)n * d4;
            if (d8 < this.m_arena.MIN_X || d8 > this.m_arena.MAX_X || d9 < this.m_arena.MIN_Y || d9 > this.m_arena.MAX_Y) {
                return n;
            }
            double d10 = d5 - d8;
            double d11 = d6 - d9;
            if (d10 * d10 + d11 * d11 < (double)(n * n) * d7 * d7) {
                return n;
            }
            ++n;
        }
    }

    double linearPrediction2(Bot bot, Bot bot2, double d, double[] dArray) {
        double d2 = Math.sin(bot.heading()) * bot.speed();
        double d3 = Math.cos(bot.heading()) * bot.speed();
        double d4 = this.linearPrediction2(bot.x(), bot.y(), d2, d3, bot2.x(), bot2.y(), d);
        dArray[0] = bot.x() + d4 * d2;
        dArray[1] = bot.y() + d4 * d3;
        return d4;
    }

    double circularPrediction(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double[] dArray) {
        double d9 = Utils.normalRelativeAngle((double)(d3 - d5));
        double d10 = d;
        double d11 = d2;
        int n = 0;
        while (true) {
            if (d10 < this.m_arena.MIN_X || d10 > this.m_arena.MAX_X || d11 < this.m_arena.MIN_Y || d11 > this.m_arena.MAX_Y) {
                d10 = Math.max(this.m_arena.MIN_X, Math.min(d10, this.m_arena.MAX_X));
                d11 = Math.max(this.m_arena.MIN_Y, Math.min(d11, this.m_arena.MAX_Y));
                break;
            }
            double d12 = d6 - d10;
            double d13 = d7 - d11;
            if (d12 * d12 + d13 * d13 < (double)(n * n) * d8 * d8) break;
            d10 += d4 * Math.sin(d3);
            d11 += d4 * Math.cos(d3);
            d3 += d9;
            ++n;
        }
        dArray[0] = d10;
        dArray[1] = d11;
        return n;
    }

    double circularPrediction(HistoryBot historyBot, Bot bot, double d, double[] dArray) {
        return this.circularPrediction(historyBot.x(), historyBot.y(), historyBot.heading(), historyBot.speed(), historyBot.past().heading(), bot.x(), bot.y(), d, dArray);
    }

    double edgeDistAhead(Bot bot) {
        double d = Math.sin(bot.heading()) * Math.signum(bot.speed());
        double d2 = Math.cos(bot.heading()) * Math.signum(bot.speed());
        double d3 = Double.POSITIVE_INFINITY;
        if (d <= 0.0) {
            d3 = Math.min(d3, bot.x() - this.m_arena.MIN_X);
        }
        if (d >= 0.0) {
            d3 = Math.min(d3, this.m_arena.MAX_X - bot.x());
        }
        if (d2 <= 0.0) {
            d3 = Math.min(d3, bot.y() - this.m_arena.MIN_Y);
        }
        if (d2 >= 0.0) {
            d3 = Math.min(d3, this.m_arena.MAX_Y - bot.y());
        }
        return d3;
    }

    double distAhead(Bot bot) {
        double d = Math.signum(bot.speed());
        if (d == 0.0) {
            d = 1.0;
        }
        double d2 = Math.sin(bot.heading()) * d;
        double d3 = Math.cos(bot.heading()) * d;
        double d4 = Double.POSITIVE_INFINITY;
        if (d2 < 0.0) {
            d4 = Math.min(d4, bot.x() / -d2);
        }
        if (d2 > 0.0) {
            d4 = Math.min(d4, (this.m_arena.WIDTH - bot.x()) / d2);
        }
        if (d3 < 0.0) {
            d4 = Math.min(d4, bot.y() / -d3);
        }
        if (d3 > 0.0) {
            d4 = Math.min(d4, (this.m_arena.HEIGHT - bot.y()) / d3);
        }
        return d4;
    }

    static double[] calcGfData(Arena arena, HistoryBot historyBot, Bot bot) {
        double d = Math.hypot(historyBot.x() - bot.x(), historyBot.y() - bot.y());
        double d2 = Math.atan2(historyBot.x() - bot.x(), historyBot.y() - bot.y());
        double d3 = historyBot.heading() - d2;
        if (historyBot.speed() < 0.0) {
            d3 += Math.PI;
        }
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        double d6 = historyBot.speed() * d4;
        double d7 = historyBot.speed() * Math.cos(historyBot.heading() - d2);
        double d8 = Math.abs(historyBot.speed()) - Math.abs(historyBot.past().speed());
        d6 = Math.abs(d6);
        double d9 = Math.hypot(historyBot.x() - arena.CEN_X, historyBot.y() - arena.CEN_Y);
        double d10 = arena.closestEdgeX(historyBot.x());
        double d11 = arena.closestEdgeY(historyBot.y());
        double d12 = arena.cornerDistManhattan(historyBot.x(), historyBot.y());
        d12 = Math.max(1.0, d12 - 100.0);
        double d13 = historyBot.heading();
        if (historyBot.speed() < 0.0) {
            d13 += Math.PI;
        }
        if ((d10 - historyBot.x()) * Math.sin(d13) + (d11 - historyBot.y()) * Math.cos(d13) < 0.0) {
            d12 = -d12;
        }
        double d14 = arena.linearDistAhead(historyBot);
        double d15 = Math.abs(historyBot.speed());
        boolean bl = false;
        int n = 50;
        for (int i = 1; i < 50; ++i) {
            double d16 = Math.abs(historyBot.past(i).speed());
            if (!bl) {
                if (d15 < d16) {
                    n = i;
                    bl = true;
                }
            } else {
                if (!(d15 < d16)) break;
                n = i;
            }
            d15 = d16;
        }
        double d17 = 0.0;
        for (int i = 0; i < 50; ++i) {
        }
        double[] dArray = new double[]{d6, d, d8, d14, n, d7, d12};
        return dArray;
    }

    double[] calcGfData(HistoryBot historyBot, Bot bot) {
        return Drifter.calcGfData(this.m_arena, historyBot, bot);
    }

    private void targetOpponent() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = 1.0E10;
        OppBot oppBot = null;
        for (OppBot oppBot2 : this.m_bots.values()) {
            d4 = Math.hypot(oppBot2.x() - this.m_x, oppBot2.y() - this.m_y);
            if (!(d5 > d4)) continue;
            d5 = d4;
            oppBot = oppBot2;
        }
        this.m_targetOpp = oppBot;
        if (oppBot == null) {
            return;
        }
        double d6 = 3.0;
        if (d5 > 100.0) {
            d6 = Math.min(2.5, oppBot.scan().getEnergy() / 4.0);
        }
        d6 = Math.max(0.1, Math.min(d6, this.getEnergy() / 20.0));
        if (TARGETTING_CHALLENGE) {
            d6 = Math.min(3.0, this.getEnergy());
        }
        d4 = Rules.getBulletSpeed((double)d6);
        boolean bl = !MOVEMENT_CHALLENGE && this.getGunHeat() == 0.0 && this.getEnergy() > 0.0 && (TARGETTING_CHALLENGE || this.getEnergy() > 1.0 || this.getEnergy() > 0.1 && d5 < 100.0);
        GuessFactorWave guessFactorWave = null;
        double d7 = d3 = Math.atan2(oppBot.x() - this.m_x, oppBot.y() - this.m_y);
        if (oppBot.scan().getEnergy() > 0.0) {
            d2 = GuessFactor.calcAngle(true, this.m_self, d4, oppBot);
            d = GuessFactor.calcAngle(false, this.m_self, d4, oppBot);
            double d8 = Math.atan(18.0 / d5) / Math.abs(d2 - d);
            CircularGfTest circularGfTest = new CircularGfTest(this.m_self, oppBot, this.m_arena, d2, d);
            double[] dArray = this.calcGfData(oppBot, this.m_self);
            double[] dArray2 = new double[oppBot.m_myGf.length];
            int n = 0;
            for (int i = 0; i < oppBot.m_myGf.length; ++i) {
                dArray2[i] = oppBot.m_myGf[i].best(dArray, d8, circularGfTest);
                if (oppBot.m_myGfStats[n] >= oppBot.m_myGfStats[i]) continue;
                n = i;
            }
            if (bl) {
                guessFactorWave = new GuessFactorWave(this.m_self, d4, oppBot, dArray, oppBot.m_myGf, dArray2, oppBot.m_myGfStats);
            }
            n = 0;
            double d9 = dArray2[n];
            this.writeData(dArray, d9);
            d7 += GuessFactor.gfToAngle(d9, d2, d);
        }
        this.m_fireAtX = this.m_x + Math.sin(d7) * d5;
        this.m_fireAtY = this.m_y + Math.cos(d7) * d5;
        d2 = Math.atan2(this.m_fireAtX - this.m_x, this.m_fireAtY - this.m_y);
        d = Utils.normalRelativeAngle((double)(d2 - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(d);
        if (bl) {
            this.setFire(d6);
            this.m_waitFireTicks = 0;
            if (guessFactorWave != null) {
                this.m_waves.add(guessFactorWave);
            }
        }
    }

    private void fireVirtualBullets(double d) {
    }

    private void radarControl() {
        if (this.m_oppCount != this.getOthers()) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            return;
        }
        OppBot oppBot = null;
        long l = this.getTime() + 1L;
        for (OppBot oppBot2 : this.m_bots.values()) {
            if (l <= oppBot2.scan().getTime()) continue;
            l = oppBot2.scan().getTime();
            oppBot = oppBot2;
        }
        if (oppBot != null) {
            if (l + 10L < oppBot.scan().getTime()) {
                System.out.println("Lost radar lock !!!!");
                this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            } else {
                double d;
                double d2 = Math.atan2(oppBot.x() - this.m_x, oppBot.y() - this.m_y);
                this.setTurnRadarRightRadians(d += (double)((d = Utils.normalRelativeAngle((double)(d2 - this.getRadarHeadingRadians()))) < 0.0 ? -1 : 1) * Rules.RADAR_TURN_RATE_RADIANS / 2.0);
            }
        } else if (this.getOthers() > 0) {
            System.out.println("No oldest!!!! -- starting radar.");
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    private void cleanupDeadOpponents(long l) {
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        Debug.println("hit wall!!");
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.updateMyPosition();
        this.cleanupDeadOpponents(scannedRobotEvent.getTime());
        OppBot oppBot = this.m_bots.get(scannedRobotEvent.getName());
        if (oppBot == null) {
            oppBot = new OppBot(scannedRobotEvent, this.m_self);
            this.m_bots.put(scannedRobotEvent.getName(), oppBot);
            ++this.m_oppCount;
            if (this.m_movement != null) {
                this.m_movement.event(MovementBase.Event.EV_NEW_INFO);
            }
        }
        double d = this.m_heading + scannedRobotEvent.getBearingRadians();
        double d2 = this.m_x + scannedRobotEvent.getDistance() * Math.sin(d);
        double d3 = this.m_y + scannedRobotEvent.getDistance() * Math.cos(d);
        double d4 = oppBot.scan().getEnergy() - scannedRobotEvent.getEnergy();
        oppBot.update(scannedRobotEvent, this.m_self);
        if (d4 >= 0.0999 && d4 <= 3.0) {
            double d5 = Rules.getBulletSpeed((double)d4);
            HistoryBot historyBot = this.m_oldSelf;
            PredState predState = new PredState(this.m_arena, oppBot.past(), d5, this.m_oldSelf);
            CrowdTargettingWave crowdTargettingWave = new CrowdTargettingWave(oppBot, predState, this.m_crowd);
            this.m_ctWaves.add(crowdTargettingWave);
            if (this.m_movement != null) {
                this.m_movement.event(MovementBase.Event.EV_NEW_INFO);
            }
        }
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        double d;
        double d2;
        double d3;
        double d4;
        Bullet bullet = hitByBulletEvent.getBullet();
        OppBot oppBot = this.m_bots.get(hitByBulletEvent.getName());
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        for (Shot shot : this.m_oppFire) {
            double d5;
            if (shot.getOpp() != oppBot || !(Math.abs((d4 = Math.hypot(d3 = shot.getInitialX() - this.m_x, d2 = shot.getInitialY() - this.m_y) - 20.0) - shot.getDist()) < 20.0)) continue;
            d = bullet.getX() - shot.futureX(0);
            double d6 = d * d + (d5 = bullet.getY() - shot.futureY(0)) * d5;
            double d7 = d6 < 2500.0 ? 1.0 : 0.0;
            double d8 = -1.0;
            if (hashMap.get(shot.getType()) != null) {
                d8 = (Double)hashMap.get(shot.getType());
            }
            if (!(d8 < d7)) continue;
            hashMap.put(shot.getType(), d7);
        }
        Iterator<Object> iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            d3 = (Double)hashMap.get(n);
            oppBot.m_si.incShotType(n, d3);
        }
        for (GuessFactorWave guessFactorWave : this.m_waves) {
            if (guessFactorWave.gun() != oppBot || !(Math.abs((d4 = Math.hypot(d3 = guessFactorWave.gunInitX() - this.m_x, d2 = guessFactorWave.gunInitY() - this.m_y) - 20.0) - guessFactorWave.shotDist()) < 20.0)) continue;
            d = guessFactorWave.calcGuessFactor(bullet.getX(), bullet.getY());
            GfBase[] gfBaseArray = guessFactorWave.getGf();
            for (int i = 0; i < gfBaseArray.length; ++i) {
                gfBaseArray[i].learn(guessFactorWave.getGfData(), d);
            }
        }
        boolean bl = false;
        for (CrowdTargettingWave crowdTargettingWave : this.m_ctWaves) {
            double d9;
            double d10;
            double d11;
            if (crowdTargettingWave.liveGun() != oppBot || !(Math.abs((d11 = Math.hypot(d10 = crowdTargettingWave.gunInitX() - this.m_x, d9 = crowdTargettingWave.gunInitY() - this.m_y) - 20.0) - crowdTargettingWave.shotDist()) < 20.0)) continue;
            Debug.printf("onHitByBullet() ct learn\n", new Object[0]);
            PredState predState = new PredState(this.m_arena, oppBot, crowdTargettingWave.shotSpeed(), this.m_self, bullet);
            crowdTargettingWave.learn(this.m_crowd, predState, true);
            bl = true;
        }
        if (bl) {
            for (CrowdTargettingWave crowdTargettingWave : this.m_ctWaves) {
                crowdTargettingWave.reinitialise(this.m_crowd);
            }
            if (this.m_movement != null) {
                this.m_movement.event(MovementBase.Event.EV_NEW_INFO);
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        Bullet bullet = bulletHitBulletEvent.getHitBullet();
        Debug.printf("bullet hit bullet: x %g, y %g, power %g\n", bullet.getX(), bullet.getY(), bullet.getPower());
        OppBot oppBot = this.m_bots.get(bullet.getName());
        boolean bl = false;
        Iterator<CrowdTargettingWave> iterator = this.m_ctWaves.iterator();
        while (iterator.hasNext()) {
            double d;
            double d2;
            double d3;
            CrowdTargettingWave crowdTargettingWave = iterator.next();
            if (crowdTargettingWave.liveGun() != oppBot || !(Math.abs((d3 = Math.hypot(d2 = crowdTargettingWave.gunInitX() - bullet.getX(), d = crowdTargettingWave.gunInitY() - bullet.getY())) - crowdTargettingWave.shotDist()) < 20.0)) continue;
            Debug.printf("ct learn\n", new Object[0]);
            PredState predState = new PredState(this.m_arena, oppBot, crowdTargettingWave.shotSpeed(), this.m_self, bullet);
            crowdTargettingWave.learn(this.m_crowd, predState, true);
            iterator.remove();
            bl = true;
        }
        if (bl) {
            for (CrowdTargettingWave crowdTargettingWave : this.m_ctWaves) {
                crowdTargettingWave.reinitialise(this.m_crowd);
            }
            if (this.m_movement != null) {
                this.m_movement.event(MovementBase.Event.EV_NEW_INFO);
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        OppBot oppBot = this.m_bots.get(robotDeathEvent.getName());
        if (oppBot == null) {
            return;
        }
        --this.m_oppCount;
        this.m_bots.remove(robotDeathEvent.getName());
    }

    private void drawPrediction(Graphics2D graphics2D, Prediction prediction, WeightBase weightBase, int n, int n2, int n3, int n4, boolean bl) {
        double d = (double)n3 / 101.0;
        double d2 = prediction.maxValue();
        double d3 = (double)n4 / d2;
        graphics2D.setColor(Color.green);
        graphics2D.drawString(String.format("%1.1f", d2), n, n2 + n4 - 10);
        graphics2D.setColor(bl ? Color.white : Color.orange);
        for (int i = 0; i < 101; ++i) {
            int n5 = (int)(prediction.get(i) * d3);
            int n6 = n + (int)((double)i * d);
            graphics2D.drawLine(n6, n2, n6, n2 + n5);
        }
        if (weightBase != null) {
            graphics2D.setColor(Color.magenta);
            graphics2D.drawLine(n, n2 - 3, n + (int)((double)n3 * weightBase.getWeight()), n2 - 3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onPaint(Graphics2D graphics2D) {
        void var3_13;
        int n;
        int n2;
        int n3;
        int n4;
        graphics2D.setColor(Color.white);
        for (OppBot object : this.m_bots.values()) {
            n4 = (int)this.getWidth();
            n3 = (int)this.getHeight();
            n2 = (int)object.x() - n4 / 2;
            n = (int)object.y() - n3 / 2;
            graphics2D.drawRect(n2, n, n4, n3);
        }
        if (this.m_movement != null) {
            graphics2D.setColor(Color.cyan);
            graphics2D.drawRect((int)this.m_movement.getToX() - 18, (int)this.m_movement.getToY() - 18, 36, 36);
        }
        if (this.m_targetOpp != null && !this.m_targetOpp.isDead()) {
            graphics2D.setColor(Color.red);
            graphics2D.fillRect((int)this.m_targetOpp.x() - 5, (int)this.m_targetOpp.y() - 5, 10, 10);
        }
        if (this.m_fireAtX > 0.0) {
            graphics2D.setColor(Color.yellow);
            graphics2D.fillRect((int)this.m_fireAtX - 4, (int)this.m_fireAtY - 4, 8, 8);
        }
        if (this.m_movement != null) {
            this.m_movement.onPaint(graphics2D);
        }
        graphics2D.setColor(Color.white);
        for (OppBot oppBot : this.m_bots.values()) {
            n4 = (int)this.getWidth();
            n3 = (int)this.getHeight();
            n2 = (int)oppBot.x() - n4 / 2;
            n = (int)oppBot.y() - n3 / 2;
            double[] dArray = this.calcGfData(oppBot, this.m_self);
            for (int i = 0; i < dArray.length; ++i) {
                graphics2D.drawString(String.format("%g", dArray[i]), n2 + n4 + 5, n + i * 10);
            }
        }
        graphics2D.setColor(Color.orange);
        for (Shot shot : this.m_oppFire) {
            if (shot.getOpp().m_si.getBestShotType() == shot.getType()) {
                graphics2D.setColor(Color.getHSBColor(1.0f - (float)shot.getWeight(), 1.0f, 1.0f));
            } else {
                graphics2D.setColor(new Color(0.75f, 0.75f, 0.75f));
            }
            String string = String.valueOf(shot.getType());
            n3 = (int)(shot.m_x - 10.0 * shot.m_vx / shot.m_speed);
            n2 = (int)(shot.m_y - 10.0 * shot.m_vy / shot.m_speed);
            n = graphics2D.getFontMetrics().stringWidth(string);
            int n5 = graphics2D.getFontMetrics().getAscent();
            graphics2D.drawString(string, n3 - n / 2, n2 - n5 / 2);
            graphics2D.drawRect((int)shot.m_x - 3, (int)shot.m_y - 3, 6, 6);
        }
        for (GuessFactorWave guessFactorWave : this.m_waves) {
            int n6 = (int)guessFactorWave.shotDist() + 5;
            n3 = (int)((double)n6 * Math.sin(guessFactorWave.bearing()));
            n2 = (int)((double)n6 * Math.cos(guessFactorWave.bearing()));
            graphics2D.setColor(Color.magenta);
            graphics2D.drawOval((int)guessFactorWave.gunInitX() - n6, (int)guessFactorWave.gunInitY() - n6, n6 + n6, n6 + n6);
            graphics2D.drawLine((int)guessFactorWave.gunInitX(), (int)guessFactorWave.gunInitY(), (int)guessFactorWave.gunInitX() + n3, (int)guessFactorWave.gunInitY() + n2);
            GfBase[] gfBaseArray = guessFactorWave.getGf();
            for (int i = 0; i < gfBaseArray.length; ++i) {
                if (!(guessFactorWave.getGf()[i] instanceof GfBase)) continue;
                double d = guessFactorWave.bearing() + GuessFactor.gfToAngle(guessFactorWave.m_gfValues[i], guessFactorWave.getAngleAhead(), guessFactorWave.getAngleBehind());
                double d2 = guessFactorWave.gunInitX() + guessFactorWave.shotDist() * Math.sin(d);
                double d3 = guessFactorWave.gunInitY() + guessFactorWave.shotDist() * Math.cos(d);
                if (i == 0) {
                    graphics2D.setColor(Color.green);
                    graphics2D.drawOval((int)(d2 - 3.0), (int)(d3 - 3.0), 6, 6);
                    continue;
                }
                graphics2D.setColor(Color.cyan);
                graphics2D.drawOval((int)(d2 - 2.0), (int)(d3 - 2.0), 4, 4);
            }
        }
        for (CrowdTargettingWave crowdTargettingWave : this.m_ctWaves) {
            int n7 = (int)crowdTargettingWave.shotDist();
            n3 = (int)((double)n7 * Math.sin(crowdTargettingWave.bearing()));
            n2 = (int)((double)n7 * Math.cos(crowdTargettingWave.bearing()));
            double d = crowdTargettingWave.m_initialState.m_angleAhead;
            double d4 = crowdTargettingWave.m_initialState.m_angleBehind;
            Prediction prediction = crowdTargettingWave.getPrediction();
            double d5 = Math.max(prediction.maxValue() * 1.5, 1.0E-4);
            graphics2D.drawString(String.format("max prob %g", d5), 10, 10);
            for (int i = 0; i < 101; ++i) {
                double d6 = ((double)i + 0.5) / 101.0;
                double d7 = crowdTargettingWave.bearing() + GuessFactor.gfToAngle(d6, d, d4);
                int n8 = (int)(crowdTargettingWave.gunInitX() + (double)(n7 + 2) * Math.sin(d7));
                int n9 = (int)(crowdTargettingWave.gunInitY() + (double)(n7 + 2) * Math.cos(d7));
                graphics2D.setColor(Color.getHSBColor((float)(0.66 - prediction.get(i) / d5), 1.0f, 1.0f));
                graphics2D.drawOval(n8 - 1, n9 - 1, 2, 2);
            }
        }
        if (this.m_targetOpp != null) {
            // empty if block
        }
        graphics2D.setColor(Color.white);
        List<PredictorInfo> list = this.m_crowd.getPredictorInfoList();
        boolean bl = false;
        while (var3_13 < list.size()) {
            PredictorInfo predictorInfo = (PredictorInfo)list.get((int)var3_13);
            String string = String.format("%.5f", predictorInfo.getWeight());
            graphics2D.drawString(string, (int)this.m_arena.WIDTH / 4 + var3_13 * 60, 5);
            ++var3_13;
        }
    }
}

