/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.AbstractStrategy;
import amarok.Arena;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.Enemy;
import amarok.FireSolution;
import amarok.Strategy;
import robocode.AdvancedRobot;

public class LinearPrediction
extends AbstractStrategy
implements Strategy,
BotConstants {
    public double getGoodness() {
        return 0.5;
    }

    public void doOneTurn() {
        Enemy nme = this.arena.getEnemy();
        if (nme == null) {
            return;
        }
        double x = nme.getPoint().x;
        double y = nme.getPoint().y;
        double velocity = nme.getVelocity();
        double heading = nme.getHeading();
        double bearing = nme.getBearing();
        AdvancedRobot me = this.arena.getMe();
        long now = me.getTime();
        double X = me.getX();
        double Y = me.getY();
        double power = Math.random() + 1.5;
        double gunHeading = BotMath.normalizeBearing(bearing - me.getGunHeadingRadians() + Math.asin(velocity / (20.0 - 3.0 * power) * Math.sin(heading - bearing)));
        FireSolution fireSolution = this.arena.getFireSolution();
        int deltaHeat = (int)(me.getGunHeat() / me.getGunCoolingRate());
        fireSolution.setCalculatedGunHeading(gunHeading);
        if (deltaHeat >= 2) {
            return;
        }
        fireSolution.setCalculatedFiringTime(now + (long)deltaHeat);
        fireSolution.setCalculatedGunPower(power);
        fireSolution.setSolved(true);
    }

    public String toString() {
        return "WallsPrediction";
    }

    public LinearPrediction(Arena a) {
        super(a);
    }
}

