/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.util.Iterator;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotImpl;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.misc.Host;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPositionImpl;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public abstract class EventHandlerBase
extends AdvancedRobot
implements Debuggable {
    private static long countBulletHitEvent = 0L;
    private static long countBulletHitBulletEvent = 0L;
    private static long countBulletMissedEvent = 0L;
    private static long countHitByBulletEvent = 0L;
    private static long countHitRobotEvent = 0L;
    private static long countHitWallEvent = 0L;
    private static long countRobotDeathEvent = 0L;
    private static long countScannedRobotEvent = 0L;
    private static long countSkippedTurnEvent = 0L;
    private static long countWinEvent = 0L;
    private static long countDeathEvent = 0L;

    protected void processAllEvents() {
        Host.singleton.initializeTurn(this);
        Iterator iterator = this.getScannedRobotEvents().iterator();
        while (iterator.hasNext()) {
            this.process((ScannedRobotEvent)iterator.next());
        }
        iterator = this.getHitWallEvents().iterator();
        while (iterator.hasNext()) {
            this.process((HitWallEvent)iterator.next());
        }
        iterator = this.getHitRobotEvents().iterator();
        while (iterator.hasNext()) {
            this.process((HitRobotEvent)iterator.next());
        }
        iterator = this.getBulletHitBulletEvents().iterator();
        while (iterator.hasNext()) {
            this.process((BulletHitBulletEvent)iterator.next());
        }
        iterator = this.getBulletHitEvents().iterator();
        while (iterator.hasNext()) {
            this.process((BulletHitEvent)iterator.next());
        }
        iterator = this.getHitByBulletEvents().iterator();
        while (iterator.hasNext()) {
            this.process((HitByBulletEvent)iterator.next());
        }
        iterator = this.getRobotDeathEvents().iterator();
        while (iterator.hasNext()) {
            this.process((RobotDeathEvent)iterator.next());
        }
        iterator = this.getBulletMissedEvents().iterator();
        while (iterator.hasNext()) {
            this.process((BulletMissedEvent)iterator.next());
        }
    }

    public void onDeath(DeathEvent event) {
        this.processAllEvents();
        this.onDeath(Host.singleton.getTurn());
        ++countDeathEvent;
    }

    public void onWin(WinEvent event) {
        this.processAllEvents();
        this.onWin(Host.singleton.getTurn());
        ++countWinEvent;
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.processAllEvents();
        ++countSkippedTurnEvent;
    }

    public void onCustomEvent(CustomEvent e) {
        this.processAllEvents();
    }

    protected abstract void onRobotHitByCombatant(long var1, String var3, Bullet var4);

    protected abstract void onCombatantHitByRobot(long var1, String var3, Bullet var4);

    protected abstract void onRobotDeath(long var1, String var3);

    protected abstract void processRobotSnapshot(long var1, String var3, Snapshot var4);

    protected abstract void onDeath(long var1);

    protected abstract void onWin(long var1);

    private void process(BulletHitEvent e) {
        ++countBulletHitEvent;
        this.onRobotHitByCombatant(Host.singleton.getTurn(), e.getName(), e.getBullet());
    }

    private void process(BulletHitBulletEvent e) {
        ++countBulletHitBulletEvent;
    }

    private void process(HitByBulletEvent e) {
        ++countHitByBulletEvent;
        this.onCombatantHitByRobot(Host.singleton.getTurn(), e.getName(), e.getBullet());
    }

    private void process(BulletMissedEvent e) {
        ++countBulletMissedEvent;
    }

    private void process(HitRobotEvent e) {
        ++countHitRobotEvent;
    }

    private void process(HitWallEvent e) {
        ++countHitWallEvent;
    }

    private void process(RobotDeathEvent e) {
        ++countRobotDeathEvent;
        this.onRobotDeath(Host.singleton.getTurn(), e.getName());
    }

    private void process(ScannedRobotEvent e) {
        ++countScannedRobotEvent;
        this.processRobotSnapshot(Host.singleton.getTurn(), e.getName(), new SnapshotImpl(Host.singleton.getRound(), e.getTime(), new StaticPositionImpl(Host.singleton.getChassisX(), Host.singleton.getChassisY(), StaticHeadingImpl.getCompoundAngle(Host.singleton.getChassisHeading(), e.getBearingRadians()), e.getDistance()), e.getHeadingRadians(), e.getVelocity(), e.getEnergy()));
    }

    public void debug() {
        Debug.line("countBulletHitEvent = " + countBulletHitEvent);
        Debug.line("countBulletHitBulletEvent = " + countBulletHitBulletEvent);
        Debug.line("countBulletMissedEvent = " + countBulletMissedEvent);
        Debug.line("countHitByBulletEvent = " + countHitByBulletEvent);
        Debug.line("countHitRobotEvent = " + countHitRobotEvent);
        Debug.line("countHitWallEvent = " + countHitWallEvent);
        Debug.line("countRobotDeathEvent = " + countRobotDeathEvent);
        Debug.line("countScannedRobotEvent = " + countScannedRobotEvent);
        Debug.line("countSkippedTurnEvent = " + countSkippedTurnEvent);
    }
}

