/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.layer.InputLayer;
import dmonner.xlbp.util.MatrixTools;

public class Input {
    private final InputLayer layer;
    private final float[] value;

    public Input(InputLayer layer, float[] value) {
        this.layer = layer;
        this.value = value;
        if (value.length != layer.size()) {
            throw new IllegalArgumentException("Incorrect Input Size; expected " + layer.size() + " for " + layer.getName() + ", got " + value.length);
        }
    }

    public void apply() {
        this.layer.setInput(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof Input) {
            Input that = (Input)other;
            return that.layer == this.layer;
        }
        return false;
    }

    public InputLayer getLayer() {
        return this.layer;
    }

    public float[] getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.layer.hashCode();
    }

    public String toString() {
        return this.layer.getName() + ": " + MatrixTools.toString(this.value);
    }
}

