/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.connection.LayerConnection;
import dmonner.xlbp.layer.AbstractDownstreamLayer;
import dmonner.xlbp.layer.WeightReceiverLayer;

public class WeightSenderLayer
extends AbstractDownstreamLayer {
    private static final long serialVersionUID = 1L;
    private LayerConnection out;

    public WeightSenderLayer(String name, int size) {
        super(name, size);
    }

    public WeightSenderLayer(WeightSenderLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    @Override
    public void activateTest() {
    }

    @Override
    public void activateTrain() {
    }

    @Override
    public void aliasResponsibilities(int index, Responsibilities resp) {
        super.aliasResponsibilities(index, resp);
        this.upstream.aliasResponsibilities(this.myIndexInUpstream, resp);
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.upstream.build();
            this.y = this.upstream.getActivations();
            this.d = new Responsibilities(this.size);
            this.upstream.aliasResponsibilities(this.myIndexInUpstream, this.d);
            this.built = true;
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void clearActivations() {
    }

    @Override
    public void clearEligibilities() {
    }

    @Override
    public void clearResponsibilities() {
    }

    @Override
    public WeightSenderLayer copy(NetworkCopier copier) {
        return new WeightSenderLayer(this, copier);
    }

    @Override
    public WeightSenderLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    public LayerConnection getConnection() {
        return this.out;
    }

    public void removeConnection() {
        if (this.out != null) {
            WeightReceiverLayer to = this.out.getToLayer();
            this.out = null;
            if (to.getConnection() != null) {
                to.removeConnection();
            }
        }
    }

    public void setConnection(LayerConnection connection) {
        if (this.out != null) {
            throw new IllegalStateException(this.name + " already has an output connection.");
        }
        WeightSenderLayer from = connection.getFromLayer();
        WeightReceiverLayer to = connection.getToLayer();
        if (from != this) {
            throw new IllegalStateException("Connection " + connection.getName() + " comes from " + from + ", not " + this.name + ".");
        }
        this.out = connection;
        if (to.getConnection() != connection) {
            to.setConnection(connection);
        }
    }

    @Override
    public void updateEligibilities() {
    }

    @Override
    public void updateResponsibilities() {
        this.out.updateResponsibilities();
    }

    @Override
    public void updateUpstreamResponsibilities(int index) {
    }
}

