/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.gun.gf;

import catcat20.helios.gun.Gun;
import catcat20.helios.gun.WaveGun;
import catcat20.helios.rader.HeliosRadar;
import catcat20.helios.robot.Bot;
import catcat20.helios.robot.BotState;
import catcat20.helios.utils.HConstants;
import catcat20.helios.utils.HUtils;
import catcat20.helios.utils.Wave;
import catcat20.helios.utils.knn.GFData;
import catcat20.helios.utils.knn.KNNData;
import catcat20.jewel.iolite.utils.IUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.TeamRobot;

public class AntiSurferGun
extends Gun
implements WaveGun {
    public Point2D.Double _myPos;
    public Wave lastWave;

    public AntiSurferGun(TeamRobot _robot) {
        super(_robot);
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
    }

    @Override
    public void update(Wave w) {
        this.lastWave = w;
    }

    @Override
    public void onBulletHit(BulletHitEvent e, Wave w) {
        if (w != null) {
            Point2D.Double hitLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            this.logHit(w, hitLocation, true);
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e, Wave w) {
        if (w != null) {
            Point2D.Double hitLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            this.logHit(w, hitLocation, true);
        }
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public double getAngle() {
        if (this.lastWave == null) {
            return HUtils.absoluteBearing(this._myPos, HConstants.fieldCenter);
        }
        long time = this._robot.getTime();
        Bot en = HeliosRadar.nearestBot;
        if (en != null) {
            if (en.alive) {
                Object pos;
                double absBearing = HUtils.absoluteBearing(this._myPos, en.currentState.getPosition());
                Graphics2D g = this._robot.getGraphics();
                ArrayList<KNNData<GFData>> list = en.antiSurferGunModel.getNearestNeighborsList(this.dataPoint(this.lastWave), (int)HUtils.limit(1.0, Math.sqrt(en.antiSurferGunModel.tree.size()) + 1.0, 64.0));
                ArrayList<Angle> angles = new ArrayList<Angle>();
                for (KNNData<GFData> data : list) {
                    GFData d = (GFData)data.data;
                    double decayWeight = 1.0 / Math.pow(d.decayRate, time - d.time);
                    Angle angle = new Angle();
                    angle.angle = HUtils.limit(-1.1, d.guessFactor, 1.1) * IUtils.maxEscapeAngle(this.lastWave.bulletVelocity()) * (double)this.lastWave.direction;
                    angle.weight = decayWeight * d.weight * d.treeWeight / data.distance;
                    angles.add(angle);
                    g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.35f));
                    if (d.weight < 0.0) {
                        g.setColor(Color.orange);
                    }
                    pos = HUtils.project(this._myPos, absBearing + angle.angle, 180.0);
                    g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)((Point2D.Double)pos).x, (int)((Point2D.Double)pos).y);
                }
                double bestAngle = 0.0;
                double bestDensity = 0.0;
                double bandwidth = 36.0 / this._myPos.distance(en.currentState.getPosition());
                for (Angle angle : angles) {
                    double density = 0.0;
                    for (Angle angle2 : angles) {
                        if (angle == angle2) continue;
                        double ux = (angle.angle - angle2.angle) / bandwidth;
                        density += Math.exp(-0.5 * ux * ux) * angle2.weight;
                    }
                    if (!(density > bestDensity)) continue;
                    bestAngle = angle.angle;
                    bestDensity = density;
                }
                g.setColor(this.getColor());
                pos = IUtils.project(this._myPos, absBearing + bestAngle, 230.0);
                g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)((Point2D.Double)pos).x, (int)((Point2D.Double)pos).y);
                g.setColor(Color.orange);
                pos = IUtils.project(this._myPos, absBearing, 300.0);
                g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)((Point2D.Double)pos).x, (int)((Point2D.Double)pos).y);
                return absBearing + bestAngle;
            }
            return HUtils.absoluteBearing(this._myPos, HConstants.fieldCenter);
        }
        return HUtils.absoluteBearing(this._myPos, HConstants.fieldCenter);
    }

    @Override
    public Color getColor() {
        return Color.red;
    }

    @Override
    public String getLabel() {
        return "AntiSurfer";
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    @Override
    public void logHit(Wave w, Point2D.Double hitLocation) {
        this.logHit(w, hitLocation, false);
    }

    public void logHit(Wave w, Point2D.Double hitLocation, boolean didHit) {
        BotState en;
        Bot bot;
        if (w.isRealWave && (bot = HeliosRadar.getBot(w.enName)) != null && (en = bot.currentState) != null) {
            GFData data = new GFData();
            data.guessFactor = w.guessFactor(hitLocation);
            data.weight = 1.0;
            if (didHit) {
                data.weight = -4.0;
            }
            data.treeWeight = 1.0;
            data.decayRate = 1.024;
            data.time = this._robot.getTime();
            bot.antiSurferGunModel.addPoint(this.dataPoint(w), data);
        }
    }

    public double[] dataPoint(Wave w) {
        double distance = w.myState.getPosition().distance(w.enState.getPosition());
        double accel = HUtils.accel(w.enState.latVel, w.prevEnState.latVel);
        return new double[]{distance / w.bulletVelocity() / 65.0, Math.abs(w.enState.latVel) / 8.0, (accel + 1.0) / 3.0, HUtils.limit(0.0, w.enDirChangeTime / 4.0, 30.0) / 30.0, w.enDist16 / 128.0, w.enMeaWallAhead, w.enMeaWallReverse};
    }

    public class Angle {
        public double angle;
        public double weight;
    }
}

