/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.utils.knn;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.WeightedManhattanDistanceFunction;
import catcat20.helios.utils.knn.KNNData;
import java.util.ArrayList;

public class KNNModel<T> {
    public KdTree<T> tree;
    public double treeWeights;
    public double[] weights;
    public DistanceFunction distanceFunction;

    public KNNModel(double[] weights) {
        this.distanceFunction = new WeightedManhattanDistanceFunction(weights);
        this.tree = new KdTree(weights.length);
        this.weights = weights;
    }

    public KNNModel(double[] weights, DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
        this.tree = new KdTree(weights.length);
        this.weights = weights;
    }

    public void addPoint(double[] dataPoint, T data) {
        this.tree.addPoint(dataPoint, (Object)data);
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(double[] dataPoint, int count) {
        NearestNeighborIterator<T> neighbors = this.tree.getNearestNeighborIterator(dataPoint, count, this.distanceFunction);
        ArrayList<KNNData<T>> list = new ArrayList<KNNData<T>>();
        for (T data : neighbors) {
            KNNData dataset = new KNNData();
            dataset.distance = neighbors.distance();
            dataset.data = data;
            list.add(dataset);
        }
        return list;
    }
}

