/*
 * Decompiled with CFR 0.152.
 */
package dk;

import dk.Base;
import dk.BattleField;
import dk.Enemy;
import dk.TargetSelector;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class EnemyController {
    private Map enemies = new HashMap(20);

    public void printStats(PrintStream out) {
        Collection list = this.enemies.values();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Enemy e = (Enemy)iter.next();
            out.println("-------");
            e.printStats(out);
        }
    }

    public Enemy getEnemy(String name) {
        Enemy enemy = (Enemy)this.enemies.get(name);
        if (enemy == null) {
            enemy = new Enemy(name);
            this.enemies.put(name, enemy);
        }
        return enemy;
    }

    public Collection getEnemies() {
        return this.enemies.values();
    }

    public Enemy findTarget(Base robot, TargetSelector strategy) {
        Collection list = this.enemies.values();
        Iterator iter = list.iterator();
        Enemy topEnemy = null;
        double topScore = -1000000.0;
        while (iter.hasNext()) {
            Enemy e = (Enemy)iter.next();
            if (!e.isAlive() || e.getPosition() == null) continue;
            double score = strategy.computeScore(robot, e);
            if (topEnemy != null && !(score > topScore)) continue;
            topEnemy = e;
            topScore = score;
        }
        return topEnemy;
    }

    public void reset() {
        Iterator iter = this.enemies.values().iterator();
        while (iter.hasNext()) {
            Enemy enemy = (Enemy)iter.next();
            enemy.reset();
        }
    }

    public void dump(PrintStream out) {
        Iterator iter = this.enemies.values().iterator();
        while (iter.hasNext()) {
            Enemy enemy = (Enemy)iter.next();
            out.println(enemy.toString());
        }
    }

    public void onRobotScannedEvent(Base robot, ScannedRobotEvent e) {
        String name = e.getName();
        Enemy enemy = this.getEnemy(name);
        enemy.onRobotScannedEvent(robot, e);
    }

    public void onRobotDeathEvent(Base robot, RobotDeathEvent e) {
        String name = e.getName();
        Enemy enemy = this.getEnemy(name);
        enemy.onRobotDeathEvent(robot, e);
    }

    public void onHitByBullet(Base robot, HitByBulletEvent e) {
        String name = e.getName();
        Enemy enemy = this.getEnemy(name);
        if (Base.traceHits) {
            BattleField.println("hit by " + name + " " + e.getBullet().getPower());
        }
        enemy.onHitByBullet(robot, e);
    }

    public void onBulletHit(Base robot, BulletHitEvent e) {
        String name = e.getName();
        Enemy enemy = this.getEnemy(name);
        if (Base.traceHits) {
            BattleField.println("hit " + name + " " + e.getBullet().getPower());
        }
        enemy.onBulletHit(robot, e);
    }
}

