/*
 * Decompiled with CFR 0.152.
 */
package rjw;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import robocode.AdvancedRobot;

public class Props {
    private Properties _props = new Properties();

    public Props(AdvancedRobot bot) {
        File file = bot.getDataFile(String.valueOf(bot.getName()) + ".properties");
        try {
            this._props.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            throw new RuntimeException();
        }
    }

    public String get(String key, String defaultValue) {
        String value = this._props.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this._props.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        String value = this._props.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value, 10);
            }
            catch (NumberFormatException ex) {
                System.out.println("Error reading property: " + key + ':');
                System.out.println("The value " + value + " cannot be parsed as an int.");
            }
        }
        return defaultValue;
    }

    public double getDouble(String key, double defaultValue) {
        String value = this._props.getProperty(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                System.out.println("Error reading property: " + key + ':');
                System.out.println("The value " + value + " cannot be parsed as a double.");
            }
        }
        return defaultValue;
    }
}

