/*
 * Decompiled with CFR 0.152.
 */
package kid.management;

import java.util.HashMap;
import java.util.Set;
import kid.cluster.Comparison;
import kid.data.Drawable;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.management.RobotManager;
import kid.robot.EnemyData;
import kid.robot.EnemyProfile;
import kid.robot.RobotData;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Event;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class ProfileManager
implements Drawable {
    private AdvancedRobot robot;
    private RobotManager robots;
    private static HashMap<String, EnemyProfile> profiles;
    private Comparison[] comparisons;

    public ProfileManager(AdvancedRobot myRobot, Comparison[] comparisons) {
        this.init(myRobot, comparisons);
    }

    private void init(AdvancedRobot r, Comparison[] c) {
        this.robot = r;
        this.robots = new RobotManager((Robot)r);
        this.comparisons = c;
        if (profiles == null) {
            profiles = new HashMap(r.getOthers());
        } else {
            Set<String> keys = profiles.keySet();
            for (String s : keys) {
                profiles.get(s).update(r);
            }
        }
    }

    public EnemyProfile getProfile(String name) {
        if (profiles.containsKey(name)) {
            return profiles.get(name);
        }
        return null;
    }

    public void fire(EnemyData target, Bullet b) {
        if (b != null) {
            this.fire(target, b.getPower());
        }
    }

    public void fire(EnemyData target, double power) {
        profiles.get(target.getName()).fire(power);
    }

    public void inEvent(Event e) {
        this.robots.inEvent(e);
        if (e instanceof ScannedRobotEvent) {
            this.handleScannedRobot((ScannedRobotEvent)e);
        }
    }

    private void handleScannedRobot(ScannedRobotEvent event) {
        if (!profiles.containsKey(event.getName())) {
            profiles.put(event.getName(), new EnemyProfile(this.robot, this.robots.getEnemy(event.getName()), this.comparisons));
        }
    }

    public void print() {
        RobotData[] robotDataArray = this.robots.getRobots();
        int n = robotDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            System.out.println(r.getName());
            profiles.get(r.getName()).print();
            ++n2;
        }
    }

    @Override
    public void draw(RGraphics grid) {
        if (DrawMenu.getValue("Waves", "Targeting")) {
            RobotData[] robotDataArray = this.robots.getRobots();
            int n = robotDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                RobotData r = robotDataArray[n2];
                profiles.get(r.getName()).draw(grid);
                ++n2;
            }
        }
    }
}

