/*
 * Decompiled with CFR 0.152.
 */
package kid.robot;

import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.io.Serializable;
import kid.data.Drawable;
import kid.data.Printable;
import kid.graphics.Colors;
import kid.graphics.RGraphics;
import kid.utils.Utils;
import robocode.RobocodeFileOutputStream;

public class RobotVector
implements Cloneable,
Serializable,
Printable,
Drawable {
    private static final long serialVersionUID = 7415604949876623460L;
    private double x;
    private double y;
    private double deltaX;
    private double deltaY;
    private double heading;
    private double velocity;
    private boolean updatedDeltaX = true;
    private boolean updatedDeltaY = true;
    private boolean updatedHeading = true;
    private boolean updatedVelocity = true;

    public RobotVector() {
        this.init(-1.0, -1.0, 0.0, 0.0);
    }

    public RobotVector(double heading, double velocity) {
        this.init(-1.0, -1.0, heading, velocity);
    }

    public RobotVector(double x, double y, double heading, double velocity) {
        this.init(x, y, heading, velocity);
    }

    public RobotVector(Point2D point, double heading, double velocity) {
        this.init(point.getX(), point.getY(), heading, velocity);
    }

    private RobotVector(RobotVector vector) {
        this.init(vector.getX(), vector.getY(), vector.getHeading(), vector.getVelocity());
    }

    private void init(double x, double y, double heading, double velocity) {
        this.x = x;
        this.y = y;
        this.deltaX = Utils.getDeltaX(velocity, heading);
        this.deltaY = Utils.getDeltaY(velocity, heading);
        this.heading = heading;
        this.velocity = velocity;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getDeltaX() {
        if (!this.updatedDeltaX) {
            this.deltaX = Utils.getDeltaX(this.getVelocity(), this.getHeading());
        }
        this.updatedDeltaX = true;
        return this.deltaX;
    }

    public double getDeltaY() {
        if (!this.updatedDeltaY) {
            this.deltaY = Utils.getDeltaY(this.getVelocity(), this.getHeading());
        }
        this.updatedDeltaY = true;
        return this.deltaY;
    }

    public double getHeading() {
        if (!this.updatedHeading) {
            this.heading = Utils.angle(0.0, 0.0, this.getDeltaX(), this.getDeltaY());
        }
        this.updatedHeading = true;
        return this.heading;
    }

    public double getVelocity() {
        if (!this.updatedVelocity) {
            this.velocity = Utils.dist(0.0, 0.0, this.getDeltaX(), this.getDeltaY());
        }
        this.updatedVelocity = true;
        return this.velocity;
    }

    public void add(RobotVector vector) {
        this.deltaX += vector.getDeltaX();
        this.deltaY += vector.getDeltaY();
        this.updatedHeading = false;
        this.updatedVelocity = false;
    }

    public void rotate(double turn) {
        this.heading = this.getHeading() + turn;
        this.updatedDeltaX = false;
        this.updatedDeltaY = false;
    }

    public void velocity(double newVelocity) {
        this.velocity = newVelocity;
        this.updatedDeltaX = false;
        this.updatedDeltaY = false;
    }

    public static void add(Point2D point, RobotVector vector) {
        point.setLocation(point.getX() + vector.getDeltaX(), point.getY() + vector.getDeltaY());
    }

    public RobotVector startNew() {
        return new RobotVector(this.getX() + this.getDeltaX(), this.getY() + this.getDeltaY(), this.getHeading(), 0.0);
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    @Override
    public void draw(RGraphics grid) {
        if (this.getX() > 0.0 && this.getY() > 0.0) {
            grid.setColor(Colors.DIRT_GREEN);
            grid.drawLine(this.getX(), this.getY(), this.getX() + this.getDeltaX(), this.getY() + this.getDeltaY());
        }
    }

    public Object clone() {
        return new RobotVector(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RobotVector) {
            RobotVector vector = (RobotVector)obj;
            return vector.getDeltaX() == this.getDeltaX() && vector.getDeltaY() == this.getDeltaY() && vector.getX() == this.getX() && vector.getY() == this.getY();
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    public void finalize() {
    }
}

