/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.ArrayList;
import java.util.List;
import morbid.BrokeredObject;
import morbid.IEnemyAnalyzer;
import morbid.IEnemySelectionStrategy;
import morbid.IEventListener;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.IStatsManager;
import morbid.Utils;
import robocode.Event;
import robocode.HitRobotEvent;

class MeleeEnemySelectionStrategy
extends BrokeredObject
implements IEventListener,
IEnemySelectionStrategy {
    private final int m_eventCutoffAge;
    private final double m_fieldWidth;
    private final double m_fieldHeight;
    private final double m_size;
    private final List m_hitRobotEvents = new ArrayList();
    private IRobotPositionManager.ITrackedRobot m_enemy;
    private static final Class[] ACCEPTABLE_EVENTS = new Class[]{class$robocode$HitRobotEvent == null ? (class$robocode$HitRobotEvent = MeleeEnemySelectionStrategy.class$("robocode.HitRobotEvent")) : class$robocode$HitRobotEvent};
    private static final long MAX_ENEMY_NOUPDATE_AGE = 20L;
    private static final double ENEMY_SLOW_WEIGHT = 0.5;
    private static final double ENEMY_AGGRESSION_WEIGHT = 4.0;
    private static final double ENEMY_DISTANCE_FACTOR = 2.0;
    private static final double ENEMY_CORNER_POSITION_WEIGHT = 0.5;
    private static final double ENEMY_BOUNDARY_POSITION_WEIGHT = 0.25;
    private static final double ENEMY_ENERGY_FACTOR = 2.0;
    private static final double ENEMY_HEADING_FACTOR = 0.5;
    private static final double ENEMY_COLLISION_WEIGHT = 2.0;
    private static final double ENEMY_ENERGY_THRESHOLD = 32.0;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$robocode$HitRobotEvent;

    public MeleeEnemySelectionStrategy(IRobotController controller) {
        super("ENEMY_STRATEGY", controller);
        this.m_size = Math.ceil(0.5 * Utils.relativeDistance(0.0, 0.0, this.m_robot.getWidth(), this.m_robot.getHeight()));
        this.m_fieldWidth = this.m_robot.getBattleFieldWidth();
        this.m_fieldHeight = this.m_robot.getBattleFieldHeight();
        this.m_eventCutoffAge = (int)(Utils.relativeDistance(0.0, 0.0, this.m_fieldWidth, this.m_fieldHeight) / Utils.bulletPowerToVelocity(3.0));
    }

    public Class[] getAcceptableEventTypes() {
        return ACCEPTABLE_EVENTS;
    }

    public void acceptEvent(Event event) {
        if (event instanceof HitRobotEvent) {
            this.m_hitRobotEvents.add(event);
        }
    }

    public IRobotPositionManager.ITrackedRobot selectEnemy() {
        long time = this.m_robot.getTime();
        if (!this.isUpdated()) {
            this.markAsUpdated();
            IRobotPositionManager robotPositionManager = this.m_controller.getRobotPositionManager();
            IRobotPositionManager.ITrackedRobot[] enemies = robotPositionManager.getKnownAliveObjects();
            if (enemies.length == 1) {
                this.m_enemy = enemies[0];
                return this.m_enemy;
            }
            double[] weights = new double[enemies.length];
            double[] distances = new double[enemies.length];
            double minDistance = Double.MAX_VALUE;
            double maxDistance = Double.NEGATIVE_INFINITY;
            int e = 0;
            while (e < enemies.length) {
                double distance;
                IRobotPositionManager.ITrackedRobot enemy = enemies[e];
                distances[e] = distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), enemy.getX(), enemy.getY());
                if (distance > maxDistance) {
                    maxDistance = distance;
                }
                if (distance < minDistance) {
                    minDistance = distance;
                }
                ++e;
            }
            double span = maxDistance - minDistance;
            if (span > 1.0) {
                int e2 = 0;
                while (e2 < enemies.length) {
                    double rf = 1.0 - (distances[e2] - minDistance) / span;
                    int n = e2++;
                    weights[n] = weights[n] + 2.0 * rf * rf;
                }
            }
            int e3 = 0;
            while (e3 < enemies.length) {
                IRobotPositionManager.ITrackedRobot enemy = enemies[e3];
                if (enemy.getEnergy() <= 32.0) {
                    int n = e3;
                    weights[n] = weights[n] + 2.0 * (1.0 - enemy.getEnergy() / 32.0);
                }
                ++e3;
            }
            IStatsManager.IStats stats = this.m_controller.getStatsManager().getCurrentStats();
            IStatsManager.IHitFact lastHit = this.m_controller.getStatsManager().getLastEnemyHit();
            if (lastHit != null) {
                int e4 = 0;
                while (e4 < enemies.length) {
                    IStatsManager.IHitFact[] facts;
                    IRobotPositionManager.ITrackedRobot enemy = enemies[e4];
                    if (enemy.getID().equals(lastHit.getSourceID())) {
                        int n = e4;
                        weights[n] = weights[n] + 4.0;
                    }
                    if ((facts = stats.getHitFacts(enemies[e4].getID(), this.m_robot.getName(), time - (long)this.m_eventCutoffAge)) != null) {
                        int n = e4;
                        weights[n] = weights[n] + 4.0 * (double)facts.length;
                    }
                    ++e4;
                }
            }
            if (this.m_controller.getWeaponManager().getTimeToGunCool() < 9) {
                double[] headings = new double[enemies.length];
                int e5 = 0;
                while (e5 < enemies.length) {
                    IRobotPositionManager.ITrackedRobot enemy = enemies[e5];
                    headings[e5] = Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), enemy.getX(), enemy.getY());
                    ++e5;
                }
                double gunHeading = this.m_robot.getGunHeadingRadians();
                int e6 = 0;
                while (e6 < enemies.length) {
                    int n = e6;
                    weights[n] = weights[n] + 0.5 * (1.0 - Math.abs(Utils.deltaPhi(gunHeading, headings[e6])) / Math.PI);
                    ++e6;
                }
            }
            int minHistory = 6;
            if (time >= 6L) {
                int e7 = 0;
                while (e7 < enemies.length) {
                    block32: {
                        IRobotPositionManager.ITrackedRobot enemy = enemies[e7];
                        IRobotPositionManager.ITrackedRobotTimeSeries series = enemy.getRobotTimeSeries();
                        if (series.size() >= 6 && time - series.getPoint(5).getUpdateTime() < (long)this.m_eventCutoffAge) {
                            int p = 0;
                            while (p < 6) {
                                if (!(Math.abs(series.getPoint(p).getVelocity()) > 1.0)) {
                                    ++p;
                                    continue;
                                }
                                break block32;
                            }
                            int n = e7;
                            weights[n] = weights[n] + 0.5;
                        }
                    }
                    ++e7;
                }
            }
            int ev = 0;
            while (ev < this.m_hitRobotEvents.size()) {
                HitRobotEvent event = (HitRobotEvent)this.m_hitRobotEvents.remove(ev);
                String enemyID = event.getName();
                int e8 = 0;
                while (e8 < enemies.length) {
                    IRobotPositionManager.ITrackedRobot enemy = enemies[e8];
                    if (enemyID.equals(enemy.getID())) {
                        int n = e8;
                        weights[n] = weights[n] + 2.0;
                    }
                    ++e8;
                }
                ++ev;
            }
            double gap = 4.0 * this.m_size;
            int e9 = 0;
            while (e9 < enemies.length) {
                double enemyY;
                IRobotPositionManager.ITrackedRobot enemy = enemies[e9];
                double enemyX = enemy.getX();
                if (Utils.inTheCorner(enemyX, enemyY = enemy.getY(), gap, this.m_fieldWidth, this.m_fieldHeight)) {
                    int n = e9;
                    weights[n] = weights[n] + 0.5;
                } else if (Utils.onTheBoundary(enemyX, enemyY, gap, this.m_fieldWidth, this.m_fieldHeight)) {
                    int n = e9;
                    weights[n] = weights[n] + 0.25;
                }
                ++e9;
            }
            IEnemyAnalyzer enemyAnalyzer = this.m_controller.getEnemyAnalyzer();
            int e10 = 0;
            while (e10 < enemies.length) {
                IRobotPositionManager.ITrackedRobot enemy = enemies[e10];
                IEnemyAnalyzer.EnemyStrategyCollateral collateral = enemyAnalyzer.getEnemyStrategyCollateral(enemy.getID());
                if (collateral != null) {
                    int n = e10;
                    weights[n] = weights[n] + collateral.m_sw;
                }
                ++e10;
            }
            double maxWeight = Double.NEGATIVE_INFINITY;
            e = 0;
            while (e < enemies.length) {
                if (weights[e] > maxWeight) {
                    maxWeight = weights[e];
                    this.m_enemy = enemies[e];
                }
                ++e;
            }
        }
        return this.m_enemy;
    }

    protected void activate() {
        super.activate();
        this.m_enemy = null;
    }

    protected void passivate() {
        this.m_enemy = null;
        this.m_hitRobotEvents.clear();
        super.passivate();
    }

    protected double bid() {
        IRobotPositionManager robotPositionManager = this.m_controller.getRobotPositionManager();
        return robotPositionManager.getKnownAliveObjectCount() > 0 ? (double)robotPositionManager.getKnownAliveObjectCount() : Double.NEGATIVE_INFINITY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

