/*
 * Decompiled with CFR 0.152.
 */
package cuoq.movement;

import cuoq.Utils;
import java.awt.geom.Point2D;
import robocode.Rules;

public class MovementWave {
    double bulletPower;
    double headsOnHeading;
    double velocity;
    int direction;
    Point2D.Double origin;
    Point2D.Double destination;
    long fireTime;

    public MovementWave(Point2D.Double origin, Point2D.Double dest, double velocity, double bulletPower, long fireTime, int direction) {
        this.bulletPower = bulletPower;
        this.fireTime = fireTime - 1L;
        this.origin = origin;
        this.velocity = velocity;
        this.destination = dest;
        this.direction = direction > 0 ? 1 : -1;
        this.headsOnHeading = Utils.angleBetweenPoints(origin, dest);
    }

    public double getBulletPower() {
        return this.bulletPower;
    }

    public double getHeadsOnHeading() {
        return this.headsOnHeading;
    }

    public Point2D.Double getOrigin() {
        return this.origin;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public Point2D.Double getDestination() {
        return this.destination;
    }

    public long getFireTime() {
        return this.fireTime;
    }

    public int getDirection() {
        return this.direction;
    }

    public double getDistance(long time) {
        return (double)(time - this.fireTime) * Rules.getBulletSpeed((double)this.bulletPower);
    }
}

