/*
 * Decompiled with CFR 0.152.
 */
package tex;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class EnemyLocation
extends Point2D {
    Point2D.Double myLocation;
    Point2D.Double myDirection;
    double mySpeed;
    long myTime;

    public EnemyLocation(ScannedRobotEvent event, AdvancedRobot bot) {
        double myLastSeenEnemyDirection = event.getBearingRadians() + bot.getHeadingRadians();
        this.setLocation(bot.getX() + event.getDistance() * Math.cos(1.5707963267948966 - myLastSeenEnemyDirection), bot.getY() + event.getDistance() * Math.sin(1.5707963267948966 - myLastSeenEnemyDirection));
        this.setDirection(Math.cos(1.5707963267948966 - event.getHeadingRadians()), Math.sin(1.5707963267948966 - event.getHeadingRadians()));
        this.setSpeed(event.getVelocity());
        this.myTime = bot.getTime();
    }

    @Override
    public double getX() {
        return this.myLocation.getX();
    }

    @Override
    public double getY() {
        return this.myLocation.getY();
    }

    public double getdX() {
        return this.myDirection.getX() * this.mySpeed;
    }

    public double getdY() {
        return this.myDirection.getY() * this.mySpeed;
    }

    public double getDirection(AdvancedRobot bot) {
        return Math.atan2(this.myLocation.getY() - bot.getY(), this.myLocation.getX() - bot.getX());
    }

    public double getDistanceSqr(Point2D point) {
        double x = this.myLocation.getX() - point.getX();
        double y = this.myLocation.getY() - point.getY();
        return x * x + y * y;
    }

    public void setLocation(Point2D.Double p) {
        this.myLocation = p;
    }

    @Override
    public void setLocation(double arg0, double arg1) {
        this.myLocation = new Point2D.Double(arg0, arg1);
    }

    public void setDirection(double x, double y) {
        this.myDirection = new Point2D.Double(x, y);
    }

    public void setDirection(Point2D.Double directionVector) {
        this.myDirection = directionVector;
    }

    public void setSpeed(double v) {
        this.mySpeed = v;
    }

    public long getTime() {
        return this.myTime;
    }
}

