/*
 * Decompiled with CFR 0.152.
 */
package sqTank.util;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Wave {
    public double linePreDiffAngle;
    public double distance;
    public double distanceToCenter;
    public Point2D.Double startPoint;
    public long startTime;
    public double absBearing;
    public double velocity;
    public double power;
    public boolean enable = true;
    public double gunHeading = 0.0;
    public double willHitDiffAngle;
    public boolean hit = false;

    public Wave(Point2D.Double startPoint, double power, long time, double bearing, double dist, double lpda, double distanceToCenter) {
        this.velocity = 20.0 - power * 3.0;
        if (power == 0.0) {
            this.velocity = 11.0;
        }
        this.power = power;
        this.absBearing = bearing;
        this.distance = dist / 90.0;
        this.linePreDiffAngle = lpda;
        this.distanceToCenter = distanceToCenter / 75.0;
        this.startPoint = startPoint;
        this.startTime = time;
        this.enable = true;
        this.willHitDiffAngle = 360.0;
    }

    public static double getComVal(Object o, Object o2, double dir) {
        Wave curWave = (Wave)o;
        Wave comWave = (Wave)o2;
        return Point2D.distanceSq(curWave.linePreDiffAngle, curWave.distance, comWave.linePreDiffAngle * dir, comWave.distance) + Math.pow(curWave.distanceToCenter - comWave.distanceToCenter, 2.0);
    }

    public void test(Point2D.Double enemyPoint, long time) {
        if (this.willHitDiffAngle == 360.0) {
            double dist = enemyPoint.distance(this.startPoint);
            double travel = this.velocity * (double)(time - this.startTime);
            if (travel < 0.0) {
                this.willHitDiffAngle = 20.0;
            } else if (Math.abs(dist - travel) < 18.0) {
                this.willHitDiffAngle = Utils.normalRelativeAngle((double)(Wave.getAngle(enemyPoint, this.startPoint) - this.absBearing));
                this.velocity = dist;
                this.hit = true;
            }
        }
    }

    public static double getAngle(Point2D.Double p2, Point2D.Double p1) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }

    public void clean(long time) {
        if (!this.enable) {
            return;
        }
        double travel = this.velocity * (double)(time - this.startTime);
        if (travel >= 1600.0) {
            this.enable = false;
        }
    }
}

