/*
 * Decompiled with CFR 0.152.
 */
package kdf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class KoulDestroyer
extends AdvancedRobot {
    static final int LOTS = 99999;
    static final int SOFT_WALL = 80;
    private int safeX = 0;
    private int safeY = 0;
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int eastWall;
    private int westWall;
    private int northWall;
    private int southWall;
    private double lastAvoided = 0.0;
    TurnCompleteCondition turnCheck = null;
    RadarTurnCompleteCondition radarCheck = null;
    ScanState defaultScanState = ScanState.UPDATE;
    ScanState scanState;
    MoveState moveState;
    boolean isForward;
    int rotDir;
    Random rand;
    static Hashtable<String, HitRate> hitRate = null;
    Hashtable<String, Bot> enemies = null;
    Bot target = null;
    double distNorm;
    double distWeight = 10.0;
    double energyNorm = 150.0;
    double energyWeight = 5.0;
    double hitRateWeight = 10.0;
    double bearingNorm = 180.0;
    double bearingWeight = 0.5;
    double threatNorm = 6.0;
    double threatWeight = 2.0;
    double alpha = 0.99;
    int scanCount = 0;
    int scanfieldHeight = 0;
    int scanfieldWidth = 0;
    double[][] scanfield;

    public void run() {
        this.distNorm = Math.sqrt(Math.pow(this.getBattleFieldHeight(), 2.0) + Math.pow(this.getBattleFieldWidth(), 2.0));
        this.scanfieldWidth = (int)Math.ceil(this.getBattleFieldWidth() / 36.0);
        this.scanfieldHeight = (int)Math.ceil(this.getBattleFieldHeight() / 36.0);
        this.scanfield = new double[this.scanfieldHeight][this.scanfieldWidth];
        this.rand = new Random();
        if (hitRate == null) {
            try (Iterator<Bot> iterator = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getDataFile("hitRate.dat"))));){
                hitRate = (Hashtable)((ObjectInputStream)((Object)iterator)).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                System.out.println("Could not load hitRate");
                hitRate = new Hashtable();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.out.println("Could not load hitRate");
                hitRate = new Hashtable();
            }
        }
        this.enemies = new Hashtable();
        this.target = null;
        this.scanState = ScanState.UPDATE;
        this.moveState = MoveState.AVOID;
        this.isForward = true;
        this.setColors(new Color(0, 150, 0), Color.red, Color.white, Color.green, new Color(200, 255, 200));
        this.rotDir = this.rand.nextBoolean() ? 1 : -1;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvent(new Condition("northwall"){

            public boolean test() {
                return KoulDestroyer.this.getY() >= (double)KoulDestroyer.this.northWall;
            }
        });
        this.addCustomEvent(new Condition("southwall"){

            public boolean test() {
                return KoulDestroyer.this.getY() <= (double)KoulDestroyer.this.southWall;
            }
        });
        this.addCustomEvent(new Condition("westwall"){

            public boolean test() {
                return KoulDestroyer.this.getX() <= (double)KoulDestroyer.this.westWall;
            }
        });
        this.addCustomEvent(new Condition("eastwall"){

            public boolean test() {
                return KoulDestroyer.this.getX() >= (double)KoulDestroyer.this.eastWall;
            }
        });
        if (this.getOthers() < 2) {
            this.moveState = MoveState.RAM;
            this.scanState = this.defaultScanState = ScanState.START_FIELD;
        }
        while (true) {
            int n;
            int n2;
            switch (this.scanState) {
                case START_FIELD: {
                    this.northWall = (int)this.getBattleFieldHeight() - 80;
                    this.southWall = 80;
                    this.eastWall = (int)this.getBattleFieldWidth() - 80;
                    this.westWall = 80;
                    this.setTurnRadarRight(360 * this.rotDir);
                    this.scanState = ScanState.FIELD;
                    this.radarCheck = new RadarTurnCompleteCondition((AdvancedRobot)this);
                    System.out.println("Starting Scan");
                    break;
                }
                case FIELD: {
                    System.out.println("Scanning");
                    if (!this.radarCheck.test()) break;
                    this.scanState = ScanState.TARGET;
                    this.selectTarget();
                    System.out.println("Scan Complete");
                    break;
                }
                case TARGET: {
                    if (this.target == null) {
                        this.scanState = ScanState.START_FIELD;
                        break;
                    }
                    this.setTurnRadarRight(this.target.bearingFromRadar);
                    this.target.updateBearings();
                    this.tryFire(this.target);
                    break;
                }
                case UPDATE: {
                    if (this.target == null && this.getTime() > 6L) {
                        this.selectTarget();
                    }
                    if (this.getTime() % 6L == 0L) {
                        this.scanfield = new double[this.scanfieldHeight][this.scanfieldWidth];
                        this.minX = 999999;
                        this.minY = 999999;
                        this.maxX = -1;
                        this.maxY = -1;
                        for (Bot bot : this.enemies.values()) {
                            n2 = (int)bot.x / 36;
                            n = (int)bot.y / 36;
                            if (n2 < this.minX) {
                                this.minX = n2;
                            }
                            if (n < this.minY) {
                                this.minY = n;
                            }
                            if (n2 > this.maxX) {
                                this.maxX = n2;
                            }
                            if (n > this.maxY) {
                                this.maxY = n;
                            }
                            for (int i = 0; i < this.scanfieldHeight; ++i) {
                                int n3 = 0;
                                while (n3 < this.scanfieldWidth) {
                                    double[] dArray = this.scanfield[i];
                                    int n4 = n3;
                                    dArray[n4] = dArray[n4] + Math.pow(this.scanfieldWidth - Math.abs(n2 - n3), 2.0);
                                    double[] dArray2 = this.scanfield[i];
                                    int n5 = n3++;
                                    dArray2[n5] = dArray2[n5] + Math.pow(this.scanfieldHeight - Math.abs(n - i), 2.0);
                                }
                            }
                        }
                        this.maxX = this.scanfieldWidth - this.maxX;
                        this.maxY = this.scanfieldHeight - this.maxY;
                    }
                    int n6 = (int)this.getX() / 36;
                    int n7 = (int)this.getY() / 36;
                    this.northWall = (int)this.getBattleFieldHeight() - 80;
                    this.southWall = 80;
                    this.eastWall = (int)this.getBattleFieldWidth() - 80;
                    this.westWall = 80;
                    if (n6 < this.minX && this.minX > 3) {
                        this.eastWall = (this.minX - 2) * 36;
                    } else if (this.scanfieldWidth - n6 < this.maxX && this.maxX > 3) {
                        this.westWall = (this.scanfieldWidth - this.maxX + 2) * 36;
                    } else if (n7 < this.minY && this.minY > 3) {
                        this.northWall = (this.minY - 2) * 36;
                    } else if (this.scanfieldHeight - n7 < this.maxY && this.maxY > 3) {
                        this.southWall = (this.scanfieldHeight - this.maxY + 2) * 36;
                    } else if (this.minX >= this.maxX && this.minX >= this.maxY && this.minX >= this.minY) {
                        if (this.minX > 6) {
                            this.eastWall = (this.minX - 2) * 36;
                        }
                    } else if (this.maxX >= this.minX && this.maxX >= this.maxY && this.maxX >= this.minY) {
                        if (this.maxX > 6) {
                            this.westWall = (this.scanfieldWidth - this.maxX - 2) * 36;
                        }
                    } else if (this.minY >= this.maxY && this.minY >= this.maxX && this.minY >= this.minX) {
                        if (this.minY > 6) {
                            this.northWall = (this.minY - 2) * 36;
                        }
                    } else if (this.maxY >= this.minY && this.maxY >= this.maxX && this.maxY >= this.minX && this.maxY > 6) {
                        this.southWall = (this.scanfieldHeight - this.maxY - 2) * 36;
                    }
                    n2 = 720;
                    n = -360;
                    boolean bl = false;
                    if (n6 > this.scanfieldWidth - 5) {
                        bl = true;
                        n2 = 370;
                        n = 170;
                    } else if (n6 < 4) {
                        bl = true;
                        n2 = 190;
                        n = -10;
                    }
                    if (n7 > this.scanfieldHeight - 5) {
                        bl = true;
                        if (290 < n2) {
                            n2 = 290;
                        }
                        if (80 > n) {
                            n = 80;
                        }
                    } else if (n7 < 4) {
                        bl = true;
                        if (100 < n2) {
                            n2 = 100;
                        }
                        if (260 > n) {
                            n = 260;
                        }
                    }
                    n2 = n2 > 360 ? n2 - 360 : n2;
                    n = n < 0 ? n + 360 : n;
                    double d = this.getRadarHeading();
                    if (bl) {
                        if (n2 > n) {
                            if (d > (double)n2 || d < (double)n) {
                                if (d < (double)n) {
                                    d += 360.0;
                                }
                                this.rotDir = d - (double)n2 - ((double)(n + 360) - d) > 0.0 ? 1 : -1;
                            }
                        } else if (d > (double)n2 && d < (double)n) {
                            this.rotDir = d - (double)n2 - ((double)n - d) > 0.0 ? 1 : -1;
                        }
                        System.out.println("RadarHeading: " + Double.toString(d));
                        System.out.println("clockwiseBound: " + Double.toString(n2));
                        System.out.println("counterClockBound: " + Double.toString(n));
                        System.out.println("rotDir: " + Double.toString(this.rotDir));
                    }
                    this.setTurnRadarRight(360 * this.rotDir);
                    if (this.target == null) break;
                    this.target.updateBearings();
                    this.tryFire(this.target);
                }
            }
            switch (this.moveState) {
                case START_RAND1: {
                    this.setBodyColor(new Color(0, 150, 0));
                    this.setAhead(99999.0);
                    this.isForward = true;
                    this.setTurnRight(this.rand.nextInt(30) + 40);
                    this.turnCheck = new TurnCompleteCondition((AdvancedRobot)this);
                    this.moveState = MoveState.RAND1;
                    break;
                }
                case START_RAND2: {
                    this.setTurnLeft(this.rand.nextInt(30) + 40);
                    this.turnCheck = new TurnCompleteCondition((AdvancedRobot)this);
                    this.moveState = MoveState.RAND2;
                    break;
                }
                case START_RAND3: {
                    this.setTurnRight(this.rand.nextInt(30) + 40);
                    this.turnCheck = new TurnCompleteCondition((AdvancedRobot)this);
                    this.moveState = MoveState.RAND3;
                    break;
                }
                case RAND1: 
                case RAND2: 
                case RAND3: {
                    if (!this.turnCheck.test()) break;
                    this.moveState = MoveState.values()[this.moveState.ordinal() + 1];
                    this.turnCheck = null;
                    break;
                }
                case RAM: {
                    if (this.target != null && this.target.energy * 1.5 + 20.0 < this.getEnergy()) {
                        this.setBodyColor(new Color(150, 0, 0));
                        this.turnCheck = null;
                        this.goTo(this.target.predBearingFromSelf, this.target.distance);
                        break;
                    }
                    if (this.turnCheck != null && !this.turnCheck.test()) break;
                    this.setBodyColor(new Color(150, 150, 0));
                    if (this.isForward) {
                        this.setAhead(99999.0);
                    } else {
                        this.setBack(99999.0);
                    }
                    if (this.rand.nextBoolean()) {
                        this.setTurnRight(this.rand.nextInt(45) + 45);
                    } else {
                        this.setTurnLeft(this.rand.nextInt(45) + 45);
                    }
                    this.turnCheck = new TurnCompleteCondition((AdvancedRobot)this);
                    break;
                }
                case WALL: {
                    if (this.turnCheck == null || !this.turnCheck.test()) break;
                    this.turnCheck = null;
                    if (this.isForward) {
                        this.setAhead(99999.0);
                        break;
                    }
                    this.setBack(99999.0);
                    break;
                }
                case AVOID: {
                    this.setBodyColor(new Color(0, 150, 150));
                    if ((double)this.getTime() - this.lastAvoided > 40.0) {
                        this.lastAvoided = this.getTime();
                    }
                    double d = Double.MAX_VALUE;
                    n2 = (int)this.getX() / 36;
                    n = (int)this.getY() / 36;
                    for (int i = 2; i < this.scanfieldHeight - 2; ++i) {
                        for (int j = 2; j < this.scanfieldWidth - 2; ++j) {
                            if (!(this.scanfield[i][j] < d)) continue;
                            d = this.scanfield[i][j];
                            this.safeX = j;
                            this.safeY = i;
                        }
                    }
                    this.safeX *= 36;
                    this.safeX += 18;
                    this.safeY *= 36;
                    this.safeY += 18;
                    double d2 = this.getAsBearing(this.safeX, this.safeY) - this.getHeading();
                    System.out.println("Bearing:" + Double.toString(d2));
                    double d3 = this.getDistance(this.safeX, this.safeY);
                    if (this.getTime() > 5L) {
                        this.goTo(Utils.normalRelativeAngleDegrees((double)d2), d3);
                    }
                    if (!(d3 < 36.0) && !((double)this.getTime() - this.lastAvoided > 24.0)) break;
                    this.moveState = MoveState.START_RAND1;
                }
            }
            for (Bot bot : this.enemies.values()) {
                bot.threatLevel *= this.alpha;
            }
            this.execute();
        }
    }

    private void selectTarget() {
        double d = 9.99999999E8;
        System.out.println("Selecting Target");
        for (Bot bot : this.enemies.values()) {
            double d2;
            if ((double)this.getTime() - bot.age > 10.0 || !((d2 = this.distWeight * bot.distance / this.distNorm + this.energyWeight * bot.energy / this.energyNorm + this.hitRateWeight * (1.0 - bot.hitRate) + this.bearingWeight * bot.predBearingFromGun / this.bearingNorm + this.threatWeight * (1.0 - bot.threatLevel / this.threatNorm)) < d)) continue;
            d = d2;
            this.target = bot;
        }
        if (this.target != null) {
            System.out.println("Selected Target:" + this.target.name);
            this.target.updateBearings();
        }
    }

    private void tryFire(Bot bot) {
        if (bot != null) {
            System.out.println("Targeting Degrees to lock:" + Double.toString(bot.predBearingFromGun));
            if ((double)(this.getTime() - 10L) > bot.age) {
                System.out.println("Target Lost");
                this.scanState = this.defaultScanState;
                if (bot == this.target) {
                    this.target = null;
                }
            } else {
                this.setTurnGunRight(bot.predBearingFromGun);
                if (Math.abs(bot.predBearingFromGun) < Math.max(Math.min(1.0 / bot.hitRate, 20.0), 1.5)) {
                    System.out.println("Target locked");
                    if (this.getGunHeat() == 0.0 && this.getEnergy() > bot.firePower * 1.5) {
                        if (this.target != bot) {
                            System.out.println("Cheap Shot");
                        }
                        System.out.println("Firing Strength:" + Double.toString(bot.firePower));
                        this.setFire(bot.firePower);
                        HitRate hitRate = KoulDestroyer.hitRate.get(bot.name);
                        if (hitRate != null) {
                            hitRate.incShots();
                        } else {
                            hitRate = new HitRate();
                            hitRate.incShots();
                        }
                        KoulDestroyer.hitRate.put(bot.name, hitRate);
                        this.selectTarget();
                    }
                }
            }
        }
    }

    private void goTo(double d, double d2) {
        if (d > 90.0) {
            this.setTurnLeft(180.0 - d);
            this.setBack(d2);
            this.isForward = false;
        } else if (d < -90.0) {
            this.setTurnLeft(180.0 + d);
            this.setBack(d2);
            this.isForward = false;
        } else {
            this.setTurnRight(d);
            this.setAhead(d2);
            this.isForward = true;
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        if (scannedRobotEvent.isSentryRobot()) {
            return;
        }
        Bot bot = this.enemies.get(scannedRobotEvent.getName());
        if (bot == null) {
            bot = new Bot();
            bot.name = scannedRobotEvent.getName();
            bot.age = -1.0;
        }
        bot.yawRate = Utils.normalRelativeAngleDegrees((double)(scannedRobotEvent.getHeading() - bot.heading)) / ((double)this.getTime() - bot.age);
        bot.distance = scannedRobotEvent.getDistance();
        bot.energy = scannedRobotEvent.getEnergy();
        bot.heading = scannedRobotEvent.getHeading();
        bot.velocity = scannedRobotEvent.getVelocity();
        bot.age = this.getTime();
        HitRate hitRate = KoulDestroyer.hitRate.get(scannedRobotEvent.getName());
        bot.hitRate = hitRate == null ? 1.0 : hitRate.getRate();
        double d = this.getHeading() + scannedRobotEvent.getBearing();
        bot.bearingFromSelf = Utils.normalRelativeAngleDegrees((double)scannedRobotEvent.getBearing());
        bot.bearingFromGun = Utils.normalRelativeAngleDegrees((double)(d - this.getGunHeading()));
        bot.bearingFromRadar = Utils.normalRelativeAngleDegrees((double)(d - this.getRadarHeading()));
        bot.x = this.getX() + bot.distance * Math.sin(Math.toRadians(d));
        bot.y = this.getY() + bot.distance * Math.cos(Math.toRadians(d));
        bot.firePower = Math.min(3.0, 1.0 + (3.0 * bot.hitRate + 1.0 * (1.0 - bot.distance / this.distNorm)));
        System.out.println("YawRate:" + Double.toString(bot.yawRate));
        if (Math.abs(bot.yawRate) > 0.0) {
            this.predCircularMotion(bot);
        } else {
            this.predLinearMotion(bot);
        }
        if (bot.predX < 16.0) {
            bot.predX = 16.0;
        }
        if (bot.predX > this.getBattleFieldWidth() - 16.0) {
            bot.predX = this.getBattleFieldWidth() - 16.0;
        }
        if (bot.predY < 16.0) {
            bot.predY = 16.0;
        }
        if (bot.predY > this.getBattleFieldHeight() - 16.0) {
            bot.predY = this.getBattleFieldHeight() - 16.0;
        }
        double d2 = this.getAsBearing(bot.predX, bot.predY);
        bot.predBearingFromGun = Utils.normalRelativeAngleDegrees((double)(d2 - this.getGunHeading()));
        this.enemies.put(bot.name, bot);
        if (bot == this.target || this.target == null && Math.abs(bot.predBearingFromGun) < 2.0) {
            this.tryFire(bot);
        }
    }

    public void predCircularMotion(Bot bot) {
        double d = 20.0 - 3.0 * bot.firePower;
        int n = (int)(bot.distance / d + 0.5);
        double d2 = bot.velocity / Math.toRadians(bot.yawRate);
        System.out.println("radius:" + Double.toString(d2));
        for (int i = 0; i < 4; ++i) {
            double d3 = Utils.normalRelativeAngleDegrees((double)(bot.heading + bot.yawRate * (double)n));
            bot.predX = bot.x + Math.cos(Math.toRadians(bot.heading)) * d2 - Math.cos(Math.toRadians(d3)) * d2;
            bot.predY = bot.y + Math.sin(Math.toRadians(d3)) * d2 - Math.sin(Math.toRadians(bot.heading)) * d2;
            double d4 = this.getDistance(bot.predX, bot.predY);
            n = (int)(d4 / d + 0.5);
        }
    }

    public void predLinearMotion(Bot bot) {
        double d = bot.velocity * Math.sin(Math.toRadians(bot.heading));
        double d2 = bot.velocity * Math.cos(Math.toRadians(bot.heading));
        double d3 = 20.0 - 3.0 * bot.firePower;
        int n = (int)(bot.distance / d3 + 0.5);
        bot.predX = d * (double)n + bot.x;
        bot.predY = d2 * (double)n + bot.y;
        double d4 = bot.distance;
        double d5 = this.getDistance(bot.predX, bot.predY);
        for (int i = 0; i < 4 && Math.abs(d5 - d4) > 10.0; ++i) {
            n = (int)(d5 / d3 + 0.5);
            bot.predX = d * (double)n + bot.x;
            bot.predY = d2 * (double)n + bot.y;
            d4 = d5;
            d5 = this.getDistance(bot.predX, bot.predY);
        }
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this.enemies.remove(robotDeathEvent.getName());
        if (this.target != null && robotDeathEvent.getName().equals(this.target.name)) {
            this.target = null;
            this.scanState = this.defaultScanState;
        }
        if (this.moveState == MoveState.AVOID && this.getOthers() < 4) {
            this.moveState = MoveState.START_RAND1;
        }
        if (this.getOthers() < 2) {
            this.moveState = MoveState.RAM;
            this.scanState = this.defaultScanState = ScanState.START_FIELD;
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        double d = hitWallEvent.getBearing();
        if (this.isForward) {
            if (d < 90.0 && d > -90.0) {
                this.reverse();
            } else {
                this.setAhead(99999.0);
            }
        } else if (d > 90.0 || d < -90.0) {
            this.reverse();
        } else {
            this.setBack(99999.0);
        }
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        Bot bot;
        if (hitRobotEvent.isMyFault()) {
            this.reverse();
        }
        if (this.moveState == MoveState.AVOID) {
            this.moveState = MoveState.START_RAND1;
        }
        if ((bot = this.enemies.get(hitRobotEvent.getName())) == null) {
            bot = new Bot();
            bot.name = hitRobotEvent.getName();
        }
        bot.distance = 30.0;
        bot.energy = hitRobotEvent.getEnergy();
        bot.velocity = 0.0;
        bot.age = this.getTime();
        HitRate hitRate = KoulDestroyer.hitRate.get(hitRobotEvent.getName());
        bot.hitRate = hitRate == null ? 1.0 : hitRate.getRate();
        bot.firePower = 3.0;
        bot.threatLevel += 3.0;
        double d = this.getHeading() + hitRobotEvent.getBearing();
        bot.bearingFromGun = Utils.normalRelativeAngleDegrees((double)(d - this.getGunHeading()));
        bot.bearingFromRadar = Utils.normalRelativeAngleDegrees((double)(d - this.getRadarHeading()));
        bot.x = this.getX() + bot.distance * Math.sin(Math.toRadians(d));
        bot.y = this.getY() + bot.distance * Math.cos(Math.toRadians(d));
        bot.predX = bot.x;
        bot.predY = bot.y;
        if (bot.predX < 16.0) {
            bot.predX = 16.0;
        }
        if (bot.predX > this.getBattleFieldWidth() - 16.0) {
            bot.predX = this.getBattleFieldWidth() - 16.0;
        }
        if (bot.predY < 16.0) {
            bot.predY = 16.0;
        }
        if (bot.predY > this.getBattleFieldHeight() - 16.0) {
            bot.predY = this.getBattleFieldHeight() - 16.0;
        }
        bot.predBearingFromGun = bot.bearingFromGun;
        this.enemies.put(bot.name, bot);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        Bot bot = this.enemies.get(hitByBulletEvent.getName());
        if (bot == null) {
            return;
        }
        bot.threatLevel += 1.0;
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        HitRate hitRate = KoulDestroyer.hitRate.get(bulletHitEvent.getName());
        if (hitRate != null) {
            hitRate.incHits();
        } else {
            hitRate = new HitRate();
            hitRate.incHits();
        }
        KoulDestroyer.hitRate.put(bulletHitEvent.getName(), hitRate);
    }

    public void onCustomEvent(CustomEvent customEvent) {
        double d = this.getHeading();
        if (!this.isForward) {
            d = (d + 180.0) % 360.0;
        }
        if (customEvent.getCondition().getName().equals("northwall")) {
            if (d > 315.0 || d < 45.0) {
                this.reverse();
            } else if (d > 45.0 && d < 90.0) {
                this.setTurnRight(45.0);
            } else if (d < 315.0 && d > 270.0) {
                this.setTurnLeft(45.0);
            }
        } else if (customEvent.getCondition().getName().equals("southwall")) {
            if (d > 135.0 && d < 225.0) {
                this.reverse();
            } else if (d < 135.0 && d > 90.0) {
                this.setTurnLeft(45.0);
            } else if (d > 225.0 && d < 270.0) {
                this.setTurnRight(45.0);
            }
        } else if (customEvent.getCondition().getName().equals("westwall")) {
            if (d > 225.0 && d < 315.0) {
                this.reverse();
            } else if (d < 225.0 && d > 180.0) {
                this.setTurnLeft(45.0);
            } else if (d > 315.0) {
                this.setTurnRight(45.0);
            }
        } else if (customEvent.getCondition().getName().equals("eastwall")) {
            if (d > 45.0 && d < 135.0) {
                this.reverse();
            } else if (d < 45.0) {
                this.setTurnLeft(45.0);
            } else if (d > 135.0 && d < 180.0) {
                this.setTurnRight(45.0);
            }
        }
    }

    public void onPaint(Graphics2D graphics2D) {
        if (this.target != null) {
            graphics2D.setColor(new Color(255, 0, 0, 127));
            graphics2D.fillOval((int)(this.target.x - 10.0), (int)(this.target.y - 10.0), 20, 20);
            graphics2D.drawLine((int)this.target.x, (int)this.target.y, (int)this.target.predX, (int)this.target.predY);
            graphics2D.fillOval((int)(this.target.predX - 5.0), (int)(this.target.predY - 5.0), 10, 10);
        }
        if (this.moveState == MoveState.AVOID) {
            graphics2D.setColor(new Color(0, 255, 0, 127));
            graphics2D.fillOval(this.safeX - 10, this.safeY - 10, 20, 20);
            graphics2D.drawLine((int)this.getX(), (int)this.getY(), this.safeX, this.safeY);
        }
        graphics2D.setColor(Color.RED);
        graphics2D.drawLine(this.eastWall, 0, this.eastWall, (int)this.getBattleFieldHeight());
        graphics2D.setColor(Color.GREEN);
        graphics2D.drawLine(this.westWall, 0, this.westWall, (int)this.getBattleFieldHeight());
        graphics2D.setColor(Color.RED);
        graphics2D.drawLine(0, this.northWall, (int)this.getBattleFieldWidth(), this.northWall);
        graphics2D.setColor(Color.GREEN);
        graphics2D.drawLine(0, this.southWall, (int)this.getBattleFieldWidth(), this.southWall);
    }

    public void reverse() {
        if (this.isForward) {
            this.setBack(99999.0);
        } else {
            this.setAhead(99999.0);
        }
        this.isForward = !this.isForward;
    }

    public double getAsBearing(double d, double d2) {
        double d3;
        double d4;
        double d5 = this.getX();
        double d6 = d - d5;
        double d7 = Math.atan2(d6, d4 = d2 - (d3 = this.getY()));
        if (d7 < 0.0) {
            d7 = Math.PI * 2 + d7;
        }
        return Math.toDegrees(d7);
    }

    public double getDistance(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(Math.pow(d5, 2.0) + Math.pow(d6, 2.0));
    }

    public void onBattleEnded(BattleEndedEvent battleEndedEvent) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("hitRate.dat"))));){
            objectOutputStream.writeObject(hitRate);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("Could not save hitRate");
        }
    }

    private class Bot {
        public String name;
        public double distance;
        public double velocity;
        public double heading;
        public double yawRate;
        public double energy;
        public double age;
        public double hitRate;
        public double firePower;
        public double threatLevel;
        public double x;
        public double y;
        public double predX;
        public double predY;
        public double bearingFromRadar;
        public double bearingFromGun;
        public double bearingFromSelf;
        public double predBearingFromGun;
        public double predAbsoluteBearingFromSelf;
        public double predBearingFromSelf;

        private Bot() {
        }

        public void updateBearings() {
            double d = KoulDestroyer.this.getAsBearing(this.x, this.y);
            this.bearingFromSelf = Utils.normalRelativeAngleDegrees((double)(d - KoulDestroyer.this.getHeading()));
            this.bearingFromGun = Utils.normalRelativeAngleDegrees((double)(d - KoulDestroyer.this.getGunHeading()));
            this.bearingFromRadar = Utils.normalRelativeAngleDegrees((double)(d - KoulDestroyer.this.getRadarHeading()));
            this.predAbsoluteBearingFromSelf = KoulDestroyer.this.getAsBearing(this.predX, this.predY);
            this.predBearingFromSelf = Utils.normalRelativeAngleDegrees((double)(this.predAbsoluteBearingFromSelf - KoulDestroyer.this.getHeading()));
            this.predBearingFromGun = Utils.normalRelativeAngleDegrees((double)(this.predAbsoluteBearingFromSelf - KoulDestroyer.this.getGunHeading()));
        }
    }

    private static class HitRate
    implements Serializable {
        double hits = 1.0;
        double shots = 1.0;

        private HitRate() {
        }

        public void incHits() {
            this.hits += 1.0;
        }

        public void incShots() {
            this.shots += 1.0;
        }

        public double getRate() {
            return this.hits / this.shots;
        }
    }

    private static enum MoveState {
        RAND1,
        START_RAND2,
        RAND2,
        START_RAND3,
        RAND3,
        AVOID,
        START_RAND1,
        RAM,
        WALL;

    }

    private static enum ScanState {
        START_FIELD,
        FIELD,
        TARGET,
        UPDATE;

    }
}

