/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import florent.test.FUtils;
import florent.test.SegmentationTree;
import florent.test.VisitRecorder;
import florent.test.Wave;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;

public class SpitterWave
extends Wave {
    private static final boolean RUMBLE = true;
    private static final boolean LOAD_DATA = false;
    private static boolean finished = false;
    static final int GF0 = 25;
    static final int GF1 = 50;
    private static int MAX_ROUND_LENGTH = 1500;
    private static Point2D.Double targetLocation;
    private static AdvancedRobot me;
    private static Rectangle2D.Double BF;
    private static double lastVelocity;
    private static int timeSinceVChange;
    private static int timeSinceAccel;
    private static int timeSinceStop;
    private static int time;
    private static int round;
    private static double[] cumulDistance;
    private static VisitRecorder recorder;
    private double dDistance;
    private double dVelocity;
    private double dLatVel;
    private double dAccel;
    private double dWall;
    private double dWallReverse;
    private double dTime;
    private double dPower;
    private double dDistance8;
    private double dDistance15;
    private double dStop;
    private double dTimeAccel;
    private static SegmentationTree tree;
    private static String name;
    private static int lastBearingDirection;
    private double weigth = 1.0;

    static {
        tree = new SegmentationTree(25, 50, 20);
        lastBearingDirection = 1;
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double velocity, double absoluteBearing, double heading, double fireTime) {
        super.init(gun, target, bearingDirection, power, fireTime);
        double latVel = velocity * Math.sin(heading - absoluteBearing);
        int n = latVel == 0.0 ? lastBearingDirection : (this.bearingDirection = latVel > 0.0 ? 1 : -1);
        if (latVel != 0.0) {
            lastBearingDirection = this.bearingDirection;
        }
        this.dDistance = gun.distance(target);
        this.dVelocity = Math.abs(velocity);
        this.dLatVel = Math.abs(velocity * Math.sin(heading - absoluteBearing));
        this.dAccel = Math.abs(velocity) - Math.abs(lastVelocity);
        this.dWall = this.wallDistance(1.0, BF);
        this.dWallReverse = this.wallDistance(-1.0, BF);
        this.dTime = (double)timeSinceVChange * 1.0 / this.travelTime(targetLocation, time);
        this.dStop = 1.0 * (double)timeSinceStop / this.travelTime(targetLocation, time);
        this.dTimeAccel = 1.0 * (double)timeSinceAccel / this.travelTime(targetLocation, time);
        this.updateTime();
        this.dPower = power;
        this.dDistance8 = fireTime > 8.0 ? cumulDistance[(int)fireTime] - cumulDistance[(int)(fireTime - 8.0)] : cumulDistance[(int)fireTime];
        this.dDistance15 = fireTime > 15.0 ? cumulDistance[(int)fireTime] - cumulDistance[(int)(fireTime - 15.0)] : cumulDistance[(int)fireTime];
        lastVelocity = velocity;
    }

    public boolean test() {
        this.updateTime();
        if (this.passed(18.0, time, targetLocation)) {
            double gf = this.visitingGf();
            if (me.getOthers() > 0 && !finished) {
                tree.newEntry(this.dAccel, this.dDistance, this.dTimeAccel, gf, this.dLatVel, this.dTime, this.dVelocity, this.dWall, this.dWallReverse, this.weigth == 1.0, this.dDistance8, this.dStop);
            }
            me.removeCustomEvent((Condition)this);
        }
        return false;
    }

    public double getAngle() {
        int index = tree.getPeak(this.dAccel, this.dDistance, this.dPower, 0.0, this.dLatVel, this.dTime, this.dVelocity, this.dWall, this.dWallReverse, this.dDistance8, this.dStop);
        return ((double)index * 1.0 - 25.0) / 25.0 * this.maxEscapeAngle() * (double)this.bearingDirection;
    }

    private void updateTime() {
        if ((long)time == me.getTime()) {
            return;
        }
        timeSinceVChange = (int)((long)timeSinceVChange + (me.getTime() - (long)time));
        timeSinceAccel = (int)((long)timeSinceAccel + (me.getTime() - (long)time));
        timeSinceStop = (int)((long)timeSinceStop + (me.getTime() - (long)time));
        time = (int)me.getTime();
    }

    public static void onScannedRobot(ScannedRobotEvent e) {
        if (Math.abs(e.getVelocity() - lastVelocity) > 0.5) {
            timeSinceVChange = 0;
        }
        if (e.getVelocity() == 0.0) {
            timeSinceStop = 0;
        }
        if (Math.abs(e.getVelocity()) > Math.abs(lastVelocity)) {
            timeSinceAccel = 0;
        }
        if (e.getTime() > 0L) {
            SpitterWave.cumulDistance[(int)e.getTime()] = cumulDistance[(int)(e.getTime() - 1L)] + e.getVelocity();
        }
        if (round == 0 && name == null) {
            name = e.getName();
        }
    }

    public static void updateTargetLocation(Point2D.Double target) {
        targetLocation = target;
    }

    public static void initClass(AdvancedRobot me) {
        SpitterWave.me = me;
        BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        time = (int)me.getTime();
        round = me.getRoundNum();
        SpitterWave.tree.me = me;
        tree.init();
        if (round > 0) {
            tree.rebuild();
        }
        cumulDistance = new double[MAX_ROUND_LENGTH];
        finished = false;
    }

    public static void endRound() {
        finished = true;
        tree.endRound();
        if (round == me.getNumRounds() - 1) {
            tree.clean();
        }
    }

    protected Point2D.Double getTargetLocation() {
        return targetLocation;
    }

    protected double maxEscapeAngle() {
        return FUtils.maxEscapeAngle(this.velocity) * 1.4;
    }

    public void setAligned(boolean aligned) {
        if (aligned) {
            this.weigth = 5.0;
        }
    }

    protected VisitRecorder getRecorder() {
        return recorder;
    }
}

