/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import florent.test.SegmentationTree;
import java.io.Serializable;

class SymbolicTree
implements Serializable {
    private static final long serialVersionUID = -7361823116265138539L;
    private byte code;
    private SymbolicTree left;
    private SymbolicTree right;

    public SymbolicTree(int code) {
        this.code = (byte)code;
    }

    public SymbolicTree getLeft() {
        return this.left;
    }

    public void setLeft(SymbolicTree left) {
        this.left = left;
    }

    public SymbolicTree getRight() {
        return this.right;
    }

    public void setRight(SymbolicTree right) {
        this.right = right;
    }

    public int getCode() {
        return this.code;
    }

    public void accept(TreeRestoreSymbolicVisitor v) {
        v.visit(this);
    }

    public class TreeRestoreSymbolicVisitor
    implements Runnable {
        private SegmentationTree.Node root;
        private SegmentationTree.NonPreTerminalNode newNode;
        private SegmentationTree fullTree;
        private SymbolicTree tree;

        public TreeRestoreSymbolicVisitor(SymbolicTree tree, SegmentationTree.Node root, SegmentationTree fullTree) {
            this.tree = tree;
            this.root = root;
            this.fullTree = fullTree;
        }

        public void visit(SymbolicTree node) {
            TreeRestoreSymbolicVisitor v;
            this.newNode = this.fullTree.getNode(node.code);
            System.out.println(String.valueOf(this.newNode.toString()) + "|symbolic code:" + node.code);
            if (node.left != null) {
                v = new TreeRestoreSymbolicVisitor(null, null, this.fullTree);
                node.left.accept(v);
                this.newNode.left = v.newNode;
            } else {
                this.newNode.left = new SegmentationTree.StaticNode(this.fullTree);
            }
            if (node.right != null) {
                v = new TreeRestoreSymbolicVisitor(null, null, this.fullTree);
                node.right.accept(v);
                this.newNode.right = v.newNode;
            } else {
                this.newNode.right = new SegmentationTree.StaticNode(this.fullTree);
            }
        }

        public void run() {
            this.tree.accept(this);
            this.fullTree.setRoot(this.newNode);
        }
    }
}

