/*
 * Decompiled with CFR 0.152.
 */
package gun;

import java.awt.geom.Point2D;
import origin.Analysis;
import origin.Enemy;
import origin.Util;
import robocode.Rules;
import util.TimedPoint;

public class vGunAngle {
    public static double headOn(TimedPoint source, Enemy target, double BULLET_POWER) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static double linearPredictionFire(TimedPoint source, Enemy target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double eVelocityY;
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - source.getX();
        double eY = target.getY() - source.getY();
        double eVelocityX = target.getVelocity() * Math.sin(target.getHeading());
        double b = 2.0 * (eX * eVelocityX + eY * (eVelocityY = target.getVelocity() * Math.cos(target.getHeading())));
        double discrim = b * b - 4.0 * (a = eVelocityX * eVelocityX + eVelocityY * eVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = (Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2)) + (double)(source.getTime() - target.getTime());
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + source.getX() + eVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + source.getY() + eVelocityY * time, bounds[2], bounds[3]);
        }
        return Math.atan2(endX - source.getX(), endY - source.getY());
    }

    public static double constantTurnPredict(TimedPoint source, Enemy target, double BULLET_POWER) {
        double turnRate = target.getLatestTurnRate();
        double relX = target.getX() - source.getX();
        double relY = target.getY() - source.getY();
        double cHeading = target.getHeading();
        double velocity = target.getVelocity();
        double selfX = source.getX();
        double selfY = source.getY();
        double deltaTime = 0.0;
        double bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER);
        while (bulletVelocity * deltaTime < Math.abs(Point2D.distance(0.0, 0.0, relX, relY))) {
            relX += velocity * Math.sin(cHeading + turnRate);
            relY += velocity * Math.cos(cHeading + turnRate);
            cHeading += turnRate;
            deltaTime += 1.0;
        }
        Point2D.Double targetCoord = Util.limitCoordinateToMap(new Point2D.Double(relX + selfX, relY + selfY));
        return Math.atan2(targetCoord.getX() - source.getX(), targetCoord.getY() - source.getY());
    }

    public static double averageMovementGun(TimedPoint source, Enemy target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double avgVelocityY;
        double avgVelocity = Analysis.getAvgVelocity(target);
        double avgHeading = Analysis.getAvgHeading(target);
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - source.getX();
        double eY = target.getY() - source.getY();
        double avgVelocityX = avgVelocity * Math.sin(avgHeading);
        double b = 2.0 * (eX * avgVelocityX + eY * (avgVelocityY = avgVelocity * Math.cos(avgHeading)));
        double discrim = b * b - 4.0 * (a = avgVelocityX * avgVelocityX + avgVelocityY * avgVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = (Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2)) + (double)(source.getTime() - target.getTime());
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + source.getX() + avgVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + source.getY() + avgVelocityY * time, bounds[2], bounds[3]);
        }
        return Math.atan2(endX - source.getX(), endY - source.getY());
    }
}

