/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import origin.Enemy;
import origin.EnemyData;
import origin.EnemyWave;
import origin.SleepSiphon;
import origin.Util;
import origin.WeightedPoint;
import robocode.Rules;
import util.TimedWeightedPoint;

public class Analysis {
    private static final double numDataReq = 3.0;

    public static double predictConstantTurn(SleepSiphon self, Enemy target) {
        double futureTurnSpeed = 0.0;
        ArrayList<EnemyData> dataSet = target.getDataSet();
        int dataSetSize = dataSet.size();
        int numDataReq = 5;
        if (dataSet.size() > 6) {
            double[] turnDist = new double[5];
            long[] timeOfData = new long[5];
            long[] timeSinceLastData = new long[5];
            int i = dataSetSize - 5;
            while (i < dataSetSize) {
                turnDist[i - (dataSetSize - 5)] = dataSet.get(dataSetSize - i).getHeading() - dataSet.get(dataSetSize - i - 1).getHeading();
                timeOfData[i - (dataSetSize - 5)] = dataSet.get(dataSetSize - i).getTime();
                timeSinceLastData[i - (dataSetSize - 5)] = dataSet.get(dataSetSize - i).getTime() - dataSet.get(dataSetSize - i - 1).getTime();
                ++i;
            }
            double[] turnSpeed = new double[5];
            int i2 = 0;
            while (i2 < 5) {
                turnSpeed[i2] = turnDist[i2] / (double)(timeOfData[i2] / timeSinceLastData[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                if (!(turnSpeed[i2] <= turnSpeed[i2 + 1] + 10.0) || !(turnSpeed[i2] >= turnSpeed[i2 + 1] - 10.0)) {
                    return 0.0;
                }
                futureTurnSpeed = turnSpeed[i2];
                ++i2;
            }
        }
        return futureTurnSpeed;
    }

    public static double getAvgVelocity(Enemy target) {
        ArrayList<EnemyData> dataSet = target.getDataSet();
        int dataSetSize = dataSet.size();
        double avgVelocity = 0.0;
        if ((double)dataSetSize > 3.0) {
            int i = 0;
            while ((double)i < 3.0) {
                avgVelocity += dataSet.get(dataSetSize - i - 1).getVelocity();
                ++i;
            }
            avgVelocity /= 3.0;
        }
        return avgVelocity;
    }

    public static double getAvgHeading(Enemy target) {
        ArrayList<EnemyData> dataSet = target.getDataSet();
        int dataSetSize = dataSet.size();
        double avgHeading = 0.0;
        if ((double)dataSetSize > 3.0) {
            int i = 0;
            while ((double)i < 3.0) {
                avgHeading += dataSet.get(dataSetSize - i - 1).getHeading();
                ++i;
            }
            avgHeading /= 3.0;
        }
        return avgHeading;
    }

    public static Point2D.Double predictInterceptionPoint_TargetConstantTurn(SleepSiphon self, Enemy target, double turnRate, double bulletPower) {
        double selfX = self.getX();
        double selfY = self.getY();
        double eX = target.getX() - self.getX();
        double eY = target.getY() - self.getY();
        double bulletVelocity = Rules.getBulletSpeed((double)bulletPower);
        double previousX = 0.0;
        double previousY = 0.0;
        double time = 0.0;
        double finalX = eX;
        double finalY = eY;
        double eVX = target.getVelocity() * Math.sin(target.getHeading());
        double eVY = target.getVelocity() * Math.sin(target.getHeading());
        while (Point2D.distance(selfX, selfY, finalX, finalY) >= bulletVelocity * (time - (double)(self.getTime() - target.getTime()))) {
            eVX = target.getVelocity() * Math.sin(target.getHeading() + turnRate * time);
            eVY = target.getVelocity() * Math.cos(target.getHeading() + turnRate * time);
            finalX += eVX;
            finalY += eVY;
            time += 1.0;
        }
        double[] bounds = Util.getFieldBoundsxXyY();
        return new Point2D.Double(Util.limitValueBounds(finalX + selfX, bounds[0], bounds[1]), Util.limitValueBounds(finalY + selfY, bounds[0], bounds[1]));
    }

    public static Point2D calcPointRisk(Point2D point) {
        return point;
    }

    public static Point2D[] calcPathRisk(Point2D[] path) {
        return path;
    }

    public static double calcPoint_repelWalls(double x, double y) {
        double[] bounds = Util.getAbsoluteFieldBoundsxXyY();
        double[] r = new double[]{1.0 / Point2D.distanceSq(x, 0.0, bounds[0], 0.0), 1.0 / Point2D.distanceSq(x, bounds[2], bounds[1], bounds[2]), 1.0 / Point2D.distanceSq(0.0, y, 0.0, bounds[2]), 1.0 / Point2D.distanceSq(bounds[1], y, bounds[1], bounds[3])};
        double totalRisk = 0.0;
        int i = 0;
        while (i < 4) {
            totalRisk += r[i];
            ++i;
        }
        return totalRisk / 4.0;
    }

    public static double[] calcPathRisks_WAVE(TimedWeightedPoint[][] paths, LinkedList<EnemyWave> waveSet, int pointsPerWave, long currentTime) {
        int NUMPATHS = paths.length;
        int NUMINTERVALS = paths[0].length;
        double DIAM = 10.0;
        double BOTDIM = 36.0;
        double[] pathRisks = new double[paths.length];
        int t = 0;
        while (t < NUMINTERVALS) {
            WeightedPoint[][] bulletLocs = new WeightedPoint[waveSet.size()][pointsPerWave];
            Ellipse2D.Double[][] bulletCircles = new Ellipse2D.Double[waveSet.size()][pointsPerWave];
            int i = 0;
            while (i < bulletLocs.length) {
                Point2D.Double[] locs = waveSet.get(i).getBulletLocations(currentTime + paths[0][t].getTime());
                int j = 0;
                while (j < pointsPerWave) {
                    bulletLocs[i][j] = new WeightedPoint(locs[j]);
                    bulletCircles[i][j] = new Ellipse2D.Double(locs[j].getX() - 5.0, locs[j].getY() - 5.0, 10.0, 10.0);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < NUMPATHS) {
                TimedWeightedPoint cPoint = paths[i][t];
                Rectangle2D.Double botAreaAtPoint = new Rectangle2D.Double(cPoint.getX() - 18.0, cPoint.getY() - 18.0, 36.0, 36.0);
                int waveIndex = 0;
                block4: while (waveIndex < waveSet.size()) {
                    int wavePointIndex = 0;
                    while (wavePointIndex < pointsPerWave) {
                        System.out.println("BULLET LOC:\t" + (int)bulletLocs[waveIndex][wavePointIndex].getX() + "\t" + (int)bulletLocs[waveIndex][wavePointIndex].getY());
                        System.out.println("ROBOT LOC:\t" + (int)cPoint.getX() + "\t" + (int)cPoint.getY());
                        if (bulletCircles[waveIndex][wavePointIndex].intersects(botAreaAtPoint)) {
                            cPoint.setWeight(5.5);
                            System.out.println("BULLET INTERSECTS PROJECTED BOT LOCATION");
                            break block4;
                        }
                        ++wavePointIndex;
                    }
                    ++waveIndex;
                }
                cPoint.setWeight(cPoint.getWeight() + Math.random() * 0.1);
                int n = i++;
                pathRisks[n] = pathRisks[n] + cPoint.getWeight();
            }
            ++t;
        }
        return pathRisks;
    }

    public static int getSafestPathIndex(double[] pathRisks) {
        int safestPathIndex = 0;
        double safestRiskValue = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < pathRisks.length) {
            if (pathRisks[i] <= safestRiskValue) {
                safestPathIndex = i;
                safestRiskValue = pathRisks[i];
            }
            ++i;
        }
        return safestPathIndex;
    }

    public static double[] calcPathRisksByDist_WAVE(TimedWeightedPoint[][] paths, LinkedList<EnemyWave> waveSet, int maxPointsPerWave, long currentTime) {
        int NUMPATHS = paths.length;
        int NUMINTERVALS = paths[0].length;
        double[] pathRisks = new double[paths.length];
        int t = 0;
        while (t < NUMINTERVALS) {
            WeightedPoint[][] bulletLocs = new WeightedPoint[waveSet.size()][maxPointsPerWave];
            int i = 0;
            while (i < bulletLocs.length) {
                Point2D.Double[] locs = waveSet.get(i).getBulletLocations(currentTime + paths[0][t].getTime());
                int j = 0;
                while (j < maxPointsPerWave) {
                    bulletLocs[i][j] = new WeightedPoint(locs[j]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < NUMPATHS) {
                TimedWeightedPoint cPoint = paths[i][t];
                int waveIndex = 0;
                while (waveIndex < waveSet.size()) {
                    int wavePointIndex = 0;
                    while (wavePointIndex < maxPointsPerWave) {
                        cPoint.addWeight(1.0 / Point2D.distance(cPoint.getX(), cPoint.getY(), bulletLocs[waveIndex][wavePointIndex].getX(), bulletLocs[waveIndex][wavePointIndex].getY()) * 10.0);
                        ++wavePointIndex;
                    }
                    ++waveIndex;
                }
                int n = i++;
                pathRisks[n] = pathRisks[n] + cPoint.getWeight();
            }
            ++t;
        }
        return pathRisks;
    }

    public static double[] calcPathRisksByDist_BOT(TimedWeightedPoint[][] paths, EnemyData eData, long currentTime) {
        int NUMPATHS = paths.length;
        int NUMINTERVALS = paths[0].length;
        double eX = eData.getX();
        double eY = eData.getY();
        double[] pathRisks = new double[paths.length];
        int t = 0;
        while (t < NUMINTERVALS) {
            int i = 0;
            while (i < NUMPATHS) {
                TimedWeightedPoint cPoint = paths[i][t];
                cPoint.addWeight(1.0 / Point2D.distanceSq(cPoint.getX(), cPoint.getY(), eX, eY) * 1000.0);
                int n = i++;
                pathRisks[n] = pathRisks[n] + cPoint.getWeight();
            }
            ++t;
        }
        return pathRisks;
    }

    public static double[] calcPath_repelCorners(TimedWeightedPoint[][] paths) {
        int NUMPATHS = paths.length;
        int NUMINTERVALS = paths[0].length;
        double[] bounds = Util.getAbsoluteFieldBoundsxXyY();
        double RISK_MULTIPLIER = 500.0;
        double[] pathRisks = new double[paths.length];
        int t = 0;
        while (t < NUMINTERVALS) {
            int i = 0;
            while (i < NUMPATHS) {
                TimedWeightedPoint cPoint = paths[i][t];
                cPoint.addWeight(1.0 / Point2D.distanceSq(cPoint.getX(), cPoint.getY(), bounds[0], bounds[2]) * 500.0);
                cPoint.addWeight(1.0 / Point2D.distanceSq(cPoint.getX(), cPoint.getY(), bounds[0], bounds[3]) * 500.0);
                cPoint.addWeight(1.0 / Point2D.distanceSq(cPoint.getX(), cPoint.getY(), bounds[1], bounds[2]) * 500.0);
                cPoint.addWeight(1.0 / Point2D.distanceSq(cPoint.getX(), cPoint.getY(), bounds[1], bounds[3]) * 500.0);
                int n = i++;
                pathRisks[n] = pathRisks[n] + cPoint.getWeight();
            }
            ++t;
        }
        return pathRisks;
    }

    public static double[] calcPath_repelWalls(TimedWeightedPoint[][] paths) {
        int NUMPATHS = paths.length;
        int NUMINTERVALS = paths[0].length;
        double[] bounds = Util.getAbsoluteFieldBoundsxXyY();
        double RISK_MULTIPLIER = 10.0;
        double[] pathRisks = new double[paths.length];
        int t = 0;
        while (t < NUMINTERVALS) {
            int i = 0;
            while (i < NUMPATHS) {
                TimedWeightedPoint cPoint = paths[i][t];
                cPoint.addWeight(1.0 / Point2D.distance(cPoint.getX(), 0.0, bounds[0], 0.0) * 10.0);
                cPoint.addWeight(1.0 / Point2D.distance(cPoint.getX(), bounds[2], bounds[1], bounds[2]) * 10.0);
                cPoint.addWeight(1.0 / Point2D.distance(0.0, cPoint.getY(), 0.0, bounds[2]) * 10.0);
                cPoint.addWeight(1.0 / Point2D.distance(bounds[1], cPoint.getY(), bounds[1], bounds[3]) * 10.0);
                int n = i++;
                pathRisks[n] = pathRisks[n] + cPoint.getWeight();
            }
            ++t;
        }
        return pathRisks;
    }

    public static double[] sumDoubleArrays(double[] arr1, double[] arr2) {
        if (arr1.length != arr2.length) {
            System.out.println("Error in BetaF.Analysis.sumDoubleArrays:  arr1.length != arr2.length");
            return arr1;
        }
        double[] result = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            result[i] = arr1[i] + arr2[i];
            ++i;
        }
        return result;
    }

    public static double[] getPathRisks(TimedWeightedPoint[][] paths) {
        double[] result = new double[paths.length];
        int i = 0;
        while (i < paths.length) {
            int j = 0;
            while (j < paths[i].length) {
                int n = i;
                result[n] = result[n] + paths[i][j].getWeight();
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void calcPath_NearBot(TimedWeightedPoint[][] paths, Enemy cTargetEnemy) {
        int NUMPATHS = paths.length;
        int NUMINTERVALS = paths[0].length;
        double eX = cTargetEnemy.getX();
        double eY = cTargetEnemy.getY();
        double RISK_MULTIPLIER = 1.0E-4;
        double[] pathRisks = new double[paths.length];
        int t = 0;
        while (t < NUMINTERVALS) {
            int i = 0;
            while (i < NUMPATHS) {
                TimedWeightedPoint cPoint = paths[i][t];
                cPoint.addWeight(Point2D.distance(cPoint.getX(), cPoint.getY(), eX, eY) * 1.0E-4);
                int n = i++;
                pathRisks[n] = pathRisks[n] + cPoint.getWeight();
            }
            ++t;
        }
    }

    public static Ellipse2D.Double[] enemyDistToClosestCircles(ConcurrentHashMap<String, Enemy> enemies) {
        Ellipse2D.Double[] circles = new Ellipse2D.Double[enemies.size()];
        int i = 0;
        for (Map.Entry<String, Enemy> enemy : enemies.entrySet()) {
            double currentX = enemy.getValue().getX();
            double currentY = enemy.getValue().getY();
            String currentName = enemy.getKey();
            double closestDist = Double.POSITIVE_INFINITY;
            String closestName = null;
            for (Map.Entry<String, Enemy> other : enemies.entrySet()) {
                double currentDist = Point2D.distance(other.getValue().getX(), other.getValue().getY(), currentX, currentY);
                if (!(currentDist < closestDist) || currentName == other.getKey()) continue;
                closestDist = currentDist;
                closestName = other.getKey();
            }
            double circleX = currentX - closestDist;
            double circleY = currentY - closestDist;
            double diameter = closestDist * 2.0;
            enemy.getValue().setClosestDist(closestDist);
            circles[i] = new Ellipse2D.Double(circleX, circleY, diameter, diameter);
            ++i;
        }
        return circles;
    }
}

