/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import origin.Analysis;
import origin.Enemy;
import origin.SleepSiphon;
import origin.Util;
import origin.WeightedPoint;
import robocode.Rules;
import robocode.util.Utils;
import util.TimedWeightedPoint;

public class MoveActor {
    static int destinationX = 0;
    static int destinationY = 0;
    private static WeightedPoint[] points = null;
    private static WeightedPoint[] awayPoints = null;
    private static WeightedPoint[] nClosestPoints = null;
    private static WeightedPoint[] wavePoints = null;

    public static void spin(SleepSiphon self) {
        self.setTurnLeft(10000.0);
        self.ahead(10000.0);
    }

    public static void goTo(SleepSiphon self, int x, int y) {
        double a = Math.atan2(x -= (int)self.getX(), y -= (int)self.getY()) - self.getHeadingRadians();
        self.setTurnRightRadians(Math.tan(a));
        self.setAhead(Math.hypot(x, y) * Math.cos(a));
    }

    public static void goTo(SleepSiphon self, double x, double y) {
        double a = Math.atan2(x -= self.getX(), y -= self.getY()) - self.getHeadingRadians();
        self.setTurnRightRadians(Math.tan(a));
        self.setAhead(Math.hypot(x, y) * Math.cos(a));
    }

    public static void aGoTo(SleepSiphon self, double x, double y) {
        double targetAbsBearing = Math.atan2(x -= self.getX(), y -= self.getY());
        double turnToTarget = Utils.normalRelativeAngle((double)(targetAbsBearing - self.getHeadingRadians()));
        double dist = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(turnToTarget));
        self.setTurnRightRadians(turnAngle);
        if (turnToTarget == turnAngle) {
            self.setAhead(dist);
        } else {
            self.setBack(dist);
        }
    }

    public static void random(SleepSiphon self) {
        int botDim = (int)self.getHeight();
        if (self.getDistanceRemaining() == 0.0) {
            MoveActor.goTo(self, botDim + (int)(Math.random() * self.getBattleFieldWidth() - (double)botDim), botDim + (int)(Math.random() * self.getBattleFieldHeight() - (double)botDim));
        }
    }

    public static WeightedPoint[] circularPointDistribution(SleepSiphon self, Enemy enemy) {
        int NUM_POINTS = 16;
        double HYPOT = 150.0;
        if (self.getDistanceRemaining() == 0.0) {
            double centerX = self.getX();
            double centerY = self.getY();
            double enemyX = enemy.getX();
            double enemyY = enemy.getY();
            double botDim = self.getHeight();
            points = new WeightedPoint[16];
            double[] bounds = Util.getFieldBoundsxXyY();
            double cAngle = 0.0;
            double angleIncrement = 0.39269908169872414;
            int point = 0;
            int i = 0;
            while (i < 16) {
                double cX = Util.limitValueBounds(150.0 * Math.sin(cAngle) + centerX, bounds[0], bounds[1]);
                double cY = Util.limitValueBounds(150.0 * Math.cos(cAngle) + centerY, bounds[2], bounds[3]);
                MoveActor.points[i] = new WeightedPoint(cX, cY, 1.0 / Point2D.distance(enemyX, enemyY, cX, cY));
                cAngle += angleIncrement;
                if (points[i].getWeight() < points[point].getWeight()) {
                    point = i;
                }
                ++i;
            }
            point = (int)(Math.random() * 16.0);
            double x = points[point].getX();
            double y = points[point].getY();
            points[point].setWeight(1.0);
            MoveActor.goTo(self, x, y);
        }
        return points;
    }

    public static WeightedPoint[] circularAwayPointDistribution(SleepSiphon self, Enemy enemy, double HYPOT) {
        int NUM_POINTS = 16;
        if (self.getDistanceRemaining() == 0.0 && enemy != null) {
            double centerX = self.getX();
            double centerY = self.getY();
            double enemyX = enemy.getX();
            double enemyY = enemy.getY();
            double botDim = self.getHeight();
            awayPoints = new WeightedPoint[16];
            double[] bounds = Util.getFieldBoundsxXyY();
            double cAngle = 0.0;
            double angleIncrement = 0.39269908169872414;
            int point = 0;
            int i = 0;
            while (i < 16) {
                double cX = Util.limitValueBounds(HYPOT * Math.sin(cAngle) + centerX, bounds[0], bounds[1]);
                double cY = Util.limitValueBounds(HYPOT * Math.cos(cAngle) + centerY, bounds[2], bounds[3]);
                MoveActor.awayPoints[i] = new WeightedPoint(cX, cY, 1.0 / Point2D.distance(enemyX, enemyY, cX, cY));
                cAngle += angleIncrement;
                if (awayPoints[i].getWeight() < awayPoints[point].getWeight()) {
                    point = i;
                }
                ++i;
            }
            double x = awayPoints[point].getX();
            double y = awayPoints[point].getY();
            awayPoints[point].setWeight(1.0);
            MoveActor.goTo(self, x, y);
        }
        return awayPoints;
    }

    public static double findPointRiskBasic(ConcurrentHashMap<String, Enemy> enemies, Point2D.Double point) {
        double risk = 0.0;
        return 0.0;
    }

    public static Point2D.Double[] minimumRiskBasic(SleepSiphon self, ConcurrentHashMap<String, Enemy> enemies) {
        return null;
    }

    public static Point2D.Double[] waveSurfing1v1() {
        return null;
    }

    public static WeightedPoint[] fourCornersLoose(SleepSiphon self) {
        int fw = (int)self.getBattleFieldWidth();
        int fh = (int)self.getBattleFieldHeight();
        int distFromWalls = 40;
        int x = (int)self.getX();
        int y = (int)self.getY();
        if (self.getDistanceRemaining() == 0.0) {
            int section = 0;
            section = Util.currentSection2DUniform(4, x, y, fw, fh);
            switch (section) {
                case -1: {
                    System.out.println("Error: invalid section");
                    break;
                }
                case 0: {
                    destinationX = 40;
                    destinationY = fh - 40;
                    break;
                }
                case 1: {
                    destinationX = fw - 40;
                    destinationY = fh - 40;
                    break;
                }
                case 2: {
                    destinationX = 40;
                    destinationY = 40;
                    break;
                }
                case 3: {
                    destinationX = fw - 40;
                    destinationY = 40;
                }
            }
            MoveActor.goTo(self, destinationX, destinationY);
        }
        return new WeightedPoint[]{new WeightedPoint(destinationX, (double)destinationY)};
    }

    public static void actualdodging() {
    }

    public static WeightedPoint[] circleDistribution_NeverClosest(SleepSiphon self, Ellipse2D.Double[] circles, double HYPOT) {
        int NUM_POINTS = 32;
        if (self.getDistanceRemaining() == 0.0) {
            double centerX = self.getX();
            double centerY = self.getY();
            double botDim = self.getHeight();
            nClosestPoints = new WeightedPoint[32];
            double[] bounds = Util.getFieldBoundsxXyY();
            double cAngle = 0.0;
            double angleIncrement = 0.19634954084936207;
            boolean noPoints = true;
            int count = 0;
            int point = 0;
            while (noPoints && count < 2) {
                int i = 0;
                while (i < 32) {
                    double cX = Util.limitValueBounds(HYPOT * Math.sin(cAngle) + centerX, bounds[0], bounds[1]);
                    double cY = Util.limitValueBounds(HYPOT * Math.cos(cAngle) + centerY, bounds[2], bounds[3]);
                    double cWeight = 0.0;
                    int j = 0;
                    while (j < circles.length) {
                        if (circles[j].contains(cX, cY)) {
                            cWeight = 0.0;
                            break;
                        }
                        cWeight = Math.random();
                        ++j;
                    }
                    MoveActor.nClosestPoints[i] = new WeightedPoint(cX, cY, cWeight);
                    cAngle += angleIncrement;
                    if (nClosestPoints[i].getWeight() > nClosestPoints[point].getWeight()) {
                        point = i;
                    }
                    if (cWeight > 0.0) {
                        noPoints = false;
                    }
                    ++i;
                }
                ++count;
                HYPOT *= 2.0;
            }
            if (noPoints) {
                point = (int)(Math.random() * 32.0);
            }
            double x = nClosestPoints[point].getX();
            double y = nClosestPoints[point].getY();
            nClosestPoints[point].setWeight(1.0);
            MoveActor.aGoTo(self, x, y);
        }
        return nClosestPoints;
    }

    public static TimedWeightedPoint[][] generatePaths(SleepSiphon self, Point2D[] destinationPoints) {
        double maxVelocity = 8.0;
        double accel = 1.0;
        double decel = 2.0;
        int TIME_LIMIT = 16;
        double baseVelocity = self.getVelocity();
        double baseTurnRate = Rules.getTurnRate((double)baseVelocity);
        double baseHeading = self.getHeading();
        double baseSelfX = self.getX();
        double baseSelfY = self.getY();
        TimedWeightedPoint[][] paths = new TimedWeightedPoint[destinationPoints.length][16];
        int cPath = 0;
        while (cPath < destinationPoints.length) {
            double turnAngle;
            double velocity = 8.0;
            double turnRate = baseTurnRate;
            double heading = baseHeading;
            double selfX = baseSelfX;
            double selfY = baseSelfY;
            double destX = destinationPoints[cPath].getX() - selfX;
            double destY = destinationPoints[cPath].getY() - selfY;
            double targetAbsBearing = Math.atan2(destX, destY);
            double turnToTarget = Utils.normalRelativeAngle((double)(targetAbsBearing - self.getHeadingRadians()));
            double dist = Math.hypot(destX, destY);
            double turnRemaining = turnAngle = Math.atan(Math.tan(turnToTarget));
            double angleChange = 0.0;
            int simTime = 0;
            while (simTime < 16) {
                TimedWeightedPoint point = new TimedWeightedPoint(selfX += velocity * Math.sin(targetAbsBearing), selfY += velocity * Math.cos(targetAbsBearing), 0.0, simTime + 1);
                Util.changeCoordinateToMap(point);
                paths[cPath][simTime] = point;
                ++simTime;
            }
            ++cPath;
        }
        return paths;
    }

    public static Point2D.Double[] generatePointsCircular(Point2D center, int numPoints, double HYPOT) {
        double cAngle = 0.0;
        double angleIncrement = Math.PI * 2 / (double)numPoints;
        Point2D.Double[] output = new Point2D.Double[numPoints];
        int i = 0;
        while (i < numPoints) {
            double cX = HYPOT * Math.sin(cAngle) + center.getX();
            double cY = HYPOT * Math.cos(cAngle) + center.getY();
            output[i] = Util.limitCoordinateToMap(cX, cY);
            cAngle += angleIncrement;
            ++i;
        }
        return output;
    }

    public static WeightedPoint[] leastRiskPath(SleepSiphon self, Ellipse2D.Double[] closestToEnemyCircles, double HYPOT) {
        int NUM_POINTS = 32;
        if (self.getDistanceRemaining() == 0.0) {
            double centerX = self.getX();
            double centerY = self.getY();
            double botDim = self.getHeight();
            wavePoints = new WeightedPoint[32];
            double[] bounds = Util.getFieldBoundsxXyY();
            double cAngle = 0.0;
            double angleIncrement = 0.19634954084936207;
            boolean noPoints = true;
            int count = 0;
            int point = 0;
            while (noPoints && count < 2) {
                int i = 0;
                while (i < 32) {
                    double cX = Util.limitValueBounds(HYPOT * Math.sin(cAngle) + centerX, bounds[0], bounds[1]);
                    double cY = Util.limitValueBounds(HYPOT * Math.cos(cAngle) + centerY, bounds[2], bounds[3]);
                    double cWeight = 0.0;
                    int j = 0;
                    while (j < closestToEnemyCircles.length) {
                        if (closestToEnemyCircles[j].contains(cX, cY)) {
                            cWeight = 0.0;
                            break;
                        }
                        cWeight = Math.random();
                        ++j;
                    }
                    MoveActor.wavePoints[i] = new WeightedPoint(cX, cY, cWeight);
                    cAngle += angleIncrement;
                    if (wavePoints[i].getWeight() > wavePoints[point].getWeight()) {
                        point = i;
                    }
                    if (cWeight > 0.0) {
                        noPoints = false;
                    }
                    ++i;
                }
                ++count;
                HYPOT *= 2.0;
            }
            if (noPoints) {
                point = (int)(Math.random() * 32.0);
            }
            double x = wavePoints[point].getX();
            double y = wavePoints[point].getY();
            wavePoints[point].setWeight(1.0);
            MoveActor.aGoTo(self, x, y);
        }
        return wavePoints;
    }

    public static Point2D.Double[] removeCloseCoordinates(Point2D.Double[] dests, double minDistance) {
        ArrayList<Point2D.Double> temp = new ArrayList<Point2D.Double>();
        int i = 1;
        while (i < dests.length) {
            temp.add(dests[i]);
            ++i;
        }
        i = 1;
        while (i < temp.size()) {
            if (Point2D.distance(dests[i].getX(), dests[i].getY(), dests[i - 1].getX(), dests[i - 1].getY()) < minDistance) {
                temp.remove(i);
                temp.remove(i - 1);
            }
            ++i;
        }
        Point2D.Double[] output = new Point2D.Double[temp.size()];
        output = temp.toArray(output);
        return output;
    }

    public static TimedWeightedPoint[] removeCloseCoordinates(TimedWeightedPoint[] dests, double minDistance) {
        ArrayList<TimedWeightedPoint> temp = new ArrayList<TimedWeightedPoint>();
        int i = 1;
        while (i < dests.length) {
            temp.add(dests[i]);
            ++i;
        }
        i = 1;
        while (i < temp.size()) {
            if (Point2D.distance(dests[i].getX(), dests[i].getY(), dests[i - 1].getX(), dests[i - 1].getY()) < minDistance) {
                temp.remove(i);
                temp.remove(i - 1);
            }
            ++i;
        }
        TimedWeightedPoint[] output = new TimedWeightedPoint[temp.size()];
        output = temp.toArray(output);
        return output;
    }

    public static WeightedPoint[] circleDistribution_NeverClosest2(SleepSiphon self, Ellipse2D.Double[] circles, ConcurrentHashMap<String, Enemy> enemies, double HYPOT) {
        int NUM_POINTS = 32;
        Collection<Enemy> eDataSet = enemies.values();
        double centerX = self.getX();
        double centerY = self.getY();
        WeightedPoint[] nClosestPoints2 = new WeightedPoint[32];
        double[] bounds = Util.getFieldBoundsxXyY();
        double cAngle = 0.0;
        double angleIncrement = 0.19634954084936207;
        boolean noPoints = true;
        int count = 0;
        int point = 0;
        while (noPoints && count < 2) {
            int i = 0;
            while (i < 32) {
                double cX = Util.limitValueBounds(HYPOT * Math.sin(cAngle) + centerX, bounds[0], bounds[1]);
                double cY = Util.limitValueBounds(HYPOT * Math.cos(cAngle) + centerY, bounds[2], bounds[3]);
                double cWeight = 0.0;
                int j = 0;
                while (j < circles.length) {
                    if (circles[j].contains(cX, cY)) {
                        cWeight = 2.0;
                    }
                    double tempWeight = 0.0;
                    for (Enemy cEnemy : eDataSet) {
                        tempWeight += 1.0 / Point2D.distanceSq(cX, cY, cEnemy.getX(), cEnemy.getY());
                    }
                    cWeight += tempWeight / (double)eDataSet.size();
                    cWeight += Analysis.calcPoint_repelWalls(cX, cY) * 0.5;
                    ++j;
                }
                nClosestPoints2[i] = new WeightedPoint(cX, cY, cWeight);
                cAngle += angleIncrement;
                if (nClosestPoints2[i].getWeight() < nClosestPoints2[point].getWeight()) {
                    point = i;
                }
                if (cWeight > 0.0) {
                    noPoints = false;
                }
                ++i;
            }
            ++count;
            HYPOT *= 2.0;
        }
        if (noPoints) {
            point = (int)(Math.random() * 32.0);
        }
        double x = nClosestPoints2[point].getX();
        double y = nClosestPoints2[point].getY();
        nClosestPoints2[point].setWeight(0.5);
        MoveActor.aGoTo(self, x, y);
        return nClosestPoints2;
    }
}

